/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class StringEqualsEmptyStringInspection
extends BaseInspection {
    public boolean SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL", (String)InspectionGadgetsBundle.message("string.equals.empty.string.option.do.not.add.null.check", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        if (useIsEmpty) {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.is.empty.problem.descriptor", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
        if (string == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        boolean addNullCheck = (Boolean)infos[1];
        StringEqualsEmptyStringFix mainFix = new StringEqualsEmptyStringFix(useIsEmpty, addNullCheck);
        if (addNullCheck) {
            LocalQuickFix disableFix = LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL", InspectionGadgetsBundle.message("string.equals.empty.string.option.do.not.add.null.check", new Object[0]), true));
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{mainFix, disableFix};
            if (localQuickFixArray == null) {
                StringEqualsEmptyStringInspection.$$$reportNull$$$0(3);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{mainFix};
        if (localQuickFixArray == null) {
            StringEqualsEmptyStringInspection.$$$reportNull$$$0(4);
        }
        return localQuickFixArray;
    }

    private static PsiExpression getCheckedExpression(boolean useIsEmpty, PsiExpression expression) {
        if (useIsEmpty || !(expression instanceof PsiMethodCallExpression)) {
            return expression;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        String referenceName = methodExpression.getReferenceName();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null) {
            return expression;
        }
        PsiType type = qualifierExpression.getType();
        if ("toString".equals(referenceName) && type != null && (type.equalsToText("java.lang.StringBuffer") || type.equalsToText("java.lang.StringBuilder"))) {
            return qualifierExpression;
        }
        return expression;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StringEqualsEmptyStringFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myUseIsEmpty;
        private final boolean myAddNullCheck;

        StringEqualsEmptyStringFix(boolean useIsEmpty, boolean addNullCheck) {
            this.myUseIsEmpty = useIsEmpty;
            this.myAddNullCheck = addNullCheck;
        }

        @NotNull
        public String getName() {
            if (this.myUseIsEmpty) {
                String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isEmpty()"});
                if (string == null) {
                    StringEqualsEmptyStringFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"length()==0"});
            if (string == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.fix.family.name", new Object[0]);
            if (string == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiExpression expressionToReplace;
            StringBuilder newExpression;
            boolean isNegation;
            PsiReferenceExpression expression;
            if (project == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                StringEqualsEmptyStringFix.$$$reportNull$$$0(5);
            }
            if ((expression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiReferenceExpression.class)) == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpression[] arguments = call.getArgumentList().getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiExpression checkedExpression = ExpressionUtils.isEmptyStringLiteral(argument) ? StringEqualsEmptyStringInspection.getCheckedExpression(this.myUseIsEmpty, qualifier) : StringEqualsEmptyStringInspection.getCheckedExpression(this.myUseIsEmpty, argument);
            CommentTracker ct = new CommentTracker();
            PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)call.getParent(), PsiExpression.class);
            boolean bl = isNegation = parent != null && BoolUtils.isNegation(parent);
            if (this.myAddNullCheck) {
                newExpression = new StringBuilder(ct.text(checkedExpression, 9));
                newExpression.append(isNegation ? "==null||" : "!=null&&");
            } else {
                newExpression = new StringBuilder();
            }
            String expressionText = ct.text(checkedExpression, 1);
            if (isNegation) {
                expressionToReplace = parent;
                if (this.myUseIsEmpty) {
                    newExpression.append('!').append(expressionText).append(".isEmpty()");
                } else {
                    newExpression.append(expressionText).append(".length()!=0");
                }
            } else {
                expressionToReplace = call;
                if (this.myUseIsEmpty) {
                    newExpression.append(expressionText).append(".isEmpty()");
                } else {
                    newExpression.append(expressionText).append(".length()==0");
                }
            }
            PsiReplacementUtil.replaceExpression(expressionToReplace, newExpression.toString(), ct);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                StringEqualsEmptyStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement context = call.getParent();
            boolean useIsEmpty = PsiUtil.getLanguageLevel((PsiElement)call).isAtLeast(LanguageLevel.JDK_1_6);
            if (!useIsEmpty && context instanceof PsiExpressionStatement) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            boolean addNullCheck = false;
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(qualifier)) {
                PsiType type = argument.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
                PsiExpression expression = StringEqualsEmptyStringInspection.getCheckedExpression(useIsEmpty, argument);
                boolean bl = addNullCheck = expression == argument && NullabilityUtil.getExpressionNullability(expression, true) != Nullability.NOT_NULL;
                if (addNullCheck && !ExpressionUtils.isSafelyRecomputableExpression(expression)) {
                    return;
                }
            } else if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                if (qualifier == null) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
            } else {
                return;
            }
            if (addNullCheck && StringEqualsEmptyStringInspection.this.SUPPRESS_FOR_VALUES_WHICH_COULD_BE_NULL) {
                return;
            }
            this.registerMethodCallError(call, useIsEmpty, addNullCheck);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringVisitor", "visitMethodCallExpression"));
        }
    }
}

