/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.codeInspection.ConditionalBreakInInfiniteLoopInspection;
import com.intellij.codeInspection.RedundantLambdaCodeBlockInspection;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTemplate;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.style.ConditionalExpressionGenerator;
import com.siyeh.ig.style.IfConditionalModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeBlockSurrounder {
    @NotNull
    final PsiExpression myExpression;

    CodeBlockSurrounder(@NotNull PsiExpression expression) {
        if (expression == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(0);
        }
        this.myExpression = expression;
    }

    @NotNull
    ParentContext getExpectedParentContext() {
        PsiIfStatement ifStatement;
        PsiLocalVariable var;
        PsiElement parent = this.myExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && parent.getParent() instanceof PsiExpressionStatement && !(parent.getParent().getParent() instanceof PsiSwitchLabeledRuleStatement) && ((PsiAssignmentExpression)parent).getRExpression() == this.myExpression) {
            ParentContext parentContext = ParentContext.ASSIGNMENT;
            if (parentContext == null) {
                CodeBlockSurrounder.$$$reportNull$$$0(1);
            }
            return parentContext;
        }
        if (parent instanceof PsiLocalVariable && (!(var = (PsiLocalVariable)parent).getTypeElement().isInferredType() || PsiTypesUtil.isDenotableType((PsiType)var.getType(), (PsiElement)parent))) {
            ParentContext parentContext = ParentContext.ASSIGNMENT;
            if (parentContext == null) {
                CodeBlockSurrounder.$$$reportNull$$$0(2);
            }
            return parentContext;
        }
        if (parent instanceof PsiReturnStatement || parent instanceof PsiYieldStatement || parent instanceof PsiThrowStatement) {
            ParentContext parentContext = ParentContext.RETURN;
            if (parentContext == null) {
                CodeBlockSurrounder.$$$reportNull$$$0(3);
            }
            return parentContext;
        }
        if (parent instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getThenBranch() != null) {
            PsiPolyadicExpression polyadic;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                ParentContext parentContext = ParentContext.SIMPLE_IF_CONDITION;
                if (parentContext == null) {
                    CodeBlockSurrounder.$$$reportNull$$$0(4);
                }
                return parentContext;
            }
            PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myExpression);
            if (!(psiExpression instanceof PsiPolyadicExpression) || !(polyadic = (PsiPolyadicExpression)psiExpression).getOperationTokenType().equals(JavaTokenType.ANDAND)) {
                ParentContext parentContext = ParentContext.UNKNOWN;
                if (parentContext == null) {
                    CodeBlockSurrounder.$$$reportNull$$$0(5);
                }
                return parentContext;
            }
            if (CodeBlockSurrounder.isExclusiveElseBranch(polyadic.getOperands()[0], elseBranch)) {
                ParentContext parentContext = ParentContext.SIMPLE_IF_CONDITION;
                if (parentContext == null) {
                    CodeBlockSurrounder.$$$reportNull$$$0(6);
                }
                return parentContext;
            }
        }
        ParentContext parentContext = ParentContext.UNKNOWN;
        if (parentContext == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(7);
        }
        return parentContext;
    }

    private static boolean isExclusiveElseBranch(@NotNull PsiExpression condition, @Nullable PsiStatement branch) {
        if (condition == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(8);
        }
        while (branch != null && !ControlFlowUtils.statementIsEmpty(branch)) {
            PsiStatement psiStatement = ControlFlowUtils.stripBraces(branch);
            if (!(psiStatement instanceof PsiIfStatement)) {
                return false;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)psiStatement;
            PsiExpression nextCondition = ifStatement.getCondition();
            if (nextCondition == null) {
                return false;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (!DfaPsiUtil.mutuallyExclusive(condition, nextCondition)) {
                return false;
            }
            branch = elseBranch;
        }
        return true;
    }

    @NotNull
    public SurroundResult surround() {
        Object marker = ObjectUtils.sentinel((String)"CodeBlockSurrounder.MARKER");
        PsiExpression expr = PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myExpression);
        if (expr == null) {
            expr = this.myExpression;
        }
        PsiTreeUtil.mark((PsiElement)expr, (Object)marker);
        Project project = this.myExpression.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        boolean physical = this.myExpression.isPhysical();
        PsiStatement replacement = this.replace(project, factory);
        assert (replacement.isPhysical() == physical);
        PsiElement anchor = this.anchor(replacement);
        PsiExpression newExpression = Objects.requireNonNull((PsiExpression)PsiTreeUtil.releaseMark((PsiElement)replacement, (Object)marker));
        return new SurroundResult(newExpression, replacement, anchor, this);
    }

    @NotNull
    PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
        if (project == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    PsiElement anchor(@NotNull PsiStatement context) {
        if (context == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(11);
        }
        PsiStatement psiStatement = context;
        if (psiStatement == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(12);
        }
        return psiStatement;
    }

    void collapse(@NotNull PsiElement anchor) {
        if (anchor == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(13);
        }
    }

    public static boolean canSurround(@NotNull PsiExpression expression) {
        if (expression == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(14);
        }
        return CodeBlockSurrounder.forExpression(expression) != null;
    }

    @Nullable
    public static CodeBlockSurrounder forExpression(@NotNull PsiExpression expression) {
        PsiElement typeElement;
        PsiIfStatement ifStatement;
        PsiForeachStatement foreachStatement;
        PsiWhileStatement whileStatement;
        PsiForStatement forStatement;
        PsiElement grandParent;
        if (expression == null) {
            CodeBlockSurrounder.$$$reportNull$$$0(15);
        }
        PsiExpression cur = expression;
        PsiElement parent = cur.getParent();
        while (parent instanceof PsiExpression || parent instanceof PsiExpressionList || parent instanceof PsiTemplate) {
            PsiConditionalExpression conditional;
            if (parent instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)parent;
                return new LambdaCodeBlockSurrounder(expression, lambda);
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                IElementType type = polyadicExpression.getOperationTokenType();
                if (type.equals(JavaTokenType.ANDAND) && polyadicExpression.getOperands()[0] != cur) {
                    PsiElement conditionParent = PsiUtil.skipParenthesizedExprUp((PsiElement)polyadicExpression.getParent());
                    if (conditionParent instanceof PsiWhileStatement) {
                        PsiWhileStatement whileStatement2 = (PsiWhileStatement)conditionParent;
                        return new WhileConditionSurrounder(expression, whileStatement2);
                    }
                    CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)polyadicExpression);
                    if (parentSurrounder == null) {
                        return null;
                    }
                    ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                    if (parentContext != ParentContext.RETURN && parentContext != ParentContext.SIMPLE_IF_CONDITION) {
                        return null;
                    }
                    return new AndOrToIfSurrounder(expression, polyadicExpression, parentSurrounder);
                }
                if (type.equals(JavaTokenType.OROR) && polyadicExpression.getOperands()[0] != cur) {
                    CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)polyadicExpression);
                    if (parentSurrounder == null) {
                        return null;
                    }
                    ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                    if (parentContext != ParentContext.RETURN) {
                        return null;
                    }
                    return new AndOrToIfSurrounder(expression, polyadicExpression, parentSurrounder);
                }
            }
            if (parent instanceof PsiConditionalExpression && (conditional = (PsiConditionalExpression)parent).getCondition() != cur) {
                CodeBlockSurrounder parentSurrounder = CodeBlockSurrounder.forExpressionSkipParentheses((PsiExpression)conditional);
                if (parentSurrounder == null) {
                    return null;
                }
                ParentContext parentContext = parentSurrounder.getExpectedParentContext();
                if (parentContext != ParentContext.ASSIGNMENT && parentContext != ParentContext.RETURN) {
                    return null;
                }
                return new TernaryToIfSurrounder(expression, conditional, parentSurrounder);
            }
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)parent) && !PsiUtil.isAvailable((JavaFeature)JavaFeature.STATEMENTS_BEFORE_SUPER, (PsiElement)parent)) {
                return null;
            }
            cur = parent;
            parent = cur.getParent();
        }
        if (parent instanceof PsiEnumConstant) {
            return new AnonymousCallSurrounder(expression);
        }
        if (parent instanceof PsiStatement && (grandParent = parent.getParent()) instanceof PsiForStatement && (forStatement = (PsiForStatement)grandParent).getUpdate() == parent) {
            return null;
        }
        if (parent instanceof PsiWhileStatement && (whileStatement = (PsiWhileStatement)parent).getCondition() == cur) {
            return new WhileConditionSurrounder(expression, whileStatement);
        }
        if (parent instanceof PsiForeachStatement && (foreachStatement = (PsiForeachStatement)parent).getIteratedValue() == cur || parent instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)parent).getCondition() == cur || parent instanceof PsiReturnStatement || parent instanceof PsiExpressionStatement || parent instanceof PsiYieldStatement || parent instanceof PsiThrowStatement) {
            return CodeBlockSurrounder.forStatement((PsiStatement)parent, expression);
        }
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)parent;
            PsiDeclarationStatement decl = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiDeclarationStatement.class);
            if (!(decl == null || ArrayUtil.getFirstElement((Object[])decl.getDeclaredElements()) != parent || (typeElement = variable.getTypeElement()).isInferredType() && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)((PsiLocalVariable)parent.copy()).getTypeElement()) == null)) {
                PsiForStatement forStatement2;
                PsiElement declParent = decl.getParent();
                if (declParent instanceof PsiForStatement && (forStatement2 = (PsiForStatement)declParent).getInitialization() == decl) {
                    if (CodeBlockSurrounder.hasNameCollision((PsiElement)decl, declParent.getParent())) {
                        return new SimpleSurrounder(expression, (PsiStatement)forStatement2);
                    }
                    return CodeBlockSurrounder.forStatement((PsiStatement)declParent, expression);
                }
                return CodeBlockSurrounder.forStatement((PsiStatement)decl, expression);
            }
        }
        if (parent instanceof PsiResourceVariable) {
            PsiResourceList list = (PsiResourceList)ObjectUtils.tryCast((Object)parent.getParent(), PsiResourceList.class);
            if (list != null && (typeElement = list.getParent()) instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)typeElement;
                Iterator iterator = list.iterator();
                if (iterator.hasNext() && iterator.next() == parent && tryStatement.getCatchBlocks().length == 0 && tryStatement.getFinallyBlock() == null) {
                    return CodeBlockSurrounder.forStatement((PsiStatement)tryStatement, expression);
                }
                return new SplitTrySurrounder(expression, (PsiResourceVariable)parent, tryStatement);
            }
            return null;
        }
        if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || containingClass instanceof PsiImplicitClass || containingClass.isInterface()) {
                return null;
            }
            if (containingClass.isRecord() && !field.hasModifierProperty("static")) {
                return null;
            }
            return new ExtractFieldInitializerSurrounder(expression, field);
        }
        return null;
    }

    @Nullable
    private static CodeBlockSurrounder forExpressionSkipParentheses(PsiExpression expression) {
        while (expression.getParent() instanceof PsiParenthesizedExpression) {
            expression = (PsiExpression)expression.getParent();
        }
        return CodeBlockSurrounder.forExpression(expression);
    }

    private static boolean hasNameCollision(PsiElement declaration, PsiElement context) {
        if (declaration instanceof PsiDeclarationStatement) {
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)context.getProject()).getResolveHelper();
            return StreamEx.of((Object[])((PsiDeclarationStatement)declaration).getDeclaredElements()).select(PsiLocalVariable.class).map(PsiLocalVariable::getName).nonNull().anyMatch(name -> helper.resolveAccessibleReferencedVariable(name, context) != null);
        }
        return false;
    }

    private static CodeBlockSurrounder forStatement(PsiStatement statement, PsiExpression expression) {
        PsiElement statementParent = statement.getParent();
        PsiForStatement forStatement = (PsiForStatement)ObjectUtils.tryCast((Object)statementParent, PsiForStatement.class);
        if (statementParent instanceof PsiLabeledStatement || forStatement != null && forStatement.getBody() != statement) {
            statement = (PsiStatement)statementParent;
            statementParent = statement.getParent();
        }
        if (statementParent instanceof PsiCodeBlock) {
            return new NoOpSurrounder(expression, statement);
        }
        if (statement instanceof PsiExpressionStatement && statementParent instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)statementParent).getEnclosingSwitchBlock() instanceof PsiSwitchExpression) {
            return new YieldSurrounder(expression, (PsiExpressionStatement)statement);
        }
        return new SimpleSurrounder(expression, statement);
    }

    @Nullable
    private static PsiStatement collapseIf(PsiIfStatement ifStatement, String ... operators) {
        IfConditionalModel model = IfConditionalModel.from(ifStatement, false);
        if (model == null) {
            return null;
        }
        ConditionalExpressionGenerator generator = ConditionalExpressionGenerator.from(model);
        if (generator == null) {
            return null;
        }
        String operator = generator.getTokenType();
        if (!ArrayUtil.contains((String)operator, (String[])operators)) {
            return null;
        }
        CommentTracker commentTracker = new CommentTracker();
        String conditional = generator.generate(commentTracker);
        commentTracker.replace((PsiElement)model.getThenExpression(), conditional);
        PsiStatement branch = model.getElseBranch();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement, (PsiElement)branch, (boolean)true)) {
            commentTracker.delete((PsiElement)branch);
        }
        return (PsiStatement)commentTracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)model.getThenBranch());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedParentContext";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isExclusiveElseBranch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "anchor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collapse";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canSurround";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "forExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 12 -> new IllegalStateException(string);
        };
    }

    private static enum ParentContext {
        RETURN,
        ASSIGNMENT,
        EXPRESSION,
        SIMPLE_IF_CONDITION,
        UNKNOWN;

    }

    public static class SurroundResult {
        @NotNull
        private final PsiExpression myExpression;
        @NotNull
        private final PsiStatement myAnchor;
        @NotNull
        private final PsiElement myContext;
        @Nullable
        private final CodeBlockSurrounder mySurrounder;

        SurroundResult(@NotNull PsiExpression expression, @NotNull PsiStatement anchor, @NotNull PsiElement context, @Nullable CodeBlockSurrounder surrounder) {
            if (expression == null) {
                SurroundResult.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                SurroundResult.$$$reportNull$$$0(1);
            }
            if (context == null) {
                SurroundResult.$$$reportNull$$$0(2);
            }
            this.myExpression = expression;
            this.myAnchor = anchor;
            this.myContext = context;
            this.mySurrounder = surrounder;
        }

        @NotNull
        public PsiExpression getExpression() {
            PsiExpression psiExpression = this.myExpression;
            if (psiExpression == null) {
                SurroundResult.$$$reportNull$$$0(3);
            }
            return psiExpression;
        }

        @NotNull
        public PsiStatement getAnchor() {
            PsiStatement psiStatement = this.myAnchor;
            if (psiStatement == null) {
                SurroundResult.$$$reportNull$$$0(4);
            }
            return psiStatement;
        }

        public void collapse() {
            if (this.mySurrounder != null && this.myContext.isValid()) {
                this.mySurrounder.collapse(this.myContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SurroundResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SurroundResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class LambdaCodeBlockSurrounder
    extends CodeBlockSurrounder {
        @NotNull
        private final PsiLambdaExpression myLambda;
        private final boolean myVoidMode;

        LambdaCodeBlockSurrounder(@NotNull PsiExpression expression, @NotNull PsiLambdaExpression lambda) {
            if (expression == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(0);
            }
            if (lambda == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(1);
            }
            super(expression);
            this.myLambda = lambda;
            this.myVoidMode = PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)this.myLambda));
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            PsiElement parent = this.myExpression.getParent();
            if (parent == this.myLambda) {
                ParentContext parentContext = this.myVoidMode ? ParentContext.EXPRESSION : ParentContext.RETURN;
                if (parentContext == null) {
                    LambdaCodeBlockSurrounder.$$$reportNull$$$0(2);
                }
                return parentContext;
            }
            ParentContext parentContext = super.getExpectedParentContext();
            if (parentContext == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(3);
            }
            return parentContext;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(5);
            }
            @NonNls String replacementText = this.myVoidMode ? "{a;}" : "{return a;}";
            PsiCodeBlock newBody = factory.createCodeBlockFromText(replacementText, (PsiElement)this.myLambda);
            LambdaUtil.extractSingleExpressionFromBody((PsiElement)newBody).replace(Objects.requireNonNull(this.myLambda.getBody()));
            newBody = (PsiCodeBlock)this.myLambda.getBody().replace((PsiElement)newBody);
            PsiStatement psiStatement = newBody.getStatements()[0];
            if (psiStatement == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(6);
            }
            return psiStatement;
        }

        @NotNull
        PsiLambdaExpression anchor(@NotNull PsiStatement context) {
            if (context == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(7);
            }
            PsiLambdaExpression psiLambdaExpression = (PsiLambdaExpression)context.getParent().getParent();
            if (psiLambdaExpression == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(8);
            }
            return psiLambdaExpression;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiLambdaExpression lambda;
            if (anchor == null) {
                LambdaCodeBlockSurrounder.$$$reportNull$$$0(9);
            }
            if ((lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)anchor, PsiLambdaExpression.class)) == null) {
                return;
            }
            PsiElement body = lambda.getBody();
            PsiExpression expression = RedundantLambdaCodeBlockInspection.isCodeBlockRedundant(body);
            if (expression != null) {
                body.replace((PsiElement)expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambda";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$LambdaCodeBlockSurrounder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$LambdaCodeBlockSurrounder";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedParentContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class WhileConditionSurrounder
    extends CodeBlockSurrounder {
        private final PsiWhileStatement myStatement;

        WhileConditionSurrounder(@NotNull PsiExpression expression, @NotNull PsiWhileStatement whileStatement) {
            if (expression == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(0);
            }
            if (whileStatement == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(1);
            }
            super(expression);
            this.myStatement = whileStatement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiExpression rOperands;
            PsiExpression lOperands;
            PsiBlockStatement blockBody;
            PsiPolyadicExpression polyadic;
            if (project == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(3);
            }
            PsiWhileStatement whileStatement = this.myStatement;
            PsiExpression oldCondition = Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)whileStatement.getCondition()));
            PsiStatement body = whileStatement.getBody();
            int operandIndex = -1;
            if (oldCondition instanceof PsiPolyadicExpression && (polyadic = (PsiPolyadicExpression)oldCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) {
                PsiExpression[] operands = polyadic.getOperands();
                operandIndex = ContainerUtil.indexOf(Arrays.asList(operands), o -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)this.myExpression, (boolean)false));
            }
            if (body == null) {
                PsiWhileStatement newWhileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", (PsiElement)whileStatement);
                Objects.requireNonNull(newWhileStatement.getCondition()).replace((PsiElement)oldCondition);
                whileStatement = (PsiWhileStatement)whileStatement.replace((PsiElement)newWhileStatement);
                blockBody = (PsiBlockStatement)Objects.requireNonNull(whileStatement.getBody());
                oldCondition = Objects.requireNonNull(whileStatement.getCondition());
            } else if (body instanceof PsiBlockStatement) {
                blockBody = (PsiBlockStatement)body;
            } else {
                PsiBlockStatement newBody = BlockUtils.createBlockStatement((Project)project);
                newBody.getCodeBlock().add((PsiElement)body);
                blockBody = (PsiBlockStatement)body.replace((PsiElement)newBody);
            }
            if (operandIndex > 0) {
                PsiPolyadicExpression polyadic2 = (PsiPolyadicExpression)oldCondition;
                PsiExpression operand = polyadic2.getOperands()[operandIndex];
                PsiJavaToken token = Objects.requireNonNull(polyadic2.getTokenBeforeOperand(operand));
                lOperands = SplitConditionUtil.getLOperands(polyadic2, token);
                rOperands = AndOrToIfSurrounder.getRightOperands(polyadic2, operand);
            } else {
                lOperands = factory.createExpressionFromText("true", (PsiElement)whileStatement);
                rOperands = oldCondition;
            }
            PsiCodeBlock codeBlock = blockBody.getCodeBlock();
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(!true) break;", (PsiElement)whileStatement);
            ifStatement = (PsiIfStatement)codeBlock.addAfter((PsiElement)ifStatement, (PsiElement)codeBlock.getLBrace());
            PsiPrefixExpression negation = (PsiPrefixExpression)Objects.requireNonNull(ifStatement.getCondition());
            Objects.requireNonNull(negation.getOperand()).replace((PsiElement)rOperands);
            Objects.requireNonNull(whileStatement.getCondition()).replace((PsiElement)lOperands);
            PsiIfStatement psiIfStatement = ifStatement;
            if (psiIfStatement == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(4);
            }
            return psiIfStatement;
        }

        @NotNull
        PsiWhileStatement anchor(@NotNull PsiStatement context) {
            if (context == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(5);
            }
            PsiWhileStatement psiWhileStatement = (PsiWhileStatement)context.getParent().getParent().getParent();
            if (psiWhileStatement == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(6);
            }
            return psiWhileStatement;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiWhileStatement whileStatement;
            if (anchor == null) {
                WhileConditionSurrounder.$$$reportNull$$$0(7);
            }
            if ((whileStatement = (PsiWhileStatement)ObjectUtils.tryCast((Object)anchor, PsiWhileStatement.class)) != null) {
                ConditionalBreakInInfiniteLoopInspection.tryTransform(whileStatement);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whileStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$WhileConditionSurrounder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$WhileConditionSurrounder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class AndOrToIfSurrounder
    extends CodeBlockSurrounder {
        @NotNull
        private final PsiPolyadicExpression myPolyadicExpression;
        @NotNull
        private final CodeBlockSurrounder myUpstream;
        private PsiIfStatement myCreatedIf;

        AndOrToIfSurrounder(@NotNull PsiExpression expression, @NotNull PsiPolyadicExpression polyadicExpression, @NotNull CodeBlockSurrounder upstream) {
            if (expression == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(0);
            }
            if (polyadicExpression == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(1);
            }
            if (upstream == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(2);
            }
            super(expression);
            this.myPolyadicExpression = polyadicExpression;
            this.myUpstream = upstream;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            ParentContext parentContext = this.myExpression.getParent() == this.myPolyadicExpression ? this.myUpstream.getExpectedParentContext() : super.getExpectedParentContext();
            if (parentContext == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(3);
            }
            return parentContext;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(4);
            }
            if (factory == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(5);
            }
            Object[] operands = this.myPolyadicExpression.getOperands();
            int index = (int)StreamEx.of((Object[])operands).indexOf(o -> PsiTreeUtil.isAncestor((PsiElement)o, (PsiElement)this.myExpression, (boolean)false)).orElseThrow(IllegalStateException::new);
            SurroundResult upstreamResult = this.myUpstream.surround();
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)upstreamResult.getExpression()));
            PsiStatement statement = upstreamResult.getAnchor();
            PsiExpression operand = polyadicExpression.getOperands()[index];
            PsiExpression lOperands = SplitConditionUtil.getLOperands(polyadicExpression, Objects.requireNonNull(polyadicExpression.getTokenBeforeOperand(operand)));
            PsiExpression rOperands = AndOrToIfSurrounder.getRightOperands(polyadicExpression, operand);
            if (statement instanceof PsiIfStatement) {
                return AndOrToIfSurrounder.splitIf((PsiIfStatement)statement, polyadicExpression, lOperands, rOperands, project, factory);
            }
            assert (statement instanceof PsiReturnStatement || statement instanceof PsiYieldStatement);
            return this.splitReturn(statement, polyadicExpression, lOperands, rOperands, project, factory);
        }

        @NotNull
        private static PsiStatement splitIf(@NotNull PsiIfStatement outerIf, @NotNull PsiPolyadicExpression andChain, @NotNull PsiExpression lOperands, @NotNull PsiExpression rOperands, @NotNull Project project, @NotNull PsiElementFactory factory) {
            if (outerIf == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(6);
            }
            if (andChain == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(7);
            }
            if (lOperands == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(8);
            }
            if (rOperands == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(9);
            }
            if (project == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(10);
            }
            if (factory == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(11);
            }
            PsiBlockStatement newThenBranch = (PsiBlockStatement)factory.createStatementFromText("{if(true);}", (PsiElement)outerIf);
            PsiStatement thenBranch = Objects.requireNonNull(outerIf.getThenBranch());
            Objects.requireNonNull(((PsiIfStatement)newThenBranch.getCodeBlock().getStatements()[0]).getThenBranch()).replace((PsiElement)thenBranch);
            newThenBranch = (PsiBlockStatement)thenBranch.replace((PsiElement)newThenBranch);
            PsiIfStatement innerIf = Objects.requireNonNull((PsiIfStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newThenBranch.getCodeBlock().getStatements()[0]), (Class[])new Class[]{PsiIfStatement.class}));
            Objects.requireNonNull(innerIf.getCondition()).replace((PsiElement)rOperands);
            andChain.replace((PsiElement)lOperands);
            PsiIfStatement psiIfStatement = innerIf;
            if (psiIfStatement == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(12);
            }
            return psiIfStatement;
        }

        @NotNull
        private PsiStatement splitReturn(@NotNull PsiStatement returnOrYieldStatement, @NotNull PsiPolyadicExpression condition, @NotNull PsiExpression lOperands, @NotNull PsiExpression rOperands, @NotNull Project project, @NotNull PsiElementFactory factory) {
            if (returnOrYieldStatement == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(13);
            }
            if (condition == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(14);
            }
            if (lOperands == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(15);
            }
            if (rOperands == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(16);
            }
            if (project == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(17);
            }
            if (factory == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(18);
            }
            CommentTracker ct = new CommentTracker();
            boolean orChain = condition.getOperationTokenType().equals(JavaTokenType.OROR);
            String keyword = returnOrYieldStatement.getFirstChild().getText();
            String extractedCondition = orChain ? ct.text((PsiElement)lOperands) : BoolUtils.getNegatedExpressionText(lOperands, ct);
            String ifText = "if(" + extractedCondition + ") " + keyword + " " + orChain + ";";
            PsiStatement ifStatement = factory.createStatementFromText(ifText, (PsiElement)returnOrYieldStatement);
            this.myCreatedIf = (PsiIfStatement)CodeStyleManager.getInstance((Project)project).reformat(returnOrYieldStatement.getParent().addBefore((PsiElement)ifStatement, (PsiElement)returnOrYieldStatement));
            ct.replaceAndRestoreComments((PsiElement)Objects.requireNonNull(condition), (PsiElement)rOperands);
            PsiStatement psiStatement = returnOrYieldStatement;
            if (psiStatement == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(19);
            }
            return psiStatement;
        }

        private static PsiExpression getRightOperands(PsiPolyadicExpression andChain, PsiExpression operand) {
            PsiExpression rOperands;
            if (operand == ArrayUtil.getLastElement((Object[])andChain.getOperands())) {
                rOperands = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
            } else {
                rOperands = SplitConditionUtil.getROperands(andChain, andChain.getTokenBeforeOperand(operand));
                ((PsiPolyadicExpression)rOperands).getOperands()[0].replace((PsiElement)operand);
            }
            return rOperands;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiIfStatement ifStatement;
            PsiIfStatement innerIf;
            if (anchor == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(20);
            }
            if (anchor instanceof PsiIfStatement && (innerIf = (PsiIfStatement)anchor).getElseBranch() == null) {
                PsiIfStatement outerIf;
                PsiIfStatement psiIfStatement;
                PsiCodeBlock block;
                PsiElement psiElement = innerIf.getParent();
                if (psiElement instanceof PsiCodeBlock && (block = (PsiCodeBlock)psiElement).getStatementCount() == 1 && (psiElement = block.getParent()) instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)psiElement;
                    psiIfStatement = blockStatement;
                } else {
                    psiIfStatement = innerIf;
                }
                PsiIfStatement thenBranch = psiIfStatement;
                PsiElement psiElement2 = thenBranch.getParent();
                if (psiElement2 instanceof PsiIfStatement && (outerIf = (PsiIfStatement)psiElement2).getThenBranch() == thenBranch && outerIf.getElseBranch() == null) {
                    AndOrToIfSurrounder.mergeIfs(outerIf, innerIf);
                    return;
                }
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)anchor), PsiIfStatement.class)) == null || ifStatement != this.myCreatedIf) {
                return;
            }
            PsiStatement result = CodeBlockSurrounder.collapseIf(ifStatement, "&&", "||");
            if (result == null) {
                return;
            }
            this.myUpstream.collapse(this.myUpstream.anchor(result));
        }

        private static void mergeIfs(@NotNull PsiIfStatement outerIf, @NotNull PsiIfStatement innerIf) {
            if (outerIf == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(21);
            }
            if (innerIf == null) {
                AndOrToIfSurrounder.$$$reportNull$$$0(22);
            }
            PsiExpression outerCondition = outerIf.getCondition();
            PsiExpression innerCondition = innerIf.getCondition();
            if (outerCondition != null && innerCondition != null) {
                innerCondition.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)outerIf.getProject()).createExpressionFromText(ParenthesesUtils.getText(outerCondition, 14) + "&&" + ParenthesesUtils.getText(innerCondition, 14), null));
                outerIf.replace((PsiElement)innerIf);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 12, 19 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "polyadicExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upstream";
                    break;
                }
                case 3: 
                case 12: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$AndOrToIfSurrounder";
                    break;
                }
                case 4: 
                case 10: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 11: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerIf";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "andChain";
                    break;
                }
                case 8: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lOperands";
                    break;
                }
                case 9: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rOperands";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "returnOrYieldStatement";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "innerIf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$AndOrToIfSurrounder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedParentContext";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitIf";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitReturn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 12: 
                case 19: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "splitIf";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "splitReturn";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeIfs";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 12, 19 -> new IllegalStateException(string);
            };
        }
    }

    private static class TernaryToIfSurrounder
    extends CodeBlockSurrounder {
        private final PsiConditionalExpression myConditional;
        private final CodeBlockSurrounder myUpstream;

        TernaryToIfSurrounder(@NotNull PsiExpression expression, @NotNull PsiConditionalExpression conditional, @NotNull CodeBlockSurrounder upstream) {
            if (expression == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(0);
            }
            if (conditional == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(1);
            }
            if (upstream == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(2);
            }
            super(expression);
            this.myConditional = conditional;
            this.myUpstream = upstream;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            if (this.myConditional.getThenExpression() == this.myExpression || this.myConditional.getElseExpression() == this.myExpression) {
                ParentContext parentContext = this.myUpstream.getExpectedParentContext();
                if (parentContext == null) {
                    TernaryToIfSurrounder.$$$reportNull$$$0(3);
                }
                return parentContext;
            }
            ParentContext parentContext = super.getExpectedParentContext();
            if (parentContext == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(4);
            }
            return parentContext;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(5);
            }
            if (factory == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(6);
            }
            boolean then = PsiTreeUtil.isAncestor((PsiElement)this.myConditional.getThenExpression(), (PsiElement)this.myExpression, (boolean)false);
            SurroundResult upstreamResult = this.myUpstream.surround();
            PsiConditionalExpression ternary = Objects.requireNonNull((PsiConditionalExpression)PsiUtil.skipParenthesizedExprDown((PsiExpression)upstreamResult.getExpression()));
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ternary.getParent());
            PsiStatement statement = upstreamResult.getAnchor();
            if (parent instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)parent;
                variable.normalizeDeclaration();
                PsiDeclarationStatement declaration = (PsiDeclarationStatement)variable.getParent();
                PsiAssignmentExpression assignment = ExpressionUtils.splitDeclaration(declaration, project);
                if (assignment != null) {
                    ternary = (PsiConditionalExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()));
                    statement = (PsiStatement)assignment.getParent();
                }
            }
            CommentTracker ct = new CommentTracker();
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText("if(" + ct.text((PsiElement)ternary.getCondition()) + ") {} else {}", (PsiElement)statement);
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)ternary, (Object)mark);
            for (PsiElement child : statement.getChildren()) {
                if (!(child instanceof PsiComment)) continue;
                ct.delete(child);
            }
            PsiStatement thenStatement = (PsiStatement)statement.copy();
            PsiConditionalExpression thenTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)thenStatement, (Object)mark));
            PsiExpression thenBranch = ternary.getThenExpression();
            if (thenBranch != null) {
                thenTernary.replace((PsiElement)ct.markUnchanged(thenBranch));
            }
            PsiStatement elseStatement = (PsiStatement)statement.copy();
            PsiConditionalExpression elseTernary = Objects.requireNonNull((PsiConditionalExpression)PsiTreeUtil.releaseMark((PsiElement)elseStatement, (Object)mark));
            PsiExpression elseBranch = ternary.getElseExpression();
            if (elseBranch != null) {
                elseTernary.replace((PsiElement)ct.markUnchanged(elseBranch));
            }
            ifStatement = (PsiIfStatement)ct.replaceAndRestoreComments((PsiElement)statement, (PsiElement)ifStatement);
            thenStatement = (PsiStatement)((PsiBlockStatement)Objects.requireNonNull(ifStatement.getThenBranch())).getCodeBlock().add((PsiElement)thenStatement);
            elseStatement = (PsiStatement)((PsiBlockStatement)Objects.requireNonNull(ifStatement.getElseBranch())).getCodeBlock().add((PsiElement)elseStatement);
            PsiStatement psiStatement = then ? thenStatement : elseStatement;
            if (psiStatement == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(7);
            }
            return psiStatement;
        }

        @NotNull
        PsiIfStatement anchor(@NotNull PsiStatement context) {
            if (context == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(8);
            }
            PsiIfStatement psiIfStatement = (PsiIfStatement)context.getParent().getParent().getParent();
            if (psiIfStatement == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(9);
            }
            return psiIfStatement;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiIfStatement ifStatement;
            if (anchor == null) {
                TernaryToIfSurrounder.$$$reportNull$$$0(10);
            }
            if ((ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)anchor, PsiIfStatement.class)) == null) {
                return;
            }
            PsiStatement result = CodeBlockSurrounder.collapseIf(ifStatement, "?:");
            if (result == null) {
                return;
            }
            this.myUpstream.collapse(this.myUpstream.anchor(result));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 7, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditional";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "upstream";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$TernaryToIfSurrounder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$TernaryToIfSurrounder";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedParentContext";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 9: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 7, 9 -> new IllegalStateException(string);
            };
        }
    }

    private static class AnonymousCallSurrounder
    extends CodeBlockSurrounder {
        AnonymousCallSurrounder(@NotNull PsiExpression expression) {
            if (expression == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(0);
            }
            super(expression);
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            PsiType type;
            PsiExpression expression;
            if (project == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(2);
            }
            if ((expression = this.myExpression).getParent() instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)expression.getParent()).getMethodExpression() == expression) {
                expression = (PsiExpression)expression.getParent();
            }
            String typeText = (type = expression.getType()) == null ? "java.lang.Object" : type.getCanonicalText();
            String text = "new java.lang.Object() { " + typeText + " evaluate() { return x;}}.evaluate()";
            PsiMethodCallExpression anonymousCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(text, (PsiElement)expression);
            PsiReturnStatement returnStatement = Objects.requireNonNull(AnonymousCallSurrounder.getReturnStatement(anonymousCall));
            Objects.requireNonNull(returnStatement.getReturnValue()).replace((PsiElement)expression);
            PsiStatement psiStatement = (PsiStatement)Objects.requireNonNull(AnonymousCallSurrounder.getReturnStatement((PsiMethodCallExpression)expression.replace((PsiElement)anonymousCall)));
            if (psiStatement == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(3);
            }
            return psiStatement;
        }

        @Nullable
        private static PsiReturnStatement getReturnStatement(@NotNull PsiMethodCallExpression anonymousCall) {
            PsiNewExpression newExpression;
            if (anonymousCall == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(4);
            }
            if ((newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)anonymousCall.getMethodExpression().getQualifierExpression(), PsiNewExpression.class)) == null) {
                return null;
            }
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass == null) {
                return null;
            }
            PsiMethod[] methods = anonymousClass.getMethods();
            if (methods.length != 1) {
                return null;
            }
            PsiCodeBlock body = methods[0].getBody();
            if (body == null) {
                return null;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 1) {
                return null;
            }
            return (PsiReturnStatement)ObjectUtils.tryCast((Object)statements[0], PsiReturnStatement.class);
        }

        @NotNull
        PsiMethodCallExpression anchor(@NotNull PsiStatement context) {
            if (context == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(5);
            }
            PsiMethod method = (PsiMethod)context.getParent().getParent();
            PsiNewExpression newExpression = (PsiNewExpression)method.getParent().getParent();
            PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)newExpression.getParent().getParent();
            if (psiMethodCallExpression == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(6);
            }
            return psiMethodCallExpression;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiMethodCallExpression anonymousCall;
            if (anchor == null) {
                AnonymousCallSurrounder.$$$reportNull$$$0(7);
            }
            if ((anonymousCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)anchor, PsiMethodCallExpression.class)) == null) {
                return;
            }
            PsiReturnStatement returnStatement = AnonymousCallSurrounder.getReturnStatement(anonymousCall);
            if (returnStatement == null) {
                return;
            }
            PsiExpression targetExpression = returnStatement.getReturnValue();
            if (targetExpression == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)anonymousCall, (PsiElement)targetExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$AnonymousCallSurrounder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anonymousCall";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$AnonymousCallSurrounder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getReturnStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class SimpleSurrounder
    extends CodeBlockSurrounder {
        private final PsiStatement myStatement;

        SimpleSurrounder(PsiExpression expression, PsiStatement statement) {
            super(expression);
            this.myStatement = statement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                SimpleSurrounder.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                SimpleSurrounder.$$$reportNull$$$0(1);
            }
            PsiBlockStatement block = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)this.myStatement);
            block.getCodeBlock().add((PsiElement)this.myStatement);
            block = (PsiBlockStatement)this.myStatement.replace((PsiElement)block);
            PsiStatement psiStatement = block.getCodeBlock().getStatements()[0];
            if (psiStatement == null) {
                SimpleSurrounder.$$$reportNull$$$0(2);
            }
            return psiStatement;
        }

        @NotNull
        PsiBlockStatement anchor(@NotNull PsiStatement context) {
            if (context == null) {
                SimpleSurrounder.$$$reportNull$$$0(3);
            }
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)context.getParent().getParent();
            if (psiBlockStatement == null) {
                SimpleSurrounder.$$$reportNull$$$0(4);
            }
            return psiBlockStatement;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiBlockStatement blockStatement;
            if (anchor == null) {
                SimpleSurrounder.$$$reportNull$$$0(5);
            }
            if ((blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)anchor, PsiBlockStatement.class)) == null) {
                return;
            }
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(blockStatement.getCodeBlock());
            if (statement == null) {
                return;
            }
            if (statement instanceof PsiIfStatement && blockStatement.getParent() instanceof PsiIfStatement && ((PsiIfStatement)blockStatement.getParent()).getThenBranch() == blockStatement) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)blockStatement, (PsiElement)statement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SimpleSurrounder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SimpleSurrounder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class SplitTrySurrounder
    extends CodeBlockSurrounder {
        private final PsiResourceVariable myVariable;
        private final PsiTryStatement myStatement;

        SplitTrySurrounder(@NotNull PsiExpression expression, @NotNull PsiResourceVariable variable, @NotNull PsiTryStatement tryStatement) {
            if (expression == null) {
                SplitTrySurrounder.$$$reportNull$$$0(0);
            }
            if (variable == null) {
                SplitTrySurrounder.$$$reportNull$$$0(1);
            }
            if (tryStatement == null) {
                SplitTrySurrounder.$$$reportNull$$$0(2);
            }
            super(expression);
            this.myVariable = variable;
            this.myStatement = tryStatement;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                SplitTrySurrounder.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                SplitTrySurrounder.$$$reportNull$$$0(4);
            }
            PsiResourceList list = Objects.requireNonNull(this.myStatement.getResourceList());
            PsiTryStatement copy = (PsiTryStatement)this.myStatement.copy();
            PsiResourceList copyList = copy.getResourceList();
            if (copyList == null) {
                PsiTryStatement psiTryStatement = this.myStatement;
                if (psiTryStatement == null) {
                    SplitTrySurrounder.$$$reportNull$$$0(5);
                }
                return psiTryStatement;
            }
            PsiCodeBlock tryBlock = this.myStatement.getTryBlock();
            if (tryBlock == null) {
                PsiTryStatement psiTryStatement = this.myStatement;
                if (psiTryStatement == null) {
                    SplitTrySurrounder.$$$reportNull$$$0(6);
                }
                return psiTryStatement;
            }
            List elementsToMove = ((StreamEx)StreamEx.of((Iterator)list.iterator()).dropWhile(e -> e != this.myVariable)).toList();
            for (PsiCatchSection[] element : elementsToMove) {
                element.delete();
            }
            for (PsiCatchSection[] element : ((StreamEx)StreamEx.of((Iterator)copyList.iterator()).limit((long)(copyList.getResourceVariablesCount() - elementsToMove.size()))).toList()) {
                element.delete();
            }
            PsiElement[] children = copyList.getChildren();
            if (children[0].textMatches((CharSequence)"(") && children[1] instanceof PsiWhiteSpace) {
                children[1].delete();
            }
            for (PsiCatchSection section : copy.getCatchSections()) {
                section.delete();
            }
            PsiCodeBlock copyFinally = copy.getFinallyBlock();
            if (copyFinally != null) {
                PsiElement element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)copyFinally);
                if (element != null && element.textMatches((CharSequence)"finally")) {
                    element.delete();
                }
                copyFinally.delete();
            }
            PsiElement codeBlock = tryBlock.replace((PsiElement)factory.createCodeBlock());
            PsiStatement psiStatement = (PsiStatement)codeBlock.add((PsiElement)copy);
            if (psiStatement == null) {
                SplitTrySurrounder.$$$reportNull$$$0(7);
            }
            return psiStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SplitTrySurrounder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$SplitTrySurrounder";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExtractFieldInitializerSurrounder
    extends CodeBlockSurrounder {
        private final PsiField myField;

        ExtractFieldInitializerSurrounder(@NotNull PsiExpression expression, @NotNull PsiField field) {
            if (expression == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(0);
            }
            if (field == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(1);
            }
            super(expression);
            this.myField = field;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            ParentContext parentContext = this.myField.getInitializer() == this.myExpression ? ParentContext.ASSIGNMENT : super.getExpectedParentContext();
            if (parentContext == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(2);
            }
            return parentContext;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(3);
            }
            if (factory == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(4);
            }
            this.myField.normalizeDeclaration();
            PsiClassInitializer initializer = this.findInitializer();
            if (initializer == null) {
                initializer = factory.createClassInitializer();
                if (this.myField.hasModifierProperty("static")) {
                    Objects.requireNonNull(initializer.getModifierList()).setModifierProperty("static", true);
                }
                initializer = (PsiClassInitializer)this.myField.getParent().addAfter((PsiElement)initializer, (PsiElement)this.myField);
            }
            PsiCodeBlock body = initializer.getBody();
            PsiElement anchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)body.getFirstChild());
            assert (anchor != null);
            anchor = anchor.getPrevSibling();
            assert (anchor != null);
            PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(this.myField.getName() + "=null;", (PsiElement)initializer);
            assignment = (PsiExpressionStatement)body.addAfter((PsiElement)assignment, anchor);
            PsiExpression fieldInitializer = this.myField.getInitializer();
            fieldInitializer = ExpressionUtils.convertInitializerToExpression(fieldInitializer, factory, this.myField.getType());
            PsiExpression rExpression = ((PsiAssignmentExpression)assignment.getExpression()).getRExpression();
            assert (fieldInitializer != null);
            assert (rExpression != null);
            rExpression.replace((PsiElement)fieldInitializer);
            Objects.requireNonNull(this.myField.getInitializer()).delete();
            PsiExpressionStatement psiExpressionStatement = assignment;
            if (psiExpressionStatement == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(5);
            }
            return psiExpressionStatement;
        }

        @Nullable
        private PsiClassInitializer findInitializer() {
            PsiField current = this.myField;
            boolean isStatic = this.myField.hasModifierProperty("static");
            while (true) {
                PsiExpression initializer;
                PsiField field;
                if ((current = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)current)) instanceof PsiClassInitializer) {
                    PsiClassInitializer initializer2 = (PsiClassInitializer)current;
                    if (initializer2.hasModifierProperty("static") != isStatic) continue;
                    return initializer2;
                }
                if (!(current instanceof PsiField) || (field = current).hasModifierProperty("static") == isStatic && (initializer = field.getInitializer()) != null && (!ExpressionUtils.isSafelyRecomputableExpression(initializer) || VariableAccessUtils.variableIsUsed((PsiVariable)this.myField, (PsiElement)initializer))) break;
            }
            return null;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiExpressionStatement statement;
            if (anchor == null) {
                ExtractFieldInitializerSurrounder.$$$reportNull$$$0(6);
            }
            if ((statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)anchor, PsiExpressionStatement.class)) == null) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiAssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            if (this.myField.hasInitializer()) {
                return;
            }
            PsiExpression lExpression = assignment.getLExpression();
            if (!(lExpression instanceof PsiReferenceExpression) || !((PsiReferenceExpression)lExpression).isReferenceTo((PsiElement)this.myField) || ((PsiReferenceExpression)lExpression).getQualifierExpression() != null) {
                return;
            }
            PsiExpression rExpression = assignment.getRExpression();
            if (rExpression == null) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)statement.getParent(), PsiCodeBlock.class);
            if (block == null || !(block.getParent() instanceof PsiClassInitializer)) {
                return;
            }
            if (block.getStatementCount() != 1) {
                return;
            }
            this.myField.setInitializer(rExpression);
            block.getParent().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$ExtractFieldInitializerSurrounder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$ExtractFieldInitializerSurrounder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedParentContext";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class NoOpSurrounder
    extends CodeBlockSurrounder {
        private final PsiStatement myAnchor;

        NoOpSurrounder(@NotNull PsiExpression expression, @NotNull PsiStatement anchor) {
            if (expression == null) {
                NoOpSurrounder.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                NoOpSurrounder.$$$reportNull$$$0(1);
            }
            super(expression);
            this.myAnchor = anchor;
        }

        @Override
        @NotNull
        public SurroundResult surround() {
            return new SurroundResult(this.myExpression, this.myAnchor, (PsiElement)this.myAnchor, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anchor";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$NoOpSurrounder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class YieldSurrounder
    extends CodeBlockSurrounder {
        private final PsiExpressionStatement myStatement;

        YieldSurrounder(PsiExpression expression, PsiExpressionStatement statement) {
            super(expression);
            this.myStatement = statement;
        }

        @Override
        @NotNull
        public ParentContext getExpectedParentContext() {
            ParentContext parentContext = this.myExpression.getParent() == this.myStatement ? ParentContext.RETURN : super.getExpectedParentContext();
            if (parentContext == null) {
                YieldSurrounder.$$$reportNull$$$0(0);
            }
            return parentContext;
        }

        @Override
        @NotNull
        PsiStatement replace(@NotNull Project project, @NotNull PsiElementFactory factory) {
            if (project == null) {
                YieldSurrounder.$$$reportNull$$$0(1);
            }
            if (factory == null) {
                YieldSurrounder.$$$reportNull$$$0(2);
            }
            PsiBlockStatement block = (PsiBlockStatement)factory.createStatementFromText("{yield x;}", (PsiElement)this.myStatement);
            PsiExpression newExpression = Objects.requireNonNull(((PsiYieldStatement)block.getCodeBlock().getStatements()[0]).getExpression());
            newExpression.replace((PsiElement)this.myStatement.getExpression());
            block = (PsiBlockStatement)this.myStatement.replace((PsiElement)block);
            PsiStatement psiStatement = block.getCodeBlock().getStatements()[0];
            if (psiStatement == null) {
                YieldSurrounder.$$$reportNull$$$0(3);
            }
            return psiStatement;
        }

        @NotNull
        PsiBlockStatement anchor(@NotNull PsiStatement context) {
            if (context == null) {
                YieldSurrounder.$$$reportNull$$$0(4);
            }
            PsiBlockStatement psiBlockStatement = (PsiBlockStatement)context.getParent().getParent();
            if (psiBlockStatement == null) {
                YieldSurrounder.$$$reportNull$$$0(5);
            }
            return psiBlockStatement;
        }

        @Override
        void collapse(@NotNull PsiElement anchor) {
            PsiBlockStatement blockStatement;
            if (anchor == null) {
                YieldSurrounder.$$$reportNull$$$0(6);
            }
            if ((blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)anchor, PsiBlockStatement.class)) == null) {
                return;
            }
            PsiStatement statement = ControlFlowUtils.getOnlyStatementInBlock(blockStatement.getCodeBlock());
            if (!(statement instanceof PsiYieldStatement)) {
                return;
            }
            PsiExpression expression = ((PsiYieldStatement)statement).getExpression();
            if (expression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            ct.replaceAndRestoreComments((PsiElement)blockStatement, ct.text((PsiElement)expression) + ";");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$YieldSurrounder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpectedParentContext";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/CodeBlockSurrounder$YieldSurrounder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "anchor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "collapse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

