/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentTracker {
    private final Set<PsiElement> ignoredParents = new HashSet<PsiElement>();
    private List<PsiComment> comments = new ArrayList<PsiComment>();
    private PsiElement lastTextWithCommentsElement = null;

    @NotNull
    public String text(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(0);
        }
        this.checkState();
        this.addIgnored(element);
        String string = element.getText();
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String text(@NotNull PsiExpression element, int precedence) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(2);
        }
        this.checkState();
        this.addIgnored((PsiElement)element);
        String string = ParenthesesUtils.getText(element, precedence + 1);
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String lambdaText(@NotNull PsiVariable variable, @NotNull PsiExpression expression) {
        if (variable == null) {
            CommentTracker.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            CommentTracker.$$$reportNull$$$0(5);
        }
        String string = variable.getName() + " -> " + this.text((PsiElement)expression);
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Contract(value="_ -> param1")
    public <T extends PsiElement> T markUnchanged(@Nullable T element) {
        this.checkState();
        if (element != null) {
            this.addIgnored(element);
        }
        return element;
    }

    public String rangeText(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        if (firstElement == null) {
            CommentTracker.$$$reportNull$$$0(7);
        }
        if (lastElement == null) {
            CommentTracker.$$$reportNull$$$0(8);
        }
        this.checkState();
        StringBuilder result = new StringBuilder();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
            result.append(e.getText());
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + String.valueOf(firstElement) + " and " + String.valueOf(lastElement));
        }
        this.addIgnored(lastElement);
        result.append(lastElement.getText());
        return result.toString();
    }

    public void markRangeUnchanged(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement) {
        PsiElement e;
        if (firstElement == null) {
            CommentTracker.$$$reportNull$$$0(9);
        }
        if (lastElement == null) {
            CommentTracker.$$$reportNull$$$0(10);
        }
        this.checkState();
        for (e = firstElement; e != null && e != lastElement; e = e.getNextSibling()) {
            this.addIgnored(e);
        }
        if (e == null) {
            throw new IllegalArgumentException("Elements must be siblings: " + String.valueOf(firstElement) + " and " + String.valueOf(lastElement));
        }
        this.addIgnored(lastElement);
    }

    public String commentsBefore(@NotNull PsiElement element) {
        List<PsiElement> comments;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(11);
        }
        if ((comments = this.grabCommentsBefore(element)).isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (PsiElement comment : comments) {
            PsiElement prev = comment.getPrevSibling();
            if (sb.isEmpty() && prev instanceof PsiWhiteSpace) {
                sb.append(prev.getText());
            }
            sb.append(comment.getText());
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)comment);
            if (!(next instanceof PsiWhiteSpace)) continue;
            sb.append(next.getText());
        }
        comments.forEach(PsiElement::delete);
        return sb.toString();
    }

    private List<PsiElement> grabCommentsBefore(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(12);
        }
        if (this.lastTextWithCommentsElement == null) {
            this.lastTextWithCommentsElement = element;
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        int start = this.lastTextWithCommentsElement.getTextRange().getEndOffset();
        int end = element.getTextRange().getStartOffset();
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)this.lastTextWithCommentsElement, (PsiElement)element);
        if (parent != null && start < end) {
            PsiTreeUtil.processElements((PsiElement)parent, arg_0 -> this.lambda$grabCommentsBefore$0(start, end, (List)result, arg_0));
        }
        this.lastTextWithCommentsElement = element;
        return result;
    }

    public String textWithComments(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(13);
        }
        return this.commentsBefore(element) + this.text(element);
    }

    public String textWithComments(@NotNull PsiExpression expression, int precedence) {
        if (expression == null) {
            CommentTracker.$$$reportNull$$$0(14);
        }
        return this.commentsBefore((PsiElement)expression) + ParenthesesUtils.getText(expression, precedence + 1);
    }

    public void delete(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(15);
        }
        this.grabCommentsOnDelete(element);
        element.delete();
    }

    public void delete(PsiElement ... elements) {
        if (elements == null) {
            CommentTracker.$$$reportNull$$$0(16);
        }
        for (PsiElement element : elements) {
            this.delete(element);
        }
    }

    public void deleteAndRestoreComments(@NotNull PsiElement element) {
        PsiElement anchor;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(17);
        }
        this.grabCommentsOnDelete(element);
        for (anchor = element; anchor.getParent() != null && !(anchor.getParent() instanceof PsiFile) && anchor.getParent().getFirstChild() == anchor; anchor = anchor.getParent()) {
        }
        this.insertCommentsBefore(anchor);
        element.delete();
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        PsiElement parent;
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(18);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(19);
        }
        if ((parent = element.getParent()) instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression parentPolyadic = (PsiPolyadicExpression)parent;
            if (replacement instanceof PsiPolyadicExpression) {
                Object[] children;
                int idx;
                PsiPolyadicExpression childPolyadic = (PsiPolyadicExpression)replacement;
                IElementType parentTokenType = parentPolyadic.getOperationTokenType();
                IElementType childTokenType = childPolyadic.getOperationTokenType();
                if (PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)parentTokenType) == PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)childTokenType) && !PsiPrecedenceUtil.areParenthesesNeeded((PsiExpression)childPolyadic, (PsiExpression)parentPolyadic, (boolean)false) && ((idx = ArrayUtil.indexOf((Object[])(children = parentPolyadic.getChildren()), (Object)element)) > 0 || idx == 0 && parentTokenType == childTokenType)) {
                    StringBuilder text = new StringBuilder();
                    for (int i = 0; i < children.length; ++i) {
                        Object child = children[i];
                        text.append(this.text((PsiElement)(i == idx ? replacement : child)));
                    }
                    replacement = JavaPsiFacade.getElementFactory((Project)parent.getProject()).createExpressionFromText(text.toString(), parent);
                    element = parent;
                }
            }
        }
        this.markUnchanged(replacement);
        this.grabComments(element);
        PsiElement psiElement = element.replace(replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replace(@NotNull PsiElement element, @NotNull @NlsSafe String text) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(21);
        }
        if (text == null) {
            CommentTracker.$$$reportNull$$$0(22);
        }
        PsiElement replacement = CommentTracker.createElementFromText(text, element);
        PsiElement psiElement = this.replace(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(23);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull PsiElement replacement) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(24);
        }
        if (replacement == null) {
            CommentTracker.$$$reportNull$$$0(25);
        }
        List<PsiElement> suffix = this.grabSuffixComments(element);
        PsiElement result = this.replace(element, replacement);
        PsiElement anchor = CommentTracker.findAnchor(result);
        CommentTracker.restoreSuffixComments(result, suffix);
        this.insertCommentsBefore(anchor);
        PsiElement psiElement = result;
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(26);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement findAnchor(@NotNull PsiElement result) {
        PsiElement anchor;
        if (result == null) {
            CommentTracker.$$$reportNull$$$0(27);
        }
        if ((anchor = PsiTreeUtil.getNonStrictParentOfType((PsiElement)result, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class, PsiVariable.class, PsiNameValuePair.class})) instanceof PsiLambdaExpression && anchor != result) {
            anchor = ((PsiLambdaExpression)anchor).getBody();
        }
        if (anchor instanceof PsiVariable && anchor.getParent() instanceof PsiDeclarationStatement) {
            anchor = anchor.getParent();
        }
        if (anchor instanceof PsiStatement && (anchor.getParent() instanceof PsiIfStatement || anchor.getParent() instanceof PsiLoopStatement)) {
            anchor = anchor.getParent();
        }
        PsiElement psiElement = anchor == null ? result : anchor;
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceExpressionAndRestoreComments(@NotNull PsiExpression expression, @NotNull String replacementText) {
        if (expression == null) {
            CommentTracker.$$$reportNull$$$0(29);
        }
        if (replacementText == null) {
            CommentTracker.$$$reportNull$$$0(30);
        }
        PsiElement psiElement = this.replaceExpressionAndRestoreComments(expression, replacementText, Collections.emptyList());
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(31);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement replaceExpressionAndRestoreComments(@NotNull PsiExpression expression, @NotNull String replacementText, List<? extends PsiElement> toDelete) {
        if (expression == null) {
            CommentTracker.$$$reportNull$$$0(32);
        }
        if (replacementText == null) {
            CommentTracker.$$$reportNull$$$0(33);
        }
        SmartList trailingComments = new SmartList();
        List<PsiElement> comments = this.grabCommentsBefore(PsiTreeUtil.lastChild((PsiElement)expression));
        if (!comments.isEmpty()) {
            PsiParserFacade parser = PsiParserFacade.getInstance((Project)expression.getProject());
            for (PsiElement comment : comments) {
                PsiElement prev = comment.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    String text = prev.getText();
                    if (!text.contains("\n")) {
                        trailingComments.add(parser.createWhiteSpaceFromText(" "));
                    } else if (text.endsWith("\n")) {
                        trailingComments.add(parser.createWhiteSpaceFromText("\n"));
                    } else {
                        trailingComments.add(parser.createWhiteSpaceFromText("\n "));
                    }
                }
                this.addIgnored(comment);
                trailingComments.add(comment.copy());
            }
            if (CommentTracker.isEndOfLineComment((PsiElement)trailingComments.getLast())) {
                PsiElement next = expression.getNextSibling();
                if (next instanceof PsiErrorElement) {
                    next = next.getNextSibling();
                }
                if (CommentTracker.isEndOfLineComment(next) || next instanceof PsiWhiteSpace && !next.getText().contains("\n") && CommentTracker.isEndOfLineComment(next.getNextSibling())) {
                    trailingComments.add(parser.createWhiteSpaceFromText("\n "));
                }
            }
            Collections.reverse(trailingComments);
        }
        PsiElement replacement = this.replace((PsiElement)expression, replacementText);
        for (PsiElement element : trailingComments) {
            replacement.getParent().addAfter(element, replacement);
        }
        toDelete.forEach(this::delete);
        PsiElement anchor = replacement;
        while (anchor.getParent() != null && anchor.getPrevSibling() == null) {
            anchor = anchor.getParent();
        }
        this.insertCommentsBefore(anchor);
        PsiElement psiElement = replacement;
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    private static boolean isEndOfLineComment(@Nullable PsiElement element) {
        return element instanceof PsiComment && ((PsiComment)element).getTokenType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    @NotNull
    private List<PsiElement> grabSuffixComments(@NotNull PsiElement element) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(35);
        }
        if (!(element instanceof PsiStatement)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                CommentTracker.$$$reportNull$$$0(36);
            }
            return list;
        }
        ArrayList<PsiElement> suffix = new ArrayList<PsiElement>();
        PsiElement lastChild = element.getLastChild();
        boolean hasComment = false;
        while (lastChild instanceof PsiComment || lastChild instanceof PsiWhiteSpace) {
            hasComment |= lastChild instanceof PsiComment;
            if (!(lastChild instanceof PsiComment) || !this.shouldIgnore((PsiComment)lastChild)) {
                suffix.add(this.markUnchanged(lastChild).copy());
            }
            lastChild = lastChild.getPrevSibling();
        }
        List<Object> list = hasComment ? suffix : Collections.emptyList();
        if (list == null) {
            CommentTracker.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static void restoreSuffixComments(PsiElement target, List<? extends PsiElement> suffix) {
        if (!suffix.isEmpty()) {
            PsiElement lastChild = target.getLastChild();
            if (lastChild instanceof PsiComment && JavaTokenType.END_OF_LINE_COMMENT.equals(((PsiComment)lastChild).getTokenType())) {
                PsiElement nextSibling = target.getNextSibling();
                if (nextSibling instanceof PsiWhiteSpace) {
                    target.add(nextSibling);
                } else {
                    target.add(PsiParserFacade.getInstance((Project)target.getProject()).createWhiteSpaceFromText("\n"));
                }
            }
            StreamEx.ofReversed(suffix).forEach(arg_0 -> ((PsiElement)target).add(arg_0));
        }
    }

    @NotNull
    public PsiElement replaceAndRestoreComments(@NotNull PsiElement element, @NotNull @NlsSafe String text) {
        if (element == null) {
            CommentTracker.$$$reportNull$$$0(38);
        }
        if (text == null) {
            CommentTracker.$$$reportNull$$$0(39);
        }
        PsiElement replacement = CommentTracker.createElementFromText(text, element);
        PsiElement psiElement = this.replaceAndRestoreComments(element, replacement);
        if (psiElement == null) {
            CommentTracker.$$$reportNull$$$0(40);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement createElementFromText(@NotNull String text, @NotNull PsiElement context) {
        if (text == null) {
            CommentTracker.$$$reportNull$$$0(41);
        }
        if (context == null) {
            CommentTracker.$$$reportNull$$$0(42);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        if (context instanceof PsiExpression) {
            PsiExpression psiExpression = factory.createExpressionFromText(text, context);
            if (psiExpression == null) {
                CommentTracker.$$$reportNull$$$0(43);
            }
            return psiExpression;
        }
        if (context instanceof PsiStatement) {
            PsiStatement psiStatement = factory.createStatementFromText(text, context);
            if (psiStatement == null) {
                CommentTracker.$$$reportNull$$$0(44);
            }
            return psiStatement;
        }
        if (context instanceof PsiTypeElement) {
            PsiTypeElement psiTypeElement = factory.createTypeElementFromText(text, context);
            if (psiTypeElement == null) {
                CommentTracker.$$$reportNull$$$0(45);
            }
            return psiTypeElement;
        }
        if (context instanceof PsiIdentifier) {
            PsiIdentifier psiIdentifier = factory.createIdentifier(text);
            if (psiIdentifier == null) {
                CommentTracker.$$$reportNull$$$0(46);
            }
            return psiIdentifier;
        }
        if (context instanceof PsiComment) {
            PsiComment psiComment = factory.createCommentFromText(text, context);
            if (psiComment == null) {
                CommentTracker.$$$reportNull$$$0(47);
            }
            return psiComment;
        }
        throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(context));
    }

    public void insertCommentsBefore(@NotNull PsiElement anchor) {
        if (anchor == null) {
            CommentTracker.$$$reportNull$$$0(48);
        }
        this.checkState();
        if (!this.comments.isEmpty()) {
            PsiElement parent = anchor.getParent();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
            for (PsiComment comment : this.comments) {
                PsiElement added;
                PsiElement prevSibling;
                if (this.shouldIgnore(comment) || !((prevSibling = (added = parent.addBefore((PsiElement)factory.createCommentFromText(comment.getText(), anchor), anchor)).getPrevSibling()) instanceof PsiWhiteSpace)) continue;
                PsiElement prev = anchor.getPrevSibling();
                ASTNode whiteSpaceBefore = CommentTracker.normalizeWhiteSpace((PsiWhiteSpace)prevSibling, prev);
                parent.getNode().addChild(whiteSpaceBefore, anchor.getNode());
                if (!(prev instanceof PsiWhiteSpace)) continue;
                prev.delete();
            }
        }
        this.comments = null;
    }

    @NotNull
    private static ASTNode normalizeWhiteSpace(PsiWhiteSpace whiteSpace, PsiElement nextElement) {
        int endLPos;
        Object text = whiteSpace.getText();
        if (((String)text).lastIndexOf(10, (endLPos = ((String)text).lastIndexOf(10)) - 1) >= 0) {
            LeafElement leafElement = ASTFactory.whitespace((CharSequence)((String)text).substring(endLPos));
            if (leafElement == null) {
                CommentTracker.$$$reportNull$$$0(49);
            }
            return leafElement;
        }
        if (nextElement instanceof PsiWhiteSpace && nextElement.getText().contains("\n") && !((String)text).contains("\n")) {
            text = "\n" + (String)text;
        }
        LeafElement leafElement = ASTFactory.whitespace((CharSequence)text);
        if (leafElement == null) {
            CommentTracker.$$$reportNull$$$0(50);
        }
        return leafElement;
    }

    private boolean shouldIgnore(PsiComment comment) {
        return this.ignoredParents.stream().anyMatch(p -> PsiTreeUtil.isAncestor((PsiElement)p, (PsiElement)comment, (boolean)false));
    }

    private void grabCommentsOnDelete(PsiElement element) {
        if (element instanceof PsiExpression && element.getParent() instanceof PsiExpressionStatement || element.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)element.getParent()).getDeclaredElements().length == 1) {
            element = element.getParent();
        } else if (element.getParent() instanceof PsiJavaCodeReferenceElement) {
            ASTNode dot;
            PsiElement parent = element.getParent();
            if (element instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)parent).getQualifier() == element && (dot = ((CompositeElement)parent).findChildByRole(55)) != null) {
                PsiElement nextSibling = dot.getPsi().getNextSibling();
                if (nextSibling != null && nextSibling.getTextLength() == 0) {
                    nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nextSibling);
                }
                while (nextSibling != null) {
                    nextSibling = this.markUnchanged(nextSibling).getNextSibling();
                }
            }
            element = parent;
        }
        this.grabComments(element);
    }

    public void grabComments(PsiElement element) {
        this.checkState();
        for (PsiComment comment : PsiTreeUtil.collectElementsOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class})) {
            if (this.shouldIgnore(comment)) continue;
            this.comments.add(comment);
        }
    }

    private void checkState() {
        if (this.comments == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already used");
        }
    }

    private void addIgnored(PsiElement element) {
        if (!(element instanceof LeafPsiElement) || element instanceof PsiComment) {
            this.ignoredParents.add(element);
        }
    }

    public static String textWithSurroundingComments(PsiElement element) {
        Predicate<PsiElement> commentOrWhiteSpace = e -> e instanceof PsiComment || e instanceof PsiWhiteSpace;
        List prev = StreamEx.iterate((Object)element.getPrevSibling(), commentOrWhiteSpace, PsiElement::getPrevSibling).toList();
        List next = StreamEx.iterate((Object)element.getNextSibling(), commentOrWhiteSpace, PsiElement::getNextSibling).toList();
        if (StreamEx.of((Object[])new List[]{prev, next}).flatCollection(Function.identity()).anyMatch(PsiComment.class::isInstance)) {
            return StreamEx.ofReversed((List)prev).append((Object)element).append((Collection)next).map(PsiElement::getText).joining();
        }
        return element.getText();
    }

    @NotNull
    public static String commentsBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            CommentTracker.$$$reportNull$$$0(51);
        }
        if (end == null) {
            CommentTracker.$$$reportNull$$$0(52);
        }
        CommentTracker ct = new CommentTracker();
        ct.lastTextWithCommentsElement = start;
        String string = ct.commentsBefore(end);
        if (string == null) {
            CommentTracker.$$$reportNull$$$0(53);
        }
        return string;
    }

    private /* synthetic */ boolean lambda$grabCommentsBefore$0(int start, int end, List result, PsiElement e) {
        TextRange range;
        if (e instanceof PsiComment && (range = e.getTextRange()).getStartOffset() >= start && range.getEndOffset() <= end && !this.shouldIgnore((PsiComment)e)) {
            result.add(e);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 6, 20, 23, 26, 28, 31, 34, 36, 37, 40, 43, 44, 45, 46, 47, 49, 50, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: 
            case 14: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 22: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/CommentTracker";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "text";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lambdaText";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 26: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAndRestoreComments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnchor";
                break;
            }
            case 31: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpressionAndRestoreComments";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "grabSuffixComments";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementFromText";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeWhiteSpace";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "commentsBetween";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 53: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambdaText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rangeText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "markRangeUnchanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "commentsBefore";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "grabCommentsBefore";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "textWithComments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "deleteAndRestoreComments";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 24: 
            case 25: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceAndRestoreComments";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndRestoreComments";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "grabSuffixComments";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createElementFromText";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "insertCommentsBefore";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "commentsBetween";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 6, 20, 23, 26, 28, 31, 34, 36, 37, 40, 43, 44, 45, 46, 47, 49, 50, 53 -> new IllegalStateException(string);
        };
    }
}

