/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.inheritance.ImplicitSubclassProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static ThreeState existsMutualSubclass(PsiClass class1, PsiClass class2, boolean avoidExpensiveProcessing) {
        PsiClass tmp;
        if (class1 instanceof PsiTypeParameter) {
            PsiClass[] superClasses = class1.getSupers();
            ThreeState result = ThreeState.YES;
            for (PsiClass superClass : superClasses) {
                ThreeState state = InheritanceUtil.existsMutualSubclass(superClass, class2, avoidExpensiveProcessing);
                if (state == ThreeState.YES || (result = state) != ThreeState.NO) continue;
                return result;
            }
            return result;
        }
        if (class2 instanceof PsiTypeParameter) {
            return InheritanceUtil.existsMutualSubclass(class2, class1, avoidExpensiveProcessing);
        }
        if ("java.lang.Object".equals(class1.getQualifiedName())) {
            return ThreeState.YES;
        }
        if ("java.lang.Object".equals(class2.getQualifiedName())) {
            return ThreeState.YES;
        }
        if (class1.isInheritor(class2, true) || class2.isInheritor(class1, true) || Objects.equals(class1, class2)) {
            return ThreeState.YES;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)class1.getProject());
        String class1Name = class1.getName();
        String class2Name = class2.getName();
        if (class1Name == null || class2Name == null) {
            return ThreeState.NO;
        }
        if (class1.hasModifierProperty("final") || class2.hasModifierProperty("final")) {
            return ThreeState.NO;
        }
        if (LambdaUtil.isFunctionalClass((PsiClass)class1) || class1Name.length() < class2Name.length() || InheritanceUtil.isJavaClass(class2) && !InheritanceUtil.isJavaClass(class1)) {
            tmp = class1;
            class1 = class2;
            class2 = tmp;
        }
        if (DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)class1, false)) {
            if (!DeclarationSearchUtils.isTooExpensiveToSearch((PsiNamedElement)class2, false)) {
                tmp = class1;
                class1 = class2;
                class2 = tmp;
            } else if (avoidExpensiveProcessing) {
                return ThreeState.UNSURE;
            }
        }
        return InheritanceUtil.doSearch(class1, class2, avoidExpensiveProcessing, (SearchScope)scope);
    }

    private static boolean isJavaClass(PsiClass class1) {
        return class1 instanceof PsiClassImpl || class1 instanceof ClsClassImpl;
    }

    private static ThreeState doSearch(PsiClass class1, final PsiClass class2, final boolean avoidExpensiveProcessing, SearchScope scope) {
        Query search = ClassInheritorsSearch.search((PsiClass)class1, (SearchScope)scope, (boolean)true);
        var processor = new Processor<PsiClass>(){
            ThreeState result = ThreeState.NO;
            final AtomicInteger count = new AtomicInteger(0);

            public boolean process(PsiClass inheritor) {
                if (inheritor.equals((Object)class2) || inheritor.isInheritor(class2, true)) {
                    this.result = ThreeState.YES;
                    return false;
                }
                if (avoidExpensiveProcessing && this.count.incrementAndGet() > 20) {
                    this.result = ThreeState.UNSURE;
                    return false;
                }
                return true;
            }
        };
        search.forEach((Processor)processor);
        return processor.result;
    }

    public static boolean hasImplementation(@NotNull PsiClass aClass) {
        if (aClass == null) {
            InheritanceUtil.$$$reportNull$$$0(0);
        }
        for (ImplicitSubclassProvider provider : ImplicitSubclassProvider.EP_NAME.getExtensionList()) {
            ImplicitSubclassProvider.SubclassingInfo info;
            if (!provider.isApplicableTo(aClass) || (info = provider.getSubclassingInfo(aClass)) == null || info.isAbstract()) continue;
            return true;
        }
        return ClassInheritorsSearch.search((PsiClass)aClass).anyMatch(inheritor -> !inheritor.isInterface() && !inheritor.isAnnotationType() && !inheritor.hasModifierProperty("abstract")) || aClass.isInterface() && FunctionalExpressionSearch.search((PsiClass)aClass).findFirst() != null;
    }

    public static boolean hasOneInheritor(PsiClass aClass) {
        CountingProcessor processor = new CountingProcessor(2);
        ProgressManager.getInstance().runProcess(() -> ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)false).forEach((Processor)processor), null);
        return processor.getCount() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/InheritanceUtil", "hasImplementation"));
    }

    private static class CountingProcessor
    implements Processor<PsiClass> {
        private final AtomicInteger myCount = new AtomicInteger(0);
        private final int myLimit;

        CountingProcessor(int limit) {
            this.myLimit = limit;
        }

        public int getCount() {
            return this.myCount.get();
        }

        public boolean process(PsiClass aClass) {
            return this.myCount.incrementAndGet() < this.myLimit;
        }
    }
}

