/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.roots.JdkUtils;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDeprecationUtils {
    @NotNull
    private static ThreeState isDeprecatedByAnnotation(@NotNull PsiModifierListOwner owner, @Nullable PsiElement context) {
        PsiAnnotation annotation;
        if (owner == null) {
            JavaDeprecationUtils.$$$reportNull$$$0(0);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{"java.lang.Deprecated"})) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                JavaDeprecationUtils.$$$reportNull$$$0(1);
            }
            return threeState;
        }
        if (context == null) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JavaDeprecationUtils.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        String since = null;
        PsiAnnotationMemberValue value = annotation.findAttributeValue("since");
        if (value instanceof PsiLiteralExpression) {
            since = (String)ObjectUtils.tryCast((Object)((PsiLiteralExpression)value).getValue(), String.class);
        }
        if (since == null || JdkUtils.getJdkForElement((PsiElement)owner) == null) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                JavaDeprecationUtils.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        LanguageLevel deprecationLevel = LanguageLevel.parse((String)since);
        ThreeState threeState = ThreeState.fromBoolean((deprecationLevel == null || PsiUtil.getLanguageLevel((PsiElement)context).isAtLeast(deprecationLevel) ? 1 : 0) != 0);
        if (threeState == null) {
            JavaDeprecationUtils.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    public static boolean isDeprecated(@NotNull PsiElement psiElement, @Nullable PsiElement context) {
        ThreeState byAnnotation;
        if (psiElement == null) {
            JavaDeprecationUtils.$$$reportNull$$$0(5);
        }
        if (psiElement instanceof PsiModifierListOwner && (byAnnotation = JavaDeprecationUtils.isDeprecatedByAnnotation((PsiModifierListOwner)psiElement, context)) != ThreeState.UNSURE) {
            return byAnnotation.toBoolean();
        }
        if (psiElement instanceof PsiDocCommentOwner) {
            return ((PsiDocCommentOwner)psiElement).isDeprecated();
        }
        if (psiElement instanceof PsiJavaDocumentedElement) {
            return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)((PsiJavaDocumentedElement)psiElement));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/JavaDeprecationUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/JavaDeprecationUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "isDeprecatedByAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecatedByAnnotation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

