/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    @NonNls
    public static String getMethodName(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(0);
        }
        return expression.getMethodExpression().getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression;
        PsiExpression qualifierExpression;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(1);
        }
        if ((qualifierExpression = (methodExpression = expression.getMethodExpression()).getQualifierExpression()) == null) {
            return null;
        }
        return qualifierExpression.getType();
    }

    @Contract(pure=true)
    public static boolean isCompareToCall(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(2);
        }
        if (!"compareTo".equals(MethodCallUtils.getMethodName(expression))) {
            return false;
        }
        return MethodUtils.isCompareTo(expression.resolveMethod());
    }

    @Contract(pure=true)
    public static boolean isCompareToIgnoreCaseCall(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(3);
        }
        if (!"compareToIgnoreCase".equals(MethodCallUtils.getMethodName(expression))) {
            return false;
        }
        return MethodUtils.isCompareToIgnoreCase(expression.resolveMethod());
    }

    @Contract(pure=true)
    public static boolean isEqualsCall(PsiMethodCallExpression expression) {
        if (!"equals".equals(MethodCallUtils.getMethodName(expression))) {
            return false;
        }
        return MethodUtils.isEquals(expression.resolveMethod());
    }

    @Contract(pure=true)
    public static boolean isEqualsIgnoreCaseCall(PsiMethodCallExpression expression) {
        if (!"equalsIgnoreCase".equals(MethodCallUtils.getMethodName(expression))) {
            return false;
        }
        return MethodUtils.isEqualsIgnoreCase(expression.resolveMethod());
    }

    @Contract(pure=true)
    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(4);
        }
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, (PsiType[])null);
        }
        if (!MethodCallUtils.checkMethodName(expression, methodName)) {
            return false;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expression.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
        GlobalSearchScope scope = expression.getResolveScope();
        for (int i = 0; i < parameterTypeStrings.length; ++i) {
            String parameterTypeString = parameterTypeStrings[i];
            parameterTypes[i] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, parameterTypes);
    }

    @Contract(pure=true)
    public static boolean isCallToStaticMethod(@NotNull PsiMethodCallExpression expression, @NonNls @NotNull String calledOnClassName, @NonNls @NotNull String methodName, int parameterCount) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(5);
        }
        if (calledOnClassName == null) {
            MethodCallUtils.$$$reportNull$$$0(6);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(7);
        }
        PsiExpression[] args = expression.getArgumentList().getExpressions();
        if (!methodName.equals(MethodCallUtils.getMethodName(expression)) || args.length < parameterCount) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null || !method.hasModifierProperty("static") || method.getParameterList().getParametersCount() != parameterCount || !method.isVarArgs() && args.length != parameterCount) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return aClass != null && calledOnClassName.equals(aClass.getQualifiedName());
    }

    @Contract(pure=true)
    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        PsiMethod method;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(8);
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodNamePattern != null) {
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return false;
            }
            Matcher matcher = methodNamePattern.matcher(referenceName);
            if (!matcher.matches()) {
                return false;
            }
        }
        if ((method = expression.resolveMethod()) == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    @Contract(pure=true)
    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(9);
        }
        if (!MethodCallUtils.checkMethodName(expression, methodName)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodName, parameterTypes);
    }

    private static boolean checkMethodName(@NotNull PsiMethodCallExpression expression, @Nullable @NonNls String methodName) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(10);
        }
        return methodName == null || methodName.equals(MethodCallUtils.getMethodName(expression));
    }

    @Contract(pure=true)
    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
        if (!regexMethodNames.contains(MethodCallUtils.getMethodName(expression))) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return "java.lang.String".equals(className) || "java.util.regex.Pattern".equals(className);
    }

    @Contract(pure=true)
    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression) {
        PsiExpression qualifier = expression.getMethodExpression().getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiQualifiedExpression)) {
            return false;
        }
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMember.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (member == null) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer || member instanceof PsiField) {
            return !member.hasModifierProperty("static");
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            if (method.isConstructor()) {
                return true;
            }
            if (CloneUtils.isClone(method)) {
                return true;
            }
            if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                return true;
            }
            return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isMethodCallOnVariable(@NotNull PsiMethodCallExpression expression, @NotNull PsiVariable variable, @NotNull @NonNls String methodName) {
        PsiReferenceExpression methodExpression;
        String name;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(11);
        }
        if (variable == null) {
            MethodCallUtils.$$$reportNull$$$0(12);
        }
        if (methodName == null) {
            MethodCallUtils.$$$reportNull$$$0(13);
        }
        if (!methodName.equals(name = (methodExpression = expression.getMethodExpression()).getReferenceName())) {
            return false;
        }
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression());
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
        PsiElement element = referenceExpression.resolve();
        return variable.equals((Object)element);
    }

    @Nullable
    public static PsiMethod findMethodWithReplacedArgument(@NotNull PsiCall call, @NotNull PsiExpression target, @NotNull PsiExpression replacement) {
        PsiExpressionList argumentList;
        if (call == null) {
            MethodCallUtils.$$$reportNull$$$0(14);
        }
        if (target == null) {
            MethodCallUtils.$$$reportNull$$$0(15);
        }
        if (replacement == null) {
            MethodCallUtils.$$$reportNull$$$0(16);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return null;
        }
        Object[] expressions = argumentList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])expressions, (Object)target);
        if (index < 0) {
            return null;
        }
        PsiCall copy = (PsiCall)call.copy();
        PsiExpressionList copyArgumentList = copy.getArgumentList();
        assert (copyArgumentList != null);
        PsiExpression[] arguments = copyArgumentList.getExpressions();
        arguments[index].replace((PsiElement)replacement);
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            assert (containingClass != null);
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)call.getProject());
            PsiClassType type = facade.getElementFactory().createType(containingClass);
            JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(type, copy.getArgumentList(), (PsiElement)call);
            return (PsiMethod)resolveResult.getElement();
        }
        return copy.resolveMethod();
    }

    @Contract(pure=true)
    public static boolean isNecessaryForSurroundingMethodCall(PsiExpression expression, PsiExpression replacement) {
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            expression = (PsiExpression)parent;
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof PsiCall)) {
            return false;
        }
        PsiCall call = (PsiCall)grandParent;
        return call.resolveMethod() != MethodCallUtils.findMethodWithReplacedArgument(call, expression, replacement);
    }

    @Contract(pure=true)
    public static boolean isSuperMethodCall(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethod method) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(17);
        }
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(18);
        }
        if (!MethodCallUtils.hasSuperQualifier(expression)) {
            return false;
        }
        PsiMethod targetMethod = expression.resolveMethod();
        return targetMethod != null && MethodSignatureUtil.isSuperMethod((PsiMethod)targetMethod, (PsiMethod)method);
    }

    @Contract(pure=true)
    public static boolean hasSuperQualifier(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(19);
        }
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getMethodExpression().getQualifierExpression()) instanceof PsiSuperExpression;
    }

    @Contract(pure=true)
    public static boolean isVarArgCall(PsiCall call) {
        JavaResolveResult result = call.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)result.getElement(), PsiMethod.class);
        if (method == null || !method.isVarArgs()) {
            return false;
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpressionList argumentList = call.getArgumentList();
        return argumentList != null && MethodCallInstruction.isVarArgCall(method, substitutor, argumentList.getExpressions(), method.getParameterList().getParameters());
    }

    @Contract(pure=true)
    public static boolean containsSuperMethodCall(@NotNull PsiMethod method) {
        if (method == null) {
            MethodCallUtils.$$$reportNull$$$0(20);
        }
        SuperCallVisitor visitor2 = new SuperCallVisitor(method);
        method.accept((PsiElementVisitor)visitor2);
        return visitor2.isSuperCallFound();
    }

    @Contract(pure=true)
    public static boolean callWithNonConstantString(@NotNull PsiMethodCallExpression expression, boolean considerStaticFinalConstant, @NonNls String className, String ... methodNames) {
        PsiField field;
        PsiReferenceExpression referenceExpression;
        PsiElement target;
        if (expression == null) {
            MethodCallUtils.$$$reportNull$$$0(21);
        }
        String methodName = MethodCallUtils.getMethodName(expression);
        boolean found = false;
        for (String name : methodNames) {
            if (!name.equals(methodName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)className)) {
            return false;
        }
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)ExpressionUtils.getFirstExpressionInList(argumentList));
        if (argument == null) {
            return false;
        }
        PsiType type = argument.getType();
        if (type == null || !type.equalsToText("java.lang.String")) {
            return false;
        }
        if (considerStaticFinalConstant && argument instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)argument).resolve()) instanceof PsiField && (field = (PsiField)target).hasModifierProperty("static") && field.hasModifierProperty("final")) {
            return false;
        }
        return !PsiUtil.isConstantExpression((PsiExpression)argument);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiMethodCallExpression getQualifierMethodCall(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            MethodCallUtils.$$$reportNull$$$0(22);
        }
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCall.getMethodExpression().getQualifierExpression()), PsiMethodCallExpression.class);
    }

    @Contract(pure=true)
    public static boolean isUsedAsSuperConstructorCallArgument(@NotNull PsiParameter parameter, boolean superMustBeLibrary) {
        PsiMethod method;
        block12: {
            block11: {
                PsiElement scope;
                if (parameter == null) {
                    MethodCallUtils.$$$reportNull$$$0(23);
                }
                if (!((scope = parameter.getDeclarationScope()) instanceof PsiMethod)) break block11;
                method = (PsiMethod)scope;
                if (((PsiMethod)scope).isConstructor()) break block12;
            }
            return false;
        }
        HashSet<PsiMethod> checked = new HashSet<PsiMethod>();
        while (true) {
            ProgressManager.checkCanceled();
            if (!checked.add(method)) {
                return false;
            }
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            if (call == null) {
                return false;
            }
            int index = MethodCallUtils.getParameterReferenceIndex(call, parameter);
            if (index < 0) {
                return false;
            }
            JavaResolveResult resolveResult = call.resolveMethodGenerics();
            if (!resolveResult.isValidResult()) {
                return false;
            }
            method = (PsiMethod)resolveResult.getElement();
            if (method == null) {
                return false;
            }
            if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call) && (!superMustBeLibrary || method instanceof PsiCompiledElement)) {
                return true;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            parameter = parameters[Math.min(index, parameters.length - 1)];
        }
    }

    @Nullable
    public static PsiParameter getParameterForArgument(@NotNull PsiExpression argument) {
        PsiParameterList list;
        int count;
        PsiCall call;
        PsiMethod method;
        PsiMethodCallExpression callForQualifier;
        PsiElement argumentParent;
        if (argument == null) {
            MethodCallUtils.$$$reportNull$$$0(24);
        }
        if ((argumentParent = argument.getParent()) instanceof PsiReferenceExpression && (callForQualifier = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argumentParent.getParent(), PsiMethodCallExpression.class)) != null && (method = callForQualifier.resolveMethod()) instanceof PsiExtensionMethod) {
            return ((PsiExtensionMethod)method).getTargetReceiverParameter();
        }
        PsiExpressionList argList = (PsiExpressionList)ObjectUtils.tryCast((Object)argumentParent, PsiExpressionList.class);
        if (argList == null) {
            return null;
        }
        PsiElement parent = argList.getParent();
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        if ((call = (PsiCall)ObjectUtils.tryCast((Object)parent, PsiCall.class)) == null) {
            return null;
        }
        Object[] args = argList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
        if (index == -1) {
            return null;
        }
        PsiMethod method2 = call.resolveMethod();
        if (method2 == null) {
            return null;
        }
        PsiElement navElement = method2.getNavigationElement();
        if (navElement instanceof PsiMethod) {
            PsiMethod navMethod;
            method2 = navMethod = (PsiMethod)navElement;
        }
        if (index >= (count = (list = method2.getParameterList()).getParametersCount())) {
            return null;
        }
        if (MethodCallUtils.isVarArgCall(call) && index >= count - 1) {
            return null;
        }
        return method2 instanceof PsiExtensionMethod ? ((PsiExtensionMethod)method2).getTargetParameter(index) : list.getParameter(index);
    }

    private static int getParameterReferenceIndex(PsiMethodCallExpression call, PsiParameter parameter) {
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < arguments.length; ++i) {
            PsiElement target;
            PsiExpression argument = arguments[i];
            if (!((argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument)) instanceof PsiReferenceExpression) || (target = ((PsiReferenceExpression)argument).resolve()) != parameter) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PsiExpression getArgumentForParameter(@NotNull PsiCall call, @NotNull PsiParameter parameter) {
        PsiMethod scope;
        if (call == null) {
            MethodCallUtils.$$$reportNull$$$0(25);
        }
        if (parameter == null) {
            MethodCallUtils.$$$reportNull$$$0(26);
        }
        if ((scope = (PsiMethod)ObjectUtils.tryCast((Object)parameter.getDeclarationScope(), PsiMethod.class)) == null) {
            return null;
        }
        int index = scope.getParameterList().getParameterIndex(parameter);
        PsiExpressionList argList = call.getArgumentList();
        if (argList == null) {
            return null;
        }
        PsiExpression[] args = argList.getExpressions();
        if (index >= args.length) {
            return null;
        }
        if (parameter.isVarArgs() && !MethodCallUtils.isVarArgCall(call)) {
            return null;
        }
        return args[index];
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calledOnClassName";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToIgnoreCaseCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimpleCallToMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToStaticMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCallOnVariable";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodWithReplacedArgument";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperMethodCall";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperQualifier";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "containsSuperMethodCall";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "callWithNonConstantString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierMethodCall";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsedAsSuperConstructorCallArgument";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterForArgument";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentForParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiMethod myMethod;
        private boolean mySuperCallFound;

        SuperCallVisitor(@NotNull PsiMethod method) {
            if (method == null) {
                SuperCallVisitor.$$$reportNull$$$0(0);
            }
            this.myMethod = method;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SuperCallVisitor.$$$reportNull$$$0(1);
            }
            if (!this.mySuperCallFound) {
                super.visitElement(element);
            }
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiExpression condition;
            Object result;
            if (statement == null) {
                SuperCallVisitor.$$$reportNull$$$0(2);
            }
            if ((result = ExpressionUtils.computeConstantExpression(condition = statement.getCondition())) != null && result.equals(Boolean.FALSE)) {
                return;
            }
            super.visitIfStatement(statement);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                SuperCallVisitor.$$$reportNull$$$0(3);
            }
            if (this.mySuperCallFound) {
                return;
            }
            super.visitMethodCallExpression(expression);
            if (MethodCallUtils.isSuperMethodCall(expression, this.myMethod)) {
                this.mySuperCallFound = true;
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            PsiElement target;
            if (expression == null) {
                SuperCallVisitor.$$$reportNull$$$0(4);
            }
            if (this.mySuperCallFound) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier instanceof PsiSuperExpression && (target = expression.resolve()) instanceof PsiMethod && MethodSignatureUtil.isSuperMethod((PsiMethod)((PsiMethod)target), (PsiMethod)this.myMethod)) {
                this.mySuperCallFound = true;
                return;
            }
            super.visitMethodReferenceExpression(expression);
        }

        boolean isSuperCallFound() {
            return this.mySuperCallFound;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/psiutils/MethodCallUtils$SuperCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIfStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

