/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefOverridable;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class MethodInheritanceUtils {
    private MethodInheritanceUtils() {
    }

    public static Set<RefOverridable> calculateSiblingReferences(RefMethod method) {
        HashSet<RefOverridable> siblingReferences = new HashSet<RefOverridable>();
        Stack pendingReferences = new Stack();
        pendingReferences.add((Object)method);
        while (!pendingReferences.isEmpty()) {
            RefOverridable referenceToAnalyze = (RefOverridable)pendingReferences.pop();
            siblingReferences.add(referenceToAnalyze);
            Collection overridingReferences = referenceToAnalyze.getDerivedReferences();
            for (RefOverridable overridingReference : overridingReferences) {
                if (siblingReferences.contains(overridingReference) || pendingReferences.contains((Object)overridingReference)) continue;
                pendingReferences.add((Object)overridingReference);
            }
            if (!(referenceToAnalyze instanceof RefMethod)) continue;
            Collection superMethods = ((RefMethod)referenceToAnalyze).getSuperMethods();
            for (RefMethod superMethod : superMethods) {
                if (siblingReferences.contains(superMethod) || pendingReferences.contains((Object)superMethod)) continue;
                pendingReferences.add((Object)superMethod);
            }
        }
        return siblingReferences;
    }
}

