/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.RecursionVisitor;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecursionUtils {
    private static final CallMapper<BiPredicate<PsiMethodCallExpression, PsiMethod>> MAY_CAUSE_INDIRECT_RECURSION = new CallMapper<BiPredicate<PsiMethodCallExpression, PsiMethod>>().register((CallMatcher)CallMatcher.staticCall("java.util.Objects", "hashCode", "hash"), (callExpression, method) -> MethodUtils.isHashCode(method) && RecursionUtils.useThisAsArgument(callExpression)).register((CallMatcher)CallMatcher.staticCall("java.util.Objects", "toString"), (callExpression, method) -> MethodUtils.isToString(method) && RecursionUtils.useThisAsArgument(callExpression)).register((CallMatcher)CallMatcher.staticCall("java.lang.String", "valueOf"), (callExpression, method) -> MethodUtils.isToString(method) && RecursionUtils.useThisAsArgument(callExpression)).register((CallMatcher)CallMatcher.staticCall("java.util.Objects", "equals", "deepEquals"), (callExpression, method) -> MethodUtils.isEquals(method) && RecursionUtils.useThisAsArgument(callExpression));

    private RecursionUtils() {
    }

    public static boolean statementMayReturnBeforeRecursing(@Nullable PsiStatement statement, PsiMethod method) {
        PsiStatement psiStatement = statement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiAssertStatement.class, PsiBlockStatement.class, PsiBreakStatement.class, PsiContinueStatement.class, PsiDeclarationStatement.class, PsiDoWhileStatement.class, PsiEmptyStatement.class, PsiExpressionListStatement.class, PsiExpressionStatement.class, PsiForeachStatement.class, PsiForStatement.class, PsiIfStatement.class, PsiLabeledStatement.class, PsiReturnStatement.class, PsiSwitchStatement.class, PsiSynchronizedStatement.class, PsiThrowStatement.class, PsiTryStatement.class, PsiWhileStatement.class}, (Object)psiStatement, n)) {
            case 0 -> {
                PsiAssertStatement ignore = (PsiAssertStatement)psiStatement;
                yield false;
            }
            case 1 -> {
                PsiBlockStatement s = (PsiBlockStatement)psiStatement;
                yield RecursionUtils.codeBlockMayReturnBeforeRecursing(s.getCodeBlock(), method, false);
            }
            case 2 -> {
                PsiBreakStatement ignore = (PsiBreakStatement)psiStatement;
                yield false;
            }
            case 3 -> {
                PsiContinueStatement ignore = (PsiContinueStatement)psiStatement;
                yield false;
            }
            case 4 -> {
                PsiDeclarationStatement ignore = (PsiDeclarationStatement)psiStatement;
                yield false;
            }
            case 5 -> {
                PsiDoWhileStatement s = (PsiDoWhileStatement)psiStatement;
                yield RecursionUtils.statementMayReturnBeforeRecursing(s.getBody(), method);
            }
            case 6 -> {
                PsiEmptyStatement ignore = (PsiEmptyStatement)psiStatement;
                yield false;
            }
            case 7 -> {
                PsiExpressionListStatement ignore = (PsiExpressionListStatement)psiStatement;
                yield false;
            }
            case 8 -> {
                PsiExpressionStatement ignore = (PsiExpressionStatement)psiStatement;
                yield false;
            }
            case 9 -> {
                PsiForeachStatement s = (PsiForeachStatement)psiStatement;
                yield RecursionUtils.foreachStatementMayReturnBeforeRecursing(s, method);
            }
            case 10 -> {
                PsiForStatement s = (PsiForStatement)psiStatement;
                yield RecursionUtils.forStatementMayReturnBeforeRecursing(s, method);
            }
            case 11 -> {
                PsiIfStatement s = (PsiIfStatement)psiStatement;
                yield RecursionUtils.ifStatementMayReturnBeforeRecursing(s, method);
            }
            case 12 -> {
                PsiLabeledStatement s = (PsiLabeledStatement)psiStatement;
                yield RecursionUtils.statementMayReturnBeforeRecursing(s.getStatement(), method);
            }
            case 13 -> {
                PsiReturnStatement s = (PsiReturnStatement)psiStatement;
                yield RecursionUtils.returnStatementMayReturnBeforeRecursing(method, s);
            }
            case 14 -> {
                PsiSwitchStatement s = (PsiSwitchStatement)psiStatement;
                yield RecursionUtils.switchBlockMayReturnBeforeRecursing((PsiSwitchBlock)s, method);
            }
            case 15 -> {
                PsiSynchronizedStatement s = (PsiSynchronizedStatement)psiStatement;
                yield RecursionUtils.codeBlockMayReturnBeforeRecursing(s.getBody(), method, false);
            }
            case 16 -> {
                PsiThrowStatement ignore = (PsiThrowStatement)psiStatement;
                yield false;
            }
            case 17 -> {
                PsiTryStatement s = (PsiTryStatement)psiStatement;
                yield RecursionUtils.tryStatementMayReturnBeforeRecursing(s, method);
            }
            case 18 -> {
                PsiWhileStatement s = (PsiWhileStatement)psiStatement;
                yield RecursionUtils.whileStatementMayReturnBeforeRecursing(s, method);
            }
            default -> true;
        };
    }

    private static boolean returnStatementMayReturnBeforeRecursing(PsiMethod method, PsiReturnStatement s) {
        PsiExpression returnValue = s.getReturnValue();
        return returnValue == null || !RecursionUtils.expressionDefinitelyRecurses(returnValue, method);
    }

    private static boolean whileStatementMayReturnBeforeRecursing(PsiWhileStatement loopStatement, PsiMethod method) {
        return !RecursionUtils.expressionDefinitelyRecurses(loopStatement.getCondition(), method) && RecursionUtils.statementMayReturnBeforeRecursing(loopStatement.getBody(), method);
    }

    private static boolean forStatementMayReturnBeforeRecursing(PsiForStatement loopStatement, PsiMethod method) {
        if (RecursionUtils.statementMayReturnBeforeRecursing(loopStatement.getInitialization(), method)) {
            return true;
        }
        return !RecursionUtils.expressionDefinitelyRecurses(loopStatement.getCondition(), method) && RecursionUtils.statementMayReturnBeforeRecursing(loopStatement.getBody(), method);
    }

    private static boolean foreachStatementMayReturnBeforeRecursing(PsiForeachStatement loopStatement, PsiMethod method) {
        return !RecursionUtils.expressionDefinitelyRecurses(loopStatement.getIteratedValue(), method) && RecursionUtils.statementMayReturnBeforeRecursing(loopStatement.getBody(), method);
    }

    private static boolean switchBlockMayReturnBeforeRecursing(PsiSwitchBlock switchStatement, PsiMethod method) {
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        for (PsiStatement statement : body.getStatements()) {
            PsiSwitchLabeledRuleStatement labeledRuleStatement;
            if (statement instanceof PsiSwitchLabelStatement || !(statement instanceof PsiSwitchLabeledRuleStatement ? RecursionUtils.statementMayReturnBeforeRecursing((labeledRuleStatement = (PsiSwitchLabeledRuleStatement)statement).getBody(), method) : RecursionUtils.statementMayReturnBeforeRecursing(statement, method))) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementMayReturnBeforeRecursing(PsiTryStatement tryStatement, PsiMethod method) {
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            if (RecursionUtils.codeBlockMayReturnBeforeRecursing(finallyBlock, method, false)) {
                return true;
            }
            if (RecursionUtils.codeBlockDefinitelyRecurses(finallyBlock, method)) {
                return false;
            }
        }
        if (RecursionUtils.codeBlockMayReturnBeforeRecursing(tryStatement.getTryBlock(), method, false)) {
            return true;
        }
        for (PsiCodeBlock catchBlock : tryStatement.getCatchBlocks()) {
            if (!RecursionUtils.codeBlockMayReturnBeforeRecursing(catchBlock, method, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementMayReturnBeforeRecursing(PsiIfStatement ifStatement, PsiMethod method) {
        if (RecursionUtils.expressionDefinitelyRecurses(ifStatement.getCondition(), method)) {
            return false;
        }
        if (RecursionUtils.statementMayReturnBeforeRecursing(ifStatement.getThenBranch(), method)) {
            return true;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        return elseBranch != null && RecursionUtils.statementMayReturnBeforeRecursing(elseBranch, method);
    }

    private static boolean codeBlockMayReturnBeforeRecursing(PsiCodeBlock block, PsiMethod method, boolean endsInImplicitReturn) {
        if (block == null) {
            return true;
        }
        for (PsiStatement statement : block.getStatements()) {
            if (RecursionUtils.statementMayReturnBeforeRecursing(statement, method)) {
                return true;
            }
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    public static boolean methodMayRecurse(@NotNull PsiMethod method) {
        if (method == null) {
            RecursionUtils.$$$reportNull$$$0(0);
        }
        RecursionVisitor recursionVisitor = new RecursionVisitor(method);
        method.accept((PsiElementVisitor)recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private static boolean expressionDefinitelyRecurses(@Nullable PsiExpression exp, PsiMethod method) {
        PsiExpression psiExpression = exp;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiArrayAccessExpression.class, PsiArrayInitializerExpression.class, PsiAssignmentExpression.class, PsiBinaryExpression.class, PsiConditionalExpression.class, PsiInstanceOfExpression.class, PsiMethodCallExpression.class, PsiNewExpression.class, PsiParenthesizedExpression.class, PsiReferenceExpression.class, PsiTypeCastExpression.class, PsiUnaryExpression.class}, (Object)psiExpression, n)) {
            case 0 -> {
                PsiArrayAccessExpression e = (PsiArrayAccessExpression)psiExpression;
                yield RecursionUtils.arrayAccessExpressionDefinitelyRecurses(e, method);
            }
            case 1 -> {
                PsiArrayInitializerExpression e = (PsiArrayInitializerExpression)psiExpression;
                yield RecursionUtils.arrayInitializerExpressionDefinitelyRecurses(e, method);
            }
            case 2 -> {
                PsiAssignmentExpression e = (PsiAssignmentExpression)psiExpression;
                yield RecursionUtils.assignmentExpressionDefinitelyRecurses(e, method);
            }
            case 3 -> {
                PsiBinaryExpression e = (PsiBinaryExpression)psiExpression;
                yield RecursionUtils.binaryExpressionDefinitelyRecurses(e, method);
            }
            case 4 -> {
                PsiConditionalExpression e = (PsiConditionalExpression)psiExpression;
                yield RecursionUtils.conditionalExpressionDefinitelyRecurses(e, method);
            }
            case 5 -> {
                PsiInstanceOfExpression e = (PsiInstanceOfExpression)psiExpression;
                yield RecursionUtils.expressionDefinitelyRecurses(e.getOperand(), method);
            }
            case 6 -> {
                PsiMethodCallExpression e = (PsiMethodCallExpression)psiExpression;
                yield RecursionUtils.methodCallExpressionDefinitelyRecurses(e, method);
            }
            case 7 -> {
                PsiNewExpression e = (PsiNewExpression)psiExpression;
                yield RecursionUtils.newExpressionDefinitelyRecurses(e, method);
            }
            case 8 -> {
                PsiParenthesizedExpression e = (PsiParenthesizedExpression)psiExpression;
                yield RecursionUtils.expressionDefinitelyRecurses(e.getExpression(), method);
            }
            case 9 -> {
                PsiReferenceExpression e = (PsiReferenceExpression)psiExpression;
                yield RecursionUtils.expressionDefinitelyRecurses(e.getQualifierExpression(), method);
            }
            case 10 -> {
                PsiTypeCastExpression e = (PsiTypeCastExpression)psiExpression;
                yield RecursionUtils.expressionDefinitelyRecurses(e.getOperand(), method);
            }
            case 11 -> {
                PsiUnaryExpression e = (PsiUnaryExpression)psiExpression;
                yield RecursionUtils.expressionDefinitelyRecurses(e.getOperand(), method);
            }
            default -> false;
        };
    }

    private static boolean conditionalExpressionDefinitelyRecurses(PsiConditionalExpression expression, PsiMethod method) {
        if (RecursionUtils.expressionDefinitelyRecurses(expression.getCondition(), method)) {
            return true;
        }
        return RecursionUtils.expressionDefinitelyRecurses(expression.getThenExpression(), method) && RecursionUtils.expressionDefinitelyRecurses(expression.getElseExpression(), method);
    }

    private static boolean binaryExpressionDefinitelyRecurses(PsiBinaryExpression expression, PsiMethod method) {
        if (RecursionUtils.expressionDefinitelyRecurses(expression.getLOperand(), method)) {
            return true;
        }
        IElementType tokenType = expression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
            return false;
        }
        return RecursionUtils.expressionDefinitelyRecurses(expression.getROperand(), method);
    }

    private static boolean arrayAccessExpressionDefinitelyRecurses(PsiArrayAccessExpression expression, PsiMethod method) {
        return RecursionUtils.expressionDefinitelyRecurses(expression.getArrayExpression(), method) || RecursionUtils.expressionDefinitelyRecurses(expression.getIndexExpression(), method);
    }

    private static boolean arrayInitializerExpressionDefinitelyRecurses(PsiArrayInitializerExpression expression, PsiMethod method) {
        for (PsiExpression initializer : expression.getInitializers()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(initializer, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean assignmentExpressionDefinitelyRecurses(PsiAssignmentExpression assignmentExpression, PsiMethod method) {
        return RecursionUtils.expressionDefinitelyRecurses(assignmentExpression.getRExpression(), method) || RecursionUtils.expressionDefinitelyRecurses(assignmentExpression.getLExpression(), method);
    }

    private static boolean newExpressionDefinitelyRecurses(PsiNewExpression exp, PsiMethod method) {
        for (PsiExpression arrayDimension : exp.getArrayDimensions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arrayDimension, method)) continue;
            return true;
        }
        if (RecursionUtils.expressionDefinitelyRecurses((PsiExpression)exp.getArrayInitializer(), method) || RecursionUtils.expressionDefinitelyRecurses(exp.getQualifier(), method)) {
            return true;
        }
        PsiExpressionList argumentList = exp.getArgumentList();
        if (argumentList != null) {
            for (PsiExpression arg : argumentList.getExpressions()) {
                if (!RecursionUtils.expressionDefinitelyRecurses(arg, method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean methodCallExpressionDefinitelyRecurses(PsiMethodCallExpression exp, PsiMethod method) {
        PsiMethod referencedMethod = exp.resolveMethod();
        if (referencedMethod == null) {
            return false;
        }
        if (RecursionUtils.methodCallExpressionIndirectDefinitelyRecurses(exp, method)) {
            return true;
        }
        PsiReferenceExpression methodExpression = exp.getMethodExpression();
        if (referencedMethod.equals((Object)method)) {
            if (method.hasModifierProperty("static") || method.hasModifierProperty("private")) {
                return true;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
        }
        if (RecursionUtils.expressionDefinitelyRecurses(methodExpression.getQualifierExpression(), method)) {
            return true;
        }
        for (PsiExpression arg : exp.getArgumentList().getExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(arg, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean statementDefinitelyRecurses(PsiStatement statement, PsiMethod method) {
        PsiStatement psiStatement = statement;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiAssertStatement.class, PsiBlockStatement.class, PsiBreakStatement.class, PsiContinueStatement.class, PsiDeclarationStatement.class, PsiDoWhileStatement.class, PsiEmptyStatement.class, PsiExpressionListStatement.class, PsiExpressionStatement.class, PsiForeachStatement.class, PsiForStatement.class, PsiIfStatement.class, PsiLabeledStatement.class, PsiReturnStatement.class, PsiSwitchStatement.class, PsiSynchronizedStatement.class, PsiThrowStatement.class, PsiTryStatement.class, PsiWhileStatement.class, PsiYieldStatement.class}, (Object)psiStatement, n)) {
            case 0 -> {
                PsiAssertStatement ignore = (PsiAssertStatement)psiStatement;
                yield false;
            }
            case 1 -> {
                PsiBlockStatement s = (PsiBlockStatement)psiStatement;
                yield RecursionUtils.codeBlockDefinitelyRecurses(s.getCodeBlock(), method);
            }
            case 2 -> {
                PsiBreakStatement ignore = (PsiBreakStatement)psiStatement;
                yield false;
            }
            case 3 -> {
                PsiContinueStatement ignore = (PsiContinueStatement)psiStatement;
                yield false;
            }
            case 4 -> {
                PsiDeclarationStatement s = (PsiDeclarationStatement)psiStatement;
                for (PsiElement declaredElement : s.getDeclaredElements()) {
                    PsiLocalVariable variable;
                    if (!(declaredElement instanceof PsiLocalVariable) || !RecursionUtils.expressionDefinitelyRecurses((variable = (PsiLocalVariable)declaredElement).getInitializer(), method)) continue;
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                PsiDoWhileStatement s = (PsiDoWhileStatement)psiStatement;
                yield RecursionUtils.doWhileStatementDefinitelyRecurses(s, method);
            }
            case 6 -> {
                PsiEmptyStatement ignore = (PsiEmptyStatement)psiStatement;
                yield false;
            }
            case 7 -> {
                PsiExpressionListStatement s = (PsiExpressionListStatement)psiStatement;
                yield RecursionUtils.expressionListStatementDefinitelyRecurses(s, method);
            }
            case 8 -> {
                PsiExpressionStatement s = (PsiExpressionStatement)psiStatement;
                yield RecursionUtils.expressionDefinitelyRecurses(s.getExpression(), method);
            }
            case 9 -> {
                PsiForeachStatement s = (PsiForeachStatement)psiStatement;
                yield RecursionUtils.expressionDefinitelyRecurses(s.getIteratedValue(), method);
            }
            case 10 -> {
                PsiForStatement s = (PsiForStatement)psiStatement;
                yield RecursionUtils.forStatementDefinitelyRecurses(s, method);
            }
            case 11 -> {
                PsiIfStatement s = (PsiIfStatement)psiStatement;
                yield RecursionUtils.ifStatementDefinitelyRecurses(s, method);
            }
            case 12 -> {
                PsiLabeledStatement s = (PsiLabeledStatement)psiStatement;
                yield RecursionUtils.statementDefinitelyRecurses(s.getStatement(), method);
            }
            case 13 -> {
                PsiReturnStatement s = (PsiReturnStatement)psiStatement;
                PsiExpression returnValue = s.getReturnValue();
                if (returnValue != null && RecursionUtils.expressionDefinitelyRecurses(returnValue, method)) {
                    yield true;
                }
                yield false;
            }
            case 14 -> {
                PsiSwitchStatement s = (PsiSwitchStatement)psiStatement;
                yield RecursionUtils.expressionDefinitelyRecurses(s.getExpression(), method);
            }
            case 15 -> {
                PsiSynchronizedStatement s = (PsiSynchronizedStatement)psiStatement;
                yield RecursionUtils.codeBlockDefinitelyRecurses(s.getBody(), method);
            }
            case 16 -> {
                PsiThrowStatement ignore = (PsiThrowStatement)psiStatement;
                yield false;
            }
            case 17 -> {
                PsiTryStatement s = (PsiTryStatement)psiStatement;
                yield RecursionUtils.tryStatementDefinitelyRecurses(s, method);
            }
            case 18 -> {
                PsiWhileStatement s = (PsiWhileStatement)psiStatement;
                yield RecursionUtils.whileStatementDefinitelyRecurses(s, method);
            }
            case 19 -> {
                PsiYieldStatement s = (PsiYieldStatement)psiStatement;
                yield RecursionUtils.expressionDefinitelyRecurses(s.getExpression(), method);
            }
            default -> false;
        };
    }

    private static boolean expressionListStatementDefinitelyRecurses(PsiExpressionListStatement statement, PsiMethod method) {
        for (PsiExpression expression : statement.getExpressionList().getExpressions()) {
            if (!RecursionUtils.expressionDefinitelyRecurses(expression, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementDefinitelyRecurses(PsiTryStatement tryStatement, PsiMethod method) {
        return RecursionUtils.codeBlockDefinitelyRecurses(tryStatement.getTryBlock(), method) || RecursionUtils.codeBlockDefinitelyRecurses(tryStatement.getFinallyBlock(), method);
    }

    private static boolean codeBlockDefinitelyRecurses(PsiCodeBlock block, PsiMethod method) {
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : block.getStatements()) {
            if (!RecursionUtils.statementDefinitelyRecurses(statement, method)) continue;
            return true;
        }
        return false;
    }

    private static boolean ifStatementDefinitelyRecurses(PsiIfStatement ifStatement, PsiMethod method) {
        PsiExpression condition = ifStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return true;
        }
        PsiStatement thenBranch = ifStatement.getThenBranch();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (thenBranch == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        if (value == Boolean.TRUE) {
            return RecursionUtils.statementDefinitelyRecurses(thenBranch, method);
        }
        if (value == Boolean.FALSE) {
            return RecursionUtils.statementDefinitelyRecurses(elseBranch, method);
        }
        return RecursionUtils.statementDefinitelyRecurses(thenBranch, method) && RecursionUtils.statementDefinitelyRecurses(elseBranch, method);
    }

    private static boolean forStatementDefinitelyRecurses(PsiForStatement forStatement, PsiMethod method) {
        if (RecursionUtils.statementDefinitelyRecurses(forStatement.getInitialization(), method)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return true;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return value == Boolean.TRUE && RecursionUtils.statementDefinitelyRecurses(forStatement.getBody(), method);
    }

    private static boolean whileStatementDefinitelyRecurses(PsiWhileStatement whileStatement, PsiMethod method) {
        PsiExpression condition = whileStatement.getCondition();
        if (RecursionUtils.expressionDefinitelyRecurses(condition, method)) {
            return true;
        }
        Object value = ExpressionUtils.computeConstantExpression(condition);
        return value == Boolean.TRUE && RecursionUtils.statementDefinitelyRecurses(whileStatement.getBody(), method);
    }

    private static boolean doWhileStatementDefinitelyRecurses(PsiDoWhileStatement doWhileStatement, PsiMethod method) {
        return RecursionUtils.statementDefinitelyRecurses(doWhileStatement.getBody(), method) || RecursionUtils.expressionDefinitelyRecurses(doWhileStatement.getCondition(), method);
    }

    public static boolean methodDefinitelyRecurses(@NotNull PsiMethod method) {
        PsiCodeBlock body;
        if (method == null) {
            RecursionUtils.$$$reportNull$$$0(1);
        }
        return (body = method.getBody()) != null && !RecursionUtils.codeBlockMayReturnBeforeRecursing(body, method, true);
    }

    static boolean methodCallExpressionIndirectDefinitelyRecurses(PsiMethodCallExpression exp, PsiMethod method) {
        BiPredicate<PsiMethodCallExpression, PsiMethod> predicate = MAY_CAUSE_INDIRECT_RECURSION.mapFirst(exp);
        return predicate != null && predicate.test(exp, method);
    }

    private static boolean useThisAsArgument(PsiMethodCallExpression expression) {
        return ContainerUtil.findInstance((Object[])expression.getArgumentList().getExpressions(), PsiThisExpression.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "method";
        objectArray2[1] = "com/siyeh/ig/psiutils/RecursionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "methodMayRecurse";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "methodDefinitelyRecurses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

