/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ReorderingUtils {
    private static final @Unmodifiable List<Function<PsiExpression, ExceptionProblem>> PROBLEM_EXTRACTORS = List.of(NullDereferenceExceptionProblem::from, ClassCastExceptionProblem::from, ArrayIndexExceptionProblem::from, ContractFailExceptionProblem::from);

    public static ThreeState canExtract(@NotNull PsiExpression ancestor, @NotNull PsiExpression expression) {
        PsiExpression gParent;
        if (ancestor == null) {
            ReorderingUtils.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            ReorderingUtils.$$$reportNull$$$0(1);
        }
        if (expression == ancestor) {
            return ThreeState.YES;
        }
        if (PsiUtil.isConstantExpression((PsiExpression)expression)) {
            return ThreeState.YES;
        }
        for (PsiVariable variable : VariableAccessUtils.collectUsedVariables((PsiElement)expression)) {
            if (!(variable instanceof PsiPatternVariable) || !PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)variable, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)variable, (boolean)true)) continue;
            return ThreeState.NO;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiExpressionList && (gParent = (PsiExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiCallExpression.class)) != null) {
            Object[] args = ((PsiExpressionList)parent).getExpressions();
            int index = ArrayUtil.indexOf((Object[])args, (Object)expression);
            ThreeState result = ThreeState.YES;
            for (int i = 0; i < index; ++i) {
                if (!SideEffectChecker.mayHaveSideEffects((PsiExpression)args[i])) continue;
                result = ThreeState.UNSURE;
                break;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, gParent));
        }
        PsiExpression expressionParent = (PsiExpression)ObjectUtils.tryCast((Object)parent, PsiExpression.class);
        if (expressionParent == null) {
            if (PsiTreeUtil.isAncestor((PsiElement)ancestor, (PsiElement)expression, (boolean)true)) {
                return ThreeState.UNSURE;
            }
            throw new IllegalArgumentException("Should be an ancestor");
        }
        if (expressionParent instanceof PsiParenthesizedExpression || expressionParent instanceof PsiInstanceOfExpression || expressionParent instanceof PsiTypeCastExpression) {
            return ReorderingUtils.canExtract(ancestor, expressionParent);
        }
        if (expressionParent instanceof PsiReferenceExpression && ((PsiReferenceExpression)expressionParent).getQualifierExpression() == expression) {
            return ReorderingUtils.canExtract(ancestor, expressionParent);
        }
        if (expressionParent instanceof PsiConditionalExpression) {
            ThreeState result;
            PsiConditionalExpression ternary = (PsiConditionalExpression)expressionParent;
            PsiExpression condition = ternary.getCondition();
            if (condition == expression) {
                return ReorderingUtils.canExtract(ancestor, expressionParent);
            }
            if (ReorderingUtils.isSideEffectFree(condition, false) && ReorderingUtils.isSideEffectFree(expression, false)) {
                result = ThreeState.YES;
            } else {
                boolean isNecessary = ReorderingUtils.areConditionsNecessaryFor(new PsiExpression[]{condition}, expression, ternary.getElseExpression() == expression);
                result = isNecessary ? ThreeState.NO : ThreeState.UNSURE;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, expressionParent));
        }
        if (expressionParent instanceof PsiLambdaExpression) {
            return ThreeState.NO;
        }
        if (expressionParent instanceof PsiUnaryExpression) {
            if (PsiUtil.isIncrementDecrementOperation((PsiElement)expressionParent)) {
                return ThreeState.NO;
            }
            return ReorderingUtils.canExtract(ancestor, expressionParent);
        }
        if (expressionParent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)expressionParent;
            Object[] operands = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands, (Object)expression);
            if (index == 0) {
                return ReorderingUtils.canExtract(ancestor, expressionParent);
            }
            IElementType tokenType = polyadic.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR)) {
                return ReorderingUtils.and(ReorderingUtils.canMoveToStart(polyadic, index), () -> ReorderingUtils.canExtract(ancestor, expressionParent));
            }
            ThreeState result = ThreeState.YES;
            for (int i = 0; i < index; ++i) {
                if (!SideEffectChecker.mayHaveSideEffects((PsiExpression)operands[i])) continue;
                result = ThreeState.UNSURE;
                break;
            }
            return ReorderingUtils.and(result, () -> ReorderingUtils.canExtract(ancestor, expressionParent));
        }
        if (expressionParent instanceof PsiAssignmentExpression) {
            if (expression == ((PsiAssignmentExpression)expressionParent).getLExpression()) {
                return ThreeState.NO;
            }
            return ReorderingUtils.canExtract(ancestor, expressionParent);
        }
        return ReorderingUtils.and(ThreeState.UNSURE, () -> ReorderingUtils.canExtract(ancestor, expressionParent));
    }

    @NotNull
    private static ThreeState and(ThreeState state, Supplier<? extends ThreeState> conjunct) {
        if (state == ThreeState.NO) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(2);
            }
            return threeState;
        }
        ThreeState state2 = conjunct.get();
        if (state2 == ThreeState.NO) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(3);
            }
            return threeState;
        }
        if (state == ThreeState.UNSURE || state2 == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(4);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            ReorderingUtils.$$$reportNull$$$0(5);
        }
        return threeState;
    }

    @NotNull
    private static ThreeState canMoveToStart(PsiPolyadicExpression polyadicExpression, int operandIndex) {
        if (operandIndex == 0) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(6);
            }
            return threeState;
        }
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (tokenType != JavaTokenType.ANDAND && tokenType != JavaTokenType.OROR) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(7);
            }
            return threeState;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operandIndex < 0 || operandIndex >= operands.length) {
            throw new IndexOutOfBoundsException("operandIndex = " + operandIndex);
        }
        if (Arrays.stream(operands, 0, operandIndex + 1).allMatch(expression -> ReorderingUtils.isSideEffectFree(expression, false))) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(8);
            }
            return threeState;
        }
        boolean and = polyadicExpression.getOperationTokenType() == JavaTokenType.ANDAND;
        PsiExpression lastOperand = operands[operandIndex];
        if (ReorderingUtils.areConditionsNecessaryFor(Arrays.copyOf(operands, operandIndex), lastOperand, !and)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReorderingUtils.$$$reportNull$$$0(9);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            ReorderingUtils.$$$reportNull$$$0(10);
        }
        return threeState;
    }

    private static boolean hasContract(PsiExpression expression, PsiExpression operand, ContractReturnValue value) {
        expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (value.equals(ContractReturnValue.returnNull()) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(operand, expression)) {
            return true;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList.isEmpty()) {
                return false;
            }
            List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
            for (MethodContract methodContract : contracts) {
                PsiExpression arg;
                PsiExpression[] args;
                ContractValue condition;
                int argIndex;
                List<ContractValue> conditions;
                if (!methodContract.getReturnValue().equals(value) || (conditions = methodContract.getConditions()).size() != 1 || (argIndex = (condition = conditions.get(0)).getNullCheckedArgument(true).orElse(-1)) < 0 || argIndex >= (args = argumentList.getExpressions()).length || !ReorderingUtils.hasContract(arg = args[argIndex], operand, ContractReturnValue.returnNull())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static List<ExceptionProblem> fromExpression(PsiExpression expression) {
        ArrayList<ExceptionProblem> problems = new ArrayList<ExceptionProblem>();
        for (Function<PsiExpression, ExceptionProblem> extractor : PROBLEM_EXTRACTORS) {
            ExceptionProblem exceptionProblem = extractor.apply(expression);
            if (exceptionProblem == null) continue;
            problems.add(exceptionProblem);
        }
        ArrayList<ExceptionProblem> arrayList = problems;
        if (arrayList == null) {
            ReorderingUtils.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static boolean areConditionsNecessaryFor(PsiExpression[] conditions, PsiExpression operand, boolean negated) {
        List problems = SyntaxTraverser.psiTraverser((PsiElement)operand).traverse().filter(PsiExpression.class).flatMap(ReorderingUtils::fromExpression).filter(Objects::nonNull).toList();
        if (problems.isEmpty()) {
            return false;
        }
        for (PsiExpression condition : conditions) {
            if (!ReorderingUtils.isConditionNecessary(condition, problems, negated)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConditionNecessary(PsiExpression condition, @Unmodifiable List<? extends ExceptionProblem> problems, boolean negated) {
        if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null) {
            return false;
        }
        if (BoolUtils.isNegation(condition)) {
            return ReorderingUtils.isConditionNecessary(BoolUtils.getNegated(condition), problems, !negated);
        }
        if (condition instanceof PsiPolyadicExpression) {
            IElementType type = ((PsiPolyadicExpression)condition).getOperationTokenType();
            if (type.equals(JavaTokenType.ANDAND) && !negated || type.equals(JavaTokenType.OROR) && negated) {
                for (PsiExpression operand : ((PsiPolyadicExpression)condition).getOperands()) {
                    if (!ReorderingUtils.isConditionNecessary(operand, problems, negated)) continue;
                    return true;
                }
                return false;
            }
            if (type.equals(JavaTokenType.ANDAND) && negated || type.equals(JavaTokenType.OROR) && !negated) {
                for (PsiExpression operand : ((PsiPolyadicExpression)condition).getOperands()) {
                    if (ReorderingUtils.isConditionNecessary(operand, problems, negated)) continue;
                    return false;
                }
                return true;
            }
        }
        for (ExceptionProblem exceptionProblem : problems) {
            if (!exceptionProblem.isNecessaryCheck(condition, negated)) continue;
            return true;
        }
        return false;
    }

    private static boolean isErroneous(PsiElement element) {
        return element instanceof PsiErrorElement || element instanceof OuterLanguageElement || element instanceof PsiLiteralExpression && PsiLiteralUtil.isUnsafeLiteral((PsiLiteralExpression)((PsiLiteralExpression)element));
    }

    public static boolean isSideEffectFree(PsiExpression expression, boolean allowNpe) {
        return PsiTreeUtil.processElements((PsiElement)expression, element -> {
            PsiPolyadicExpression expr;
            PsiType type;
            if (element instanceof PsiMethodCallExpression) {
                PsiMethod method = ((PsiMethodCallExpression)element).resolveMethod();
                if (method == null || !JavaMethodContractUtil.isPure(method)) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass != null && "java.lang.String".equals(aClass.getQualifiedName());
            }
            if (element instanceof PsiCallExpression || element instanceof PsiArrayAccessExpression || element instanceof PsiTypeCastExpression || ReorderingUtils.isErroneous(element)) {
                return false;
            }
            if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                return false;
            }
            if (element instanceof PsiSwitchExpression) {
                return false;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiExpression qualifier;
                PsiReferenceExpression ref = (PsiReferenceExpression)element;
                if (!allowNpe && (qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)ref.getQualifierExpression())) != null && NullabilityUtil.getExpressionNullability(qualifier) != Nullability.NOT_NULL) {
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement target = ((PsiReferenceExpression)qualifier).resolve();
                        return target instanceof PsiClass || target instanceof PsiPackage;
                    }
                    return false;
                }
                type = ref.getType();
                PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)ref, false);
                if (type != null && !(type instanceof PsiPrimitiveType) && expectedType instanceof PsiPrimitiveType) {
                    return false;
                }
            }
            if (element instanceof PsiPolyadicExpression && ((type = (expr = (PsiPolyadicExpression)element).getOperationTokenType()).equals(JavaTokenType.DIV) || type.equals(JavaTokenType.PERC))) {
                PsiExpression[] operands = expr.getOperands();
                if (operands.length != 2) {
                    return false;
                }
                Object divisor = ExpressionUtils.computeConstantExpression(operands[1]);
                if (!(divisor instanceof Integer) && !(divisor instanceof Long) || ((Number)divisor).longValue() == 0L) {
                    return false;
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ReorderingUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ReorderingUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "canMoveToStart";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canExtract";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static abstract class ExceptionProblem {
        final PsiExpression myOperand;

        ExceptionProblem(PsiExpression operand) {
            this.myOperand = operand;
        }

        abstract boolean isNecessaryCheck(PsiExpression var1, boolean var2);
    }

    static final class ContractFailExceptionProblem
    extends ExceptionProblem {
        private final DfaValueFactory myFactory;
        private final List<DfaRelation> myConditions;

        ContractFailExceptionProblem(DfaValueFactory factory, List<DfaRelation> conditions) {
            super(null);
            this.myFactory = factory;
            this.myConditions = conditions;
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition, boolean negated) {
            PsiBinaryExpression binOp;
            RelationType relationType;
            if (condition instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)condition;
                List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
                if (contracts.isEmpty()) {
                    return false;
                }
                for (MethodContract methodContract : contracts) {
                    ContractValue cond;
                    DfaCondition value;
                    if (!(methodContract.getReturnValue() instanceof ContractReturnValue.BooleanReturnValue)) continue;
                    boolean retValue = ((ContractReturnValue.BooleanReturnValue)methodContract.getReturnValue()).getValue();
                    List<ContractValue> conditions = methodContract.getConditions();
                    if (conditions.size() != 1 || !((value = (cond = conditions.get(0)).fromCall(this.myFactory, (PsiCallExpression)call)) instanceof DfaRelation) || !this.myConditions.contains(retValue == negated ? value : ((DfaRelation)value).negate())) continue;
                    return true;
                }
                return false;
            }
            if (condition instanceof PsiBinaryExpression && (relationType = DfaPsiUtil.getRelationByToken((binOp = (PsiBinaryExpression)condition).getOperationTokenType())) != null) {
                PsiExpression left = binOp.getLOperand();
                PsiExpression psiExpression = binOp.getROperand();
                DfaValue leftVal = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, left);
                DfaValue rightVal = JavaDfaValueFactory.getExpressionDfaValue(this.myFactory, psiExpression);
                if (leftVal == null || rightVal == null) {
                    return false;
                }
                DfaCondition value1 = leftVal.cond(relationType, rightVal);
                DfaCondition value2 = rightVal.cond(Objects.requireNonNull(relationType.getFlipped()), leftVal);
                if (value1 instanceof DfaRelation && this.myConditions.contains(negated ? value1 : ((DfaRelation)value1).negate())) {
                    return true;
                }
                if (value2 instanceof DfaRelation && this.myConditions.contains(negated ? value2 : ((DfaRelation)value2).negate())) {
                    return true;
                }
            }
            return false;
        }

        static ContractFailExceptionProblem from(PsiExpression expression) {
            if (expression instanceof PsiCallExpression) {
                PsiCallExpression call = (PsiCallExpression)expression;
                PsiMethod method = call.resolveMethod();
                List contracts = DfaUtil.addRangeContracts(method, JavaMethodContractUtil.getMethodCallContracts(call));
                if ((contracts = ContainerUtil.filter(contracts, c -> c.getReturnValue().isFail() && c.getConditions().size() == 1)).isEmpty()) {
                    return null;
                }
                DfaValueFactory factory = new DfaValueFactory(expression.getProject());
                ArrayList<DfaRelation> conditions = new ArrayList<DfaRelation>();
                for (MethodContract contract : contracts) {
                    ContractValue condition = contract.getConditions().get(0);
                    DfaCondition conditionValue = condition.fromCall(factory, call);
                    if (!(conditionValue instanceof DfaRelation)) continue;
                    conditions.add((DfaRelation)conditionValue);
                }
                return new ContractFailExceptionProblem(factory, conditions);
            }
            return null;
        }
    }

    static final class ArrayIndexExceptionProblem
    extends ExceptionProblem {
        private ArrayIndexExceptionProblem(PsiExpression operand) {
            super(operand);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition, boolean negated) {
            IElementType token;
            if (condition instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation(token = ((PsiBinaryExpression)condition).getOperationTokenType()) && !token.equals(JavaTokenType.EQEQ) && !token.equals(JavaTokenType.NE)) {
                PsiExpression left = ((PsiBinaryExpression)condition).getLOperand();
                PsiExpression right = ((PsiBinaryExpression)condition).getROperand();
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(left, this.myOperand) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(right, this.myOperand);
            }
            return false;
        }

        static ArrayIndexExceptionProblem from(PsiExpression expression) {
            if (expression instanceof PsiArrayAccessExpression) {
                return new ArrayIndexExceptionProblem(((PsiArrayAccessExpression)expression).getIndexExpression());
            }
            return null;
        }
    }

    static final class ClassCastExceptionProblem
    extends ExceptionProblem {
        private ClassCastExceptionProblem(PsiExpression operand) {
            super(operand);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition, boolean negated) {
            if (negated) {
                return false;
            }
            if (condition instanceof PsiInstanceOfExpression) {
                PsiExpression op = ((PsiInstanceOfExpression)condition).getOperand();
                return EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(op, this.myOperand);
            }
            return false;
        }

        static ClassCastExceptionProblem from(PsiExpression expression) {
            if (expression instanceof PsiTypeCastExpression) {
                return new ClassCastExceptionProblem(((PsiTypeCastExpression)expression).getOperand());
            }
            return null;
        }
    }

    static final class NullDereferenceExceptionProblem
    extends ExceptionProblem {
        private NullDereferenceExceptionProblem(PsiExpression operand) {
            super(operand);
        }

        @Override
        boolean isNecessaryCheck(PsiExpression condition, boolean negated) {
            IElementType tokenType;
            if (condition instanceof PsiBinaryExpression && ((tokenType = ((PsiBinaryExpression)condition).getOperationTokenType()).equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE))) {
                boolean notNull = negated != tokenType.equals(JavaTokenType.EQEQ);
                ContractReturnValue returnValue = notNull ? ContractReturnValue.returnNotNull() : ContractReturnValue.returnNull();
                PsiExpression left = ((PsiBinaryExpression)condition).getLOperand();
                PsiExpression right = ((PsiBinaryExpression)condition).getROperand();
                if (ExpressionUtils.isNullLiteral(left)) {
                    return ReorderingUtils.hasContract(right, this.myOperand, returnValue);
                }
                if (ExpressionUtils.isNullLiteral(right)) {
                    return ReorderingUtils.hasContract(left, this.myOperand, returnValue);
                }
            }
            return ReorderingUtils.hasContract(condition, this.myOperand, ContractReturnValue.returnBoolean(negated));
        }

        static NullDereferenceExceptionProblem from(PsiExpression expression) {
            NullabilityProblemKind.NullabilityProblem<?> problem = NullabilityProblemKind.fromContext(expression, Collections.emptyMap());
            if (problem != null && problem.thrownException() != null) {
                return new NullDereferenceExceptionProblem(expression);
            }
            return null;
        }
    }
}

