/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.Unmodifiable;

public final class SealedUtils {
    private SealedUtils() {
    }

    public static void addClassToPermitsList(@NotNull PsiClass psiClass, @NotNull String fqn) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            SealedUtils.$$$reportNull$$$0(1);
        }
        HashSet<String> missingInheritors = new HashSet<String>();
        missingInheritors.add(fqn);
        if (psiClass.getPermitsList() == null) {
            missingInheritors.addAll(SealedUtils.findSameFileInheritors(psiClass, new PsiClass[0]));
        }
        SealedUtils.fillPermitsList(psiClass, missingInheritors);
    }

    public static void fillPermitsList(@NotNull PsiClass psiClass, @NotNull @Unmodifiable Collection<String> missingInheritors) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(2);
        }
        if (missingInheritors == null) {
            SealedUtils.$$$reportNull$$$0(3);
        }
        PsiReferenceList permitsList = psiClass.getPermitsList();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)psiClass.getProject());
        if (permitsList == null) {
            PsiReferenceList implementsList = Objects.requireNonNull(psiClass.getImplementsList());
            String permitsClause = ((StreamEx)StreamEx.of(missingInheritors).sorted()).joining((CharSequence)",", (CharSequence)"permits ", (CharSequence)"");
            psiClass.addAfter((PsiElement)SealedUtils.createPermitsClause(factory, permitsClause), (PsiElement)implementsList);
        } else {
            Stream<String> curClasses = Arrays.stream(permitsList.getReferenceElements()).map(PsiJavaCodeReferenceElement::getQualifiedName);
            String permitsClause = ((StreamEx)((StreamEx)StreamEx.of(missingInheritors).append(curClasses)).sorted()).joining((CharSequence)",", (CharSequence)"permits ", (CharSequence)"");
            permitsList.replace((PsiElement)SealedUtils.createPermitsClause(factory, permitsClause));
        }
    }

    @NotNull
    private static PsiReferenceList createPermitsClause(@NotNull PsiFileFactory factory, @NotNull String permitsClause) {
        if (factory == null) {
            SealedUtils.$$$reportNull$$$0(4);
        }
        if (permitsClause == null) {
            SealedUtils.$$$reportNull$$$0(5);
        }
        PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText((Language)JavaLanguage.INSTANCE, (CharSequence)("class __Dummy " + permitsClause + "{}"));
        PsiClass newClass = javaFile.getClasses()[0];
        PsiReferenceList psiReferenceList = Objects.requireNonNull(newClass.getPermitsList());
        if (psiReferenceList == null) {
            SealedUtils.$$$reportNull$$$0(6);
        }
        return psiReferenceList;
    }

    public static boolean hasSealedParent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(7);
        }
        return StreamEx.of((Object[])psiClass.getExtendsListTypes()).append((Object[])psiClass.getImplementsListTypes()).map(r -> r.resolve()).anyMatch(parent -> parent != null && parent.hasModifierProperty("sealed"));
    }

    public static @Unmodifiable Collection<PsiClass> findSameFileInheritorsClasses(@NotNull PsiClass psiClass, PsiClass ... classesToExclude) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(8);
        }
        if (classesToExclude == null) {
            SealedUtils.$$$reportNull$$$0(9);
        }
        return SealedUtils.getClasses(psiClass, Function.identity(), classesToExclude);
    }

    public static @Unmodifiable Collection<String> findSameFileInheritors(@NotNull PsiClass psiClass, PsiClass ... classesToExclude) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(10);
        }
        if (classesToExclude == null) {
            SealedUtils.$$$reportNull$$$0(11);
        }
        return SealedUtils.getClasses(psiClass, PsiClass::getQualifiedName, classesToExclude);
    }

    @NotNull
    private static <T> @Unmodifiable Collection<T> getClasses(@NotNull PsiClass psiClass, Function<? super PsiClass, T> mapper, PsiClass ... classesToExclude) {
        if (psiClass == null) {
            SealedUtils.$$$reportNull$$$0(12);
        }
        if (classesToExclude == null) {
            SealedUtils.$$$reportNull$$$0(13);
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)psiClass.getContainingFile().getOriginalFile());
        Collection collection = DirectClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)fileScope).filtering(inheritor -> !ArrayUtil.contains((Object)inheritor, (Object[])classesToExclude)).filtering(cls -> !(cls instanceof PsiAnonymousClass) && !PsiUtil.isLocalClass((PsiClass)cls)).mapping(mapper).findAll();
        if (collection == null) {
            SealedUtils.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public static void removeFromPermitsList(@NotNull PsiClass parent, @NotNull PsiClass exChild) {
        PsiReferenceList permitsList;
        if (parent == null) {
            SealedUtils.$$$reportNull$$$0(15);
        }
        if (exChild == null) {
            SealedUtils.$$$reportNull$$$0(16);
        }
        if ((permitsList = parent.getPermitsList()) == null) {
            return;
        }
        Object[] childRefs = permitsList.getReferenceElements();
        PsiJavaCodeReferenceElement exChildRef = (PsiJavaCodeReferenceElement)ContainerUtil.find((Object[])childRefs, ref -> ref.resolve() == exChild);
        if (exChildRef == null) {
            return;
        }
        exChildRef.delete();
        if (childRefs.length != 1) {
            return;
        }
        PsiModifierList modifiers = parent.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty("sealed", false);
    }

    @Nullable
    public static @PropertyKey(resourceBundle="messages.JavaBundle") String checkInheritor(@NotNull PsiJavaFile parentFile, @Nullable PsiJavaModule module, @NotNull PsiClass inheritor) {
        if (parentFile == null) {
            SealedUtils.$$$reportNull$$$0(17);
        }
        if (inheritor == null) {
            SealedUtils.$$$reportNull$$$0(18);
        }
        @PropertyKey(resourceBundle="messages.JavaBundle") String result = null;
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)inheritor)) {
            result = "intention.error.make.sealed.class.has.anonymous.or.local.inheritors";
        } else if (module == null) {
            PsiJavaFile file = (PsiJavaFile)ObjectUtils.tryCast((Object)inheritor.getContainingFile(), PsiJavaFile.class);
            if (file == null || file.getOriginalFile() instanceof PsiCompiledElement) {
                result = "intention.error.make.sealed.class.inheritors.not.in.java.file";
            } else if (!parentFile.getPackageName().equals(file.getPackageName())) {
                result = "intention.error.make.sealed.class.different.packages";
            }
        } else if (JavaPsiModuleUtil.findDescriptorByElement((PsiElement)inheritor) != module) {
            result = "intention.error.make.sealed.class.different.modules";
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingInheritors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permitsClause";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/SealedUtils";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToExclude";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exChild";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/SealedUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPermitsClause";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClassToPermitsList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillPermitsList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPermitsClause";
                break;
            }
            case 6: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasSealedParent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSameFileInheritorsClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findSameFileInheritors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeFromPermitsList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkInheritor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14 -> new IllegalStateException(string);
        };
    }
}

