/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type) {
        return StreamApiUtil.getStreamElementType(type, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getStreamElementType(PsiType type, boolean variableType) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.IntStream")) {
            return PsiTypes.intType();
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.LongStream")) {
            return PsiTypes.longType();
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.DoubleStream")) {
            return PsiTypes.doubleType();
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.util.stream.Stream")) {
            return null;
        }
        PsiType streamType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.stream.Stream", (int)0, (boolean)false);
        if (variableType) {
            if (streamType instanceof PsiIntersectionType) {
                return null;
            }
            streamType = GenericsUtil.getVariableTypeByExpressionType((PsiType)streamType);
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression) {
        if (ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        String name = call.getMethodExpression().getReferenceName();
        if (!"empty".equals(name) && !"of".equals(name) || !call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || !method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.util.stream.");
    }

    @Contract(value="null -> false")
    public static boolean isSupportedStreamElement(PsiType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.equals(PsiTypes.intType()) || type.equals(PsiTypes.longType()) || type.equals(PsiTypes.doubleType());
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getStreamClassForType(@Nullable PsiType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            if (type.equals(PsiTypes.intType())) {
                return "java.util.stream.IntStream";
            }
            if (type.equals(PsiTypes.longType())) {
                return "java.util.stream.LongStream";
            }
            if (type.equals(PsiTypes.doubleType())) {
                return "java.util.stream.DoubleStream";
            }
            return null;
        }
        return "java.util.stream.Stream";
    }

    @Nullable
    public static PsiMethodCallExpression findSubsequentCall(PsiMethodCallExpression call, Predicate<? super String> isWantedCall, Predicate<? super String> isAllowedIntermediateCall) {
        return StreamApiUtil.findSubsequentCall(call, isWantedCall, c -> false, isAllowedIntermediateCall);
    }

    @Nullable
    public static PsiMethodCallExpression findSubsequentCall(PsiMethodCallExpression call, Predicate<? super String> isWantedCall, Predicate<? super PsiMethodCallExpression> isWantedCollector, Predicate<? super String> isAllowedIntermediateCall) {
        PsiMethodCallExpression chainCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        while (chainCall != null) {
            PsiMethodCallExpression collectorCall;
            PsiExpression[] args;
            String name = chainCall.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            if (isWantedCall.test(name)) {
                return chainCall;
            }
            if (name.equals("collect") && (args = chainCall.getArgumentList().getExpressions()).length == 1 && (collectorCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), PsiMethodCallExpression.class)) != null && isWantedCollector.test((PsiMethodCallExpression)collectorCall)) {
                return collectorCall;
            }
            if (!isAllowedIntermediateCall.test(name) || !InheritanceUtil.isInheritor((PsiType)chainCall.getType(), (String)"java.util.stream.BaseStream")) {
                return null;
            }
            chainCall = ExpressionUtils.getCallForQualifier((PsiExpression)chainCall);
        }
        return null;
    }
}

