/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SynchronizationUtil {
    private SynchronizationUtil() {
    }

    public static boolean isInSynchronizedContext(PsiElement element) {
        PsiMethod modifierListOwner;
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiSynchronizedStatement.class, PsiClass.class, PsiLambdaExpression.class});
        if (context instanceof PsiSynchronizedStatement) {
            return true;
        }
        if (context instanceof PsiMethod && (modifierListOwner = (PsiMethod)context).hasModifierProperty("synchronized")) {
            return true;
        }
        if (context instanceof PsiMethod || context instanceof PsiLambdaExpression) {
            PsiAssertStatement assertStatement = SynchronizationUtil.findHoldsLockAssertion(context);
            return assertStatement != null && assertStatement.getTextOffset() + assertStatement.getTextLength() < element.getTextOffset();
        }
        return false;
    }

    private static PsiAssertStatement findHoldsLockAssertion(PsiElement context) {
        return (PsiAssertStatement)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            HoldsLockAssertionVisitor visitor2 = new HoldsLockAssertionVisitor();
            context.accept((PsiElementVisitor)visitor2);
            return CachedValueProvider.Result.create((Object)visitor2.getAssertStatement(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isCallToHoldsLock(PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        @NonNls String name = methodExpression.getReferenceName();
        if (!"holdsLock".equals(name)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Thread");
    }

    private static class HoldsLockAssertionVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiAssertStatement myAssertStatement = null;

        private HoldsLockAssertionVisitor() {
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                HoldsLockAssertionVisitor.$$$reportNull$$$0(0);
            }
            if (this.myAssertStatement != null) {
                return;
            }
            super.visitAssertStatement(statement);
            PsiExpression condition = statement.getAssertCondition();
            if (SynchronizationUtil.isCallToHoldsLock(condition)) {
                this.myAssertStatement = statement;
                this.stopWalking();
            }
        }

        public PsiAssertStatement getAssertStatement() {
            return this.myAssertStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/SynchronizationUtil$HoldsLockAssertionVisitor", "visitAssertStatement"));
        }
    }
}

