/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachPatternStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UninitializedReadCollector {
    private final Set<PsiExpression> uninitializedReads = new HashSet<PsiExpression>();
    private int counter = 0;

    public PsiExpression @NotNull [] getUninitializedReads() {
        PsiExpression[] psiExpressionArray = this.uninitializedReads.toArray(PsiExpression.EMPTY_ARRAY);
        if (psiExpressionArray == null) {
            UninitializedReadCollector.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    public boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(1);
        }
        return this.blockAssignsVariable(block, variable, this.counter, new HashSet<MethodSignature>());
    }

    private boolean blockAssignsVariable(@Nullable PsiCodeBlock block, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(2);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(3);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (block == null) {
            return false;
        }
        for (PsiStatement statement : block.getStatements()) {
            if (this.statementAssignsVariable(statement, variable, stamp, checkedMethods)) {
                return true;
            }
            if (this.counter == stamp) continue;
            return true;
        }
        return false;
    }

    private boolean statementAssignsVariable(@Nullable PsiStatement statement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(4);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(5);
        }
        if (statement == null) {
            return false;
        }
        if (ExceptionUtils.statementThrowsException(statement)) {
            return true;
        }
        if (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement || statement instanceof PsiAssertStatement || statement instanceof PsiEmptyStatement) {
            return false;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            return this.expressionAssignsVariable(returnStatement.getReturnValue(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)statement;
            return this.expressionAssignsVariable(throwStatement.getException(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiExpressionListStatement) {
            PsiExpressionListStatement list = (PsiExpressionListStatement)statement;
            for (PsiExpression expression : list.getExpressionList().getExpressions()) {
                if (!this.expressionAssignsVariable(expression, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            return this.expressionAssignsVariable(expressionStatement.getExpression(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiDeclarationStatement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            return this.declarationStatementAssignsVariable(declarationStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)statement;
            return this.forStatementAssignsVariable(forStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiForeachStatement) {
            return false;
        }
        if (statement instanceof PsiForeachPatternStatement) {
            return false;
        }
        if (statement instanceof PsiWhileStatement) {
            PsiWhileStatement whileStatement = (PsiWhileStatement)statement;
            return this.whileStatementAssignsVariable(whileStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiDoWhileStatement) {
            PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)statement;
            return this.doWhileAssignsVariable(doWhileStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            return this.blockAssignsVariable(synchronizedStatement.getBody(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement;
            return this.blockAssignsVariable(blockStatement.getCodeBlock(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
            return this.statementAssignsVariable(labeledStatement.getStatement(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            return this.ifStatementAssignsVariable(ifStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)statement;
            return this.tryStatementAssignsVariable(tryStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSwitchStatement) {
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)statement;
            return this.switchBlockAssignsVariable((PsiSwitchBlock)switchStatement, variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement instanceof PsiSwitchLabeledRuleStatement) {
            PsiSwitchLabeledRuleStatement switchLabeledRuleStatement = (PsiSwitchLabeledRuleStatement)statement;
            return this.statementAssignsVariable(switchLabeledRuleStatement.getBody(), variable, stamp, checkedMethods);
        }
        if (statement instanceof PsiYieldStatement) {
            PsiYieldStatement yieldStatement = (PsiYieldStatement)statement;
            return this.expressionAssignsVariable(yieldStatement.getExpression(), variable, stamp, checkedMethods);
        }
        assert (false) : "unknown statement: " + String.valueOf(statement);
        return false;
    }

    private boolean switchBlockAssignsVariable(@NotNull PsiSwitchBlock switchBlock, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (switchBlock == null) {
            UninitializedReadCollector.$$$reportNull$$$0(6);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(7);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(8);
        }
        if (this.expressionAssignsVariable(switchBlock.getExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiCodeBlock body = switchBlock.getBody();
        if (body == null) {
            return false;
        }
        PsiStatement[] statements = body.getStatements();
        boolean containsDefault = false;
        boolean assigns = false;
        for (int i = 0; i < statements.length; ++i) {
            PsiStatement statement = statements[i];
            if (statement instanceof PsiSwitchLabelStatement) {
                PsiSwitchLabelStatement labelStatement = (PsiSwitchLabelStatement)statement;
                if (i == statements.length - 1) {
                    return false;
                }
                if (labelStatement.isDefaultCase()) {
                    containsDefault = true;
                }
                assigns = false;
                continue;
            }
            if (statement instanceof PsiBreakStatement) {
                PsiBreakStatement breakStatement = (PsiBreakStatement)statement;
                if (breakStatement.getLabelIdentifier() == null && assigns) continue;
                return false;
            }
            if (statement instanceof PsiYieldStatement) {
                PsiYieldStatement yieldStatement = (PsiYieldStatement)statement;
                PsiExpression valueExpression = yieldStatement.getExpression();
                if (assigns) continue;
                if (this.expressionAssignsVariable(valueExpression, variable, stamp, checkedMethods)) {
                    assigns = true;
                    continue;
                }
                return false;
            }
            if (i != statements.length - 1 || (assigns |= this.statementAssignsVariable(statement, variable, stamp, checkedMethods))) continue;
            return false;
        }
        return assigns && (containsDefault || switchBlock instanceof PsiSwitchExpression);
    }

    private boolean declarationStatementAssignsVariable(@NotNull PsiDeclarationStatement declarationStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (declarationStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(9);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(10);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(11);
        }
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            PsiVariable variableElement;
            if (!(element instanceof PsiVariable) || !this.expressionAssignsVariable((variableElement = (PsiVariable)element).getInitializer(), variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean tryStatementAssignsVariable(@NotNull PsiTryStatement tryStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiResourceList resourceList;
        if (tryStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(12);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(13);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(14);
        }
        if ((resourceList = tryStatement.getResourceList()) != null) {
            for (PsiResourceListElement resource : resourceList) {
                PsiResourceVariable resourceVariable;
                if (!(resource instanceof PsiResourceVariable) || !this.expressionAssignsVariable((resourceVariable = (PsiResourceVariable)resource).getInitializer(), variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        boolean initializedInTryOrCatch = this.blockAssignsVariable(tryStatement.getTryBlock(), variable, stamp, checkedMethods);
        for (PsiCodeBlock catchBlock : tryStatement.getCatchBlocks()) {
            initializedInTryOrCatch &= this.blockAssignsVariable(catchBlock, variable, stamp, checkedMethods);
        }
        if (initializedInTryOrCatch) {
            return true;
        }
        return this.blockAssignsVariable(tryStatement.getFinallyBlock(), variable, stamp, checkedMethods);
    }

    private boolean ifStatementAssignsVariable(@NotNull PsiIfStatement ifStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (ifStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(15);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(16);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(17);
        }
        if (this.expressionAssignsVariable(ifStatement.getCondition(), variable, stamp, checkedMethods)) {
            return true;
        }
        return this.statementAssignsVariable(ifStatement.getThenBranch(), variable, stamp, checkedMethods) && this.statementAssignsVariable(ifStatement.getElseBranch(), variable, stamp, checkedMethods);
    }

    private boolean doWhileAssignsVariable(@NotNull PsiDoWhileStatement doWhileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (doWhileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(18);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(19);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(20);
        }
        return this.statementAssignsVariable(doWhileStatement.getBody(), variable, stamp, checkedMethods) || this.expressionAssignsVariable(doWhileStatement.getCondition(), variable, stamp, checkedMethods);
    }

    private boolean whileStatementAssignsVariable(@NotNull PsiWhileStatement whileStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression condition;
        if (whileStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(21);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(22);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(23);
        }
        if (this.expressionAssignsVariable(condition = whileStatement.getCondition(), variable, stamp, checkedMethods)) {
            return true;
        }
        return BoolUtils.isTrue(condition) && this.statementAssignsVariable(whileStatement.getBody(), variable, stamp, checkedMethods);
    }

    private boolean forStatementAssignsVariable(@NotNull PsiForStatement forStatement, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (forStatement == null) {
            UninitializedReadCollector.$$$reportNull$$$0(24);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(25);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(26);
        }
        if (this.statementAssignsVariable(forStatement.getInitialization(), variable, stamp, checkedMethods)) {
            return true;
        }
        PsiExpression condition = forStatement.getCondition();
        if (this.expressionAssignsVariable(condition, variable, stamp, checkedMethods)) {
            return true;
        }
        if (BoolUtils.isTrue(condition)) {
            if (this.statementAssignsVariable(forStatement.getBody(), variable, stamp, checkedMethods)) {
                return true;
            }
            if (this.statementAssignsVariable(forStatement.getUpdate(), variable, stamp, checkedMethods)) {
                return true;
            }
        }
        return false;
    }

    private boolean expressionAssignsVariable(@Nullable PsiExpression expression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(27);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(28);
        }
        if (this.counter != stamp) {
            return true;
        }
        if (expression == null) {
            return false;
        }
        if (expression instanceof PsiThisExpression || expression instanceof PsiLiteralExpression || expression instanceof PsiSuperExpression || expression instanceof PsiClassObjectAccessExpression || expression instanceof PsiLambdaExpression) {
            return false;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            return this.referenceExpressionAssignsVariable(referenceExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            return this.methodCallAssignsVariable(callExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            return this.newExpressionAssignsVariable(newExpression, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression array = (PsiArrayInitializerExpression)expression;
            for (PsiExpression initializer : array.getInitializers()) {
                if (!this.expressionAssignsVariable(initializer, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCast = (PsiTypeCastExpression)expression;
            return this.expressionAssignsVariable(typeCast.getOperand(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)expression;
            return this.expressionAssignsVariable(accessExpression.getArrayExpression(), variable, stamp, checkedMethods) || this.expressionAssignsVariable(accessExpression.getIndexExpression(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiUnaryExpression) {
            PsiUnaryExpression unaryExpression = (PsiUnaryExpression)expression;
            return this.expressionAssignsVariable(unaryExpression.getOperand(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (!this.expressionAssignsVariable(operand, variable, stamp, checkedMethods)) continue;
                return true;
            }
            return false;
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression;
            if (this.expressionAssignsVariable(conditional.getCondition(), variable, stamp, checkedMethods)) {
                return true;
            }
            return this.expressionAssignsVariable(conditional.getThenExpression(), variable, stamp, checkedMethods) && this.expressionAssignsVariable(conditional.getElseExpression(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)expression;
            return this.assignmentExpressionAssignsVariable(assignment, variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            return this.expressionAssignsVariable(parenthesizedExpression.getExpression(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            return this.expressionAssignsVariable(instanceOfExpression.getOperand(), variable, stamp, checkedMethods);
        }
        if (expression instanceof PsiSwitchExpression) {
            PsiSwitchExpression switchExpression = (PsiSwitchExpression)expression;
            return this.switchBlockAssignsVariable((PsiSwitchBlock)switchExpression, variable, stamp, checkedMethods);
        }
        return false;
    }

    private boolean assignmentExpressionAssignsVariable(@NotNull PsiAssignmentExpression assignment, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiElement element;
        PsiExpression lhs;
        if (assignment == null) {
            UninitializedReadCollector.$$$reportNull$$$0(29);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(30);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(31);
        }
        if (this.expressionAssignsVariable(lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()), variable, stamp, checkedMethods)) {
            return true;
        }
        if (this.expressionAssignsVariable(assignment.getRExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        return lhs instanceof PsiReferenceExpression && (element = ((PsiReference)lhs).resolve()) != null && element.equals((Object)variable);
    }

    private boolean referenceExpressionAssignsVariable(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpression qualifierExpression;
        if (referenceExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(32);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(33);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(34);
        }
        if (this.expressionAssignsVariable(qualifierExpression = referenceExpression.getQualifierExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        if (variable.equals((Object)referenceExpression.resolve())) {
            PsiExpression expression;
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)referenceExpression);
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (rhs != null && rhs.equals((Object)referenceExpression)) {
                    this.checkReferenceExpression(referenceExpression, variable, qualifierExpression);
                }
            } else if (!(parent instanceof PsiExpression) || !ComparisonUtils.isNullComparison(expression = (PsiExpression)parent)) {
                this.checkReferenceExpression(referenceExpression, variable, qualifierExpression);
            }
        }
        return false;
    }

    private void checkReferenceExpression(PsiReferenceExpression referenceExpression, PsiVariable variable, PsiExpression qualifierExpression) {
        PsiReferenceExpression reference;
        PsiElement target;
        if (!referenceExpression.isQualified() || qualifierExpression instanceof PsiThisExpression) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        } else if (variable.hasModifierProperty("static") && qualifierExpression instanceof PsiReferenceExpression && (target = (reference = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiClass && target.equals((Object)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class))) {
            this.uninitializedReads.add((PsiExpression)referenceExpression);
            ++this.counter;
        }
    }

    private boolean newExpressionAssignsVariable(@NotNull PsiNewExpression newExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        PsiExpressionList argumentList;
        if (newExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(35);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(36);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(37);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            for (PsiExpression arg : argumentList.getExpressions()) {
                if (!this.expressionAssignsVariable(arg, variable, stamp, checkedMethods)) continue;
                return true;
            }
        }
        if (this.expressionAssignsVariable((PsiExpression)newExpression.getArrayInitializer(), variable, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression dim : newExpression.getArrayDimensions()) {
            if (!this.expressionAssignsVariable(dim, variable, stamp, checkedMethods)) continue;
            return true;
        }
        return false;
    }

    private boolean methodCallAssignsVariable(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiVariable variable, int stamp, @NotNull Set<MethodSignature> checkedMethods) {
        if (callExpression == null) {
            UninitializedReadCollector.$$$reportNull$$$0(38);
        }
        if (variable == null) {
            UninitializedReadCollector.$$$reportNull$$$0(39);
        }
        if (checkedMethods == null) {
            UninitializedReadCollector.$$$reportNull$$$0(40);
        }
        if (this.expressionAssignsVariable((PsiExpression)callExpression.getMethodExpression(), variable, stamp, checkedMethods)) {
            return true;
        }
        for (PsiExpression argument : callExpression.getArgumentList().getExpressions()) {
            if (!this.expressionAssignsVariable(argument, variable, stamp, checkedMethods)) continue;
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        if (!checkedMethods.add(method.getSignature(PsiSubstitutor.EMPTY))) {
            return false;
        }
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)callExpression);
        PsiClass calledClass = method.getContainingClass();
        if (calledClass == null || !calledClass.equals((Object)containingClass)) {
            return false;
        }
        if (method.hasModifierProperty("static") || method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("final") || calledClass.hasModifierProperty("final")) {
            return this.blockAssignsVariable(method.getBody(), variable, stamp, checkedMethods);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedMethods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doWhileStatement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whileStatement";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUninitializedReads";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/UninitializedReadCollector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "blockAssignsVariable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "statementAssignsVariable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "switchBlockAssignsVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "declarationStatementAssignsVariable";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryStatementAssignsVariable";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ifStatementAssignsVariable";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doWhileAssignsVariable";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "whileStatementAssignsVariable";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forStatementAssignsVariable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "expressionAssignsVariable";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assignmentExpressionAssignsVariable";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "referenceExpressionAssignsVariable";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "newExpressionAssignsVariable";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "methodCallAssignsVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 -> new IllegalArgumentException(string);
        };
    }
}

