/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class UnusedLabelInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnusedLabelVisitor();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unused.label.problem.descriptor", new Object[0]);
        if (string == null) {
            UnusedLabelInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnusedLabelFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/redundancy/UnusedLabelInspection", "buildErrorString"));
    }

    private static class UnusedLabelVisitor
    extends BaseInspectionVisitor {
        private UnusedLabelVisitor() {
        }

        public void visitLabeledStatement(@NotNull PsiLabeledStatement statement) {
            if (statement == null) {
                UnusedLabelVisitor.$$$reportNull$$$0(0);
            }
            if (UnusedLabelVisitor.containsBreakOrContinueForLabel(statement)) {
                return;
            }
            PsiIdentifier labelIdentifier = statement.getLabelIdentifier();
            this.registerError((PsiElement)labelIdentifier, new Object[0]);
        }

        private static boolean containsBreakOrContinueForLabel(PsiLabeledStatement statement) {
            LabelFinder labelFinder = new LabelFinder(statement);
            statement.accept((PsiElementVisitor)labelFinder);
            return labelFinder.jumpFound();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/redundancy/UnusedLabelInspection$UnusedLabelVisitor", "visitLabeledStatement"));
        }
    }

    private static class UnusedLabelFix
    extends PsiUpdateModCommandQuickFix {
        private UnusedLabelFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unused.label.remove.quickfix", new Object[0]);
            if (string == null) {
                UnusedLabelFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement label, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnusedLabelFix.$$$reportNull$$$0(1);
            }
            if (label == null) {
                UnusedLabelFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnusedLabelFix.$$$reportNull$$$0(3);
            }
            if (!((parent = label.getParent()) instanceof PsiLabeledStatement)) {
                return;
            }
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)parent;
            PsiStatement statement = labeledStatement.getStatement();
            if (statement == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String statementText = commentTracker.text((PsiElement)statement);
            PsiReplacementUtil.replaceStatement((PsiStatement)labeledStatement, statementText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/redundancy/UnusedLabelInspection$UnusedLabelFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/redundancy/UnusedLabelInspection$UnusedLabelFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class LabelFinder
    extends JavaRecursiveElementWalkingVisitor {
        private boolean found;
        private final String label;

        private LabelFinder(PsiLabeledStatement target) {
            PsiIdentifier labelIdentifier = target.getLabelIdentifier();
            this.label = labelIdentifier.getText();
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                LabelFinder.$$$reportNull$$$0(0);
            }
            if (this.found) {
                return;
            }
            super.visitElement(element);
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement continueStatement) {
            if (continueStatement == null) {
                LabelFinder.$$$reportNull$$$0(1);
            }
            if (this.found) {
                return;
            }
            super.visitContinueStatement(continueStatement);
            PsiIdentifier labelIdentifier = continueStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement breakStatement) {
            if (breakStatement == null) {
                LabelFinder.$$$reportNull$$$0(2);
            }
            if (this.found) {
                return;
            }
            super.visitBreakStatement(breakStatement);
            PsiIdentifier labelIdentifier = breakStatement.getLabelIdentifier();
            if (this.labelMatches(labelIdentifier)) {
                this.found = true;
            }
        }

        private boolean labelMatches(PsiIdentifier labelIdentifier) {
            if (labelIdentifier == null) {
                return false;
            }
            String labelText = labelIdentifier.getText();
            return labelText.equals(this.label);
        }

        boolean jumpFound() {
            return this.found;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "continueStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakStatement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/redundancy/UnusedLabelInspection$LabelFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContinueStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBreakStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

