/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MissingSerialAnnotationInspection
extends BaseInspection {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.SERIAL_ANNOTATION);
        if (set == null) {
            MissingSerialAnnotationInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... infos) {
        Object member = infos[0];
        if (member instanceof PsiField) {
            String string = InspectionGadgetsBundle.message("missing.serial.annotation.on.field.problem.descriptor", member);
            if (string == null) {
                MissingSerialAnnotationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("missing.serial.annotation.on.method.problem.descriptor", member);
        if (string == null) {
            MissingSerialAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SerialAnnotationVisitor();
    }

    @Nullable
    static PsiClass getSerializablePsiClass(@NotNull PsiElement psiElement) {
        PsiClass psiClass;
        if (psiElement == null) {
            MissingSerialAnnotationInspection.$$$reportNull$$$0(3);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) == null) {
            return null;
        }
        return !psiClass.isEnum() && SerializationUtils.isSerializable(psiClass) ? psiClass : null;
    }

    static boolean isSerialMethodInSerializable(@NotNull PsiMethod method) {
        if (method == null) {
            MissingSerialAnnotationInspection.$$$reportNull$$$0(4);
        }
        if (method.hasModifierProperty("private") && (SerializationUtils.isWriteObject(method) || SerializationUtils.isReadObject(method) || SerializationUtils.isReadObjectNoData(method))) {
            return true;
        }
        return MissingSerialAnnotationInspection.isSerialMethodInExternalizable(method);
    }

    static boolean isSerialMethodInExternalizable(@NotNull PsiMethod method) {
        if (method == null) {
            MissingSerialAnnotationInspection.$$$reportNull$$$0(5);
        }
        return SerializationUtils.isWriteReplace(method) || SerializationUtils.isReadResolve(method);
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return LocalQuickFix.from((ModCommandAction)new AddAnnotationModCommandAction("java.io.Serial", (PsiModifierListOwner)infos[0], new String[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/serialization/MissingSerialAnnotationInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/serialization/MissingSerialAnnotationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSerializablePsiClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSerialMethodInSerializable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSerialMethodInExternalizable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static class SerialAnnotationVisitor
    extends BaseInspectionVisitor {
        private SerialAnnotationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            boolean candidateToBeAnnotated;
            if (field == null) {
                SerialAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasAnnotation("java.io.Serial")) {
                return;
            }
            PsiClass pClass = MissingSerialAnnotationInspection.getSerializablePsiClass((PsiElement)field);
            if (pClass == null) {
                return;
            }
            if (pClass.isRecord()) {
                candidateToBeAnnotated = SerializationUtils.isSerialVersionUid(field);
            } else {
                boolean bl = SerializationUtils.isExternalizable(pClass) ? SerializationUtils.isSerialVersionUid(field) : (candidateToBeAnnotated = SerializationUtils.isSerialVersionUid(field) || SerializationUtils.isSerialPersistentFields(field));
            }
            if (candidateToBeAnnotated) {
                this.registerFieldError(field, field);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            boolean candidateToBeAnnotated;
            if (method == null) {
                SerialAnnotationVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            if (method.hasAnnotation("java.io.Serial")) {
                return;
            }
            PsiClass pClass = MissingSerialAnnotationInspection.getSerializablePsiClass((PsiElement)method);
            if (pClass == null) {
                return;
            }
            if (pClass.isRecord()) {
                candidateToBeAnnotated = MissingSerialAnnotationInspection.isSerialMethodInExternalizable(method);
            } else {
                boolean bl = candidateToBeAnnotated = SerializationUtils.isExternalizable(pClass) ? MissingSerialAnnotationInspection.isSerialMethodInExternalizable(method) : MissingSerialAnnotationInspection.isSerialMethodInSerializable(method);
            }
            if (candidateToBeAnnotated) {
                this.registerMethodError(method, method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/serialization/MissingSerialAnnotationInspection$SerialAnnotationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

