/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CallToStringConcatCanBeReplacedByOperatorInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.problem.descriptor", new Object[0]);
        if (string == null) {
            CallToStringConcatCanBeReplacedByOperatorInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new CallToStringConcatCanBeReplacedByOperatorFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CallToStringConcatCanBeReplacedByOperatorVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection", "buildErrorString"));
    }

    private static class CallToStringConcatCanBeReplacedByOperatorFix
    extends PsiUpdateModCommandQuickFix {
        private CallToStringConcatCanBeReplacedByOperatorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("call.to.string.concat.can.be.replaced.by.operator.quickfix", new Object[0]);
            if (string == null) {
                CallToStringConcatCanBeReplacedByOperatorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            PsiElement parent;
            if (project == null) {
                CallToStringConcatCanBeReplacedByOperatorFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CallToStringConcatCanBeReplacedByOperatorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                CallToStringConcatCanBeReplacedByOperatorFix.$$$reportNull$$$0(3);
            }
            if (!((parent = (element = startElement).getParent()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = referenceExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement grandParent = referenceExpression.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            CommentTracker tracker = new CommentTracker();
            @NonNls String newExpression = tracker.text((PsiElement)qualifier) + "+" + tracker.text((PsiElement)argument);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection$CallToStringConcatCanBeReplacedByOperatorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection$CallToStringConcatCanBeReplacedByOperatorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CallToStringConcatCanBeReplacedByOperatorVisitor
    extends BaseInspectionVisitor {
        private CallToStringConcatCanBeReplacedByOperatorVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                CallToStringConcatCanBeReplacedByOperatorVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            Project project = expression.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass stringClass = psiFacade.findClass("java.lang.String", expression.getResolveScope());
            if (stringClass == null) {
                return;
            }
            PsiClassType stringType = psiFacade.getElementFactory().createType(stringClass);
            if (!MethodCallUtils.isCallToMethod(expression, "java.lang.String", (PsiType)stringType, "concat", new PsiType[]{stringType})) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/CallToStringConcatCanBeReplacedByOperatorInspection$CallToStringConcatCanBeReplacedByOperatorVisitor", "visitMethodCallExpression"));
        }
    }
}

