/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;

public final class ConstantOnWrongSideOfComparisonInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean myConstantShouldGoLeft = true;
    public boolean myIgnoreNull = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = this.myConstantShouldGoLeft ? InspectionGadgetsBundle.message("constant.on.rhs.of.comparison.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            ConstantOnWrongSideOfComparisonInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.dropdown((String)"myConstantShouldGoLeft", (String)JavaAnalysisBundle.message((String)"inspection.constant.on.wrong.side.of.a.comparison.side.option", (Object[])new Object[0]), (OptDropdown.Option[])new OptDropdown.Option[]{OptPane.option((String)"true", (String)InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.options.item.left", new Object[0])), OptPane.option((String)"false", (String)InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.options.item.right", new Object[0]))}), OptPane.checkbox((String)"myIgnoreNull", (String)InspectionGadgetsBundle.message("checkbox.ignore.null.on.wrong.side", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ConstantOnWrongSideOfComparisonInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new SwapComparisonFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnSideOfComparisonVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/ConstantOnWrongSideOfComparisonInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SwapComparisonFix
    extends PsiUpdateModCommandQuickFix {
        private SwapComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("flip.comparison.quickfix", new Object[0]);
            if (string == null) {
                SwapComparisonFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiElement element;
            if (project == null) {
                SwapComparisonFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                SwapComparisonFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SwapComparisonFix.$$$reportNull$$$0(3);
            }
            if (!((element = startElement.getParent()) instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression expression = (PsiBinaryExpression)element;
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            String flippedComparison = ComparisonUtils.getFlippedComparison(expression.getOperationTokenType());
            if (flippedComparison == null) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            CommentTracker commentTracker = new CommentTracker();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, commentTracker.text((PsiElement)rhs) + flippedComparison + commentTracker.text((PsiElement)lhs), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/ConstantOnWrongSideOfComparisonInspection$SwapComparisonFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/ConstantOnWrongSideOfComparisonInspection$SwapComparisonFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ConstantOnSideOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnSideOfComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ConstantOnSideOfComparisonVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!this.isConstantExpression(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? lhs : rhs) && this.isConstantExpression(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? rhs : lhs) && !ErrorUtil.containsDeepError((PsiElement)expression)) {
                this.registerError((PsiElement)(ConstantOnWrongSideOfComparisonInspection.this.myConstantShouldGoLeft ? rhs : lhs), new Object[0]);
            }
        }

        private boolean isConstantExpression(PsiExpression expression) {
            if (ExpressionUtils.isNullLiteral(expression)) {
                return !ConstantOnWrongSideOfComparisonInspection.this.myIgnoreNull;
            }
            return PsiUtil.isConstantExpression((PsiExpression)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ConstantOnWrongSideOfComparisonInspection$ConstantOnSideOfComparisonVisitor", "visitBinaryExpression"));
        }
    }
}

