/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFragment;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Set;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public final class EscapedSpaceInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.TEXT_BLOCK_ESCAPES);
        if (set == null) {
            EscapedSpaceInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EscapedSpaceInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitFragment(@NotNull PsiFragment fragment) {
                if (fragment == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.check((PsiElement)fragment, fragment.isTextBlock());
            }

            public void visitLiteralExpression(@NotNull PsiLiteralExpression literal) {
                PsiType type;
                if (literal == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!TypeUtils.isJavaLangString(type = literal.getType()) && !PsiTypes.charType().equals((Object)type)) {
                    return;
                }
                this.check((PsiElement)literal, literal.isTextBlock());
            }

            private void check(@NotNull PsiElement fragment, boolean textBlock) {
                if (fragment == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (int pos : EscapedSpaceInspection.findPositions(fragment.getText(), textBlock)) {
                    holder.registerProblem(fragment, TextRange.create((int)pos, (int)(pos + 2)), textBlock ? InspectionGadgetsBundle.message("inspection.use.of.slash.s.message", new Object[0]) : InspectionGadgetsBundle.message("inspection.use.of.slash.s.non.text.block.message", new Object[0]), new LocalQuickFix[]{new ReplaceWithSpaceFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fragment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/style/EscapedSpaceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFragment";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "check";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int[] findPositions(String text, boolean block) {
        int pos = 1;
        IntArrayList list = new IntArrayList();
        while ((pos = text.indexOf(92, pos)) != -1 && pos != text.length() - 1) {
            char next = text.charAt(pos + 1);
            if (next == 'u') {
                pos += 2;
                while (pos < text.length() && text.charAt(pos) == 'u') {
                    ++pos;
                }
                pos += 4;
                continue;
            }
            pos += 2;
            if (next >= '0' && next <= '9') {
                if (pos < text.length() && text.charAt(pos) >= '0' && text.charAt(pos) <= '9') {
                    ++pos;
                }
                if (pos >= text.length() || text.charAt(pos) < '0' || text.charAt(pos) > '9') continue;
                ++pos;
                continue;
            }
            if (next != 's' || pos > 4 && text.startsWith("\\s", pos - 4) || text.startsWith("\\s", pos) || block && (pos == text.length() || text.charAt(pos) == '\n' || pos == text.length() - 3 && text.endsWith("\"\"\""))) continue;
            list.add(pos - 2);
        }
        return list.toIntArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/EscapedSpaceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/EscapedSpaceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ReplaceWithSpaceFix
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithSpaceFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("inspection.use.of.slash.s.fix.family", new Object[0]);
            if (string == null) {
                ReplaceWithSpaceFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            int[] positions;
            if (project == null) {
                ReplaceWithSpaceFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithSpaceFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithSpaceFix.$$$reportNull$$$0(3);
            }
            String text = element.getText();
            if (element instanceof PsiLiteralExpression) {
                PsiLiteralExpression literal = (PsiLiteralExpression)element;
                positions = EscapedSpaceInspection.findPositions(text, literal.isTextBlock());
            } else if (element instanceof PsiFragment) {
                PsiFragment fragment = (PsiFragment)element;
                positions = EscapedSpaceInspection.findPositions(text, fragment.isTextBlock());
            } else {
                return;
            }
            String newText = IntStreamEx.of((int[])positions).takeWhile(pos -> pos < text.length() - 2).boxed().prepend((Object)-2).append((Object)text.length()).pairMap((start, end) -> text.substring(start + 2, (int)end)).joining((CharSequence)" ");
            if (element instanceof PsiFragment) {
                PsiReplacementUtil.replaceFragment((PsiFragment)element, newText);
            } else {
                element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newText, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/EscapedSpaceInspection$ReplaceWithSpaceFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/EscapedSpaceInspection$ReplaceWithSpaceFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

