/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.refactoring.util.ModifierListUtil;
import com.intellij.util.SmartList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class MissortedModifiersInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_requireAnnotationsFirst = true;
    public boolean typeUseWithType = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiModifierList modifierList = (PsiModifierList)infos[0];
        List<String> modifiers = MissortedModifiersInspection.getModifiers(modifierList);
        List<String> sortedModifiers = ModifierListUtil.getSortedModifiers(modifierList, null, !this.typeUseWithType);
        List<String> missortedModifiers = MissortedModifiersInspection.stripCommonPrefixSuffix(modifiers, sortedModifiers);
        String string = InspectionGadgetsBundle.message("missorted.modifiers.problem.descriptor", String.join((CharSequence)" ", missortedModifiers));
        if (string == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static <E> List<E> stripCommonPrefixSuffix(List<E> list1, List<E> list2) {
        int max = list1.size() - MissortedModifiersInspection.commonSuffixLength(list1, list2);
        SmartList result = new SmartList();
        for (int i = 0; i < max; ++i) {
            E token = list1.get(i);
            if (token.equals(list2.get(i))) continue;
            result.add(token);
        }
        return result;
    }

    @Contract(pure=true)
    private static <E> int commonSuffixLength(@NotNull List<E> l1, @NotNull List<E> l2) {
        int i;
        if (l1 == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(1);
        }
        if (l2 == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(2);
        }
        int size1 = l1.size();
        int size2 = l2.size();
        if (size1 == 0 || size2 == 0) {
            return 0;
        }
        for (i = 0; i < size1 && i < size2 && l1.get(size1 - i - 1).equals(l2.get(size2 - i - 1)); ++i) {
        }
        return i;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MissortedModifiersVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new SortModifiersFix();
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(3);
        }
        this.defaultWriteSettings(node, "typeUseWithType");
        this.writeBooleanOption(node, "typeUseWithType", false);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_requireAnnotationsFirst", (String)InspectionGadgetsBundle.message("missorted.modifiers.require.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"typeUseWithType", (String)InspectionGadgetsBundle.message("missorted.modifiers.allowed.place", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.raw((String)InspectionGadgetsBundle.message("missorted.modifiers.allowed.place.description", JavaBundle.message((String)"generate.type.use.before.type", (Object[])new Object[0]))))}).description(HtmlChunk.raw((String)InspectionGadgetsBundle.message("missorted.modifiers.require.option.description", new Object[0])))});
        if (optPane == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    private static List<String> getModifiers(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            MissortedModifiersInspection.$$$reportNull$$$0(5);
        }
        return Stream.of(modifierList.getChildren()).filter(e -> e instanceof PsiJavaToken || e instanceof PsiAnnotation).map(PsiElement::getText).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/MissortedModifiersInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }

    private class MissortedModifiersVisitor
    extends BaseInspectionVisitor {
        private final Comparator<String> modifierComparator = new ModifierListUtil.ModifierComparator();

        private MissortedModifiersVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            this.checkForMissortedModifiers((PsiModifierListOwner)aClass);
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(1);
            }
            super.visitClassInitializer(initializer);
            this.checkForMissortedModifiers((PsiModifierListOwner)initializer);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(2);
            }
            super.visitLocalVariable(variable);
            this.checkForMissortedModifiers((PsiModifierListOwner)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(3);
            }
            super.visitParameter(parameter);
            this.checkForMissortedModifiers((PsiModifierListOwner)parameter);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(4);
            }
            super.visitMethod(method);
            this.checkForMissortedModifiers((PsiModifierListOwner)method);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(5);
            }
            super.visitField(field);
            this.checkForMissortedModifiers((PsiModifierListOwner)field);
        }

        public void visitRequiresStatement(@NotNull PsiRequiresStatement statement) {
            if (statement == null) {
                MissortedModifiersVisitor.$$$reportNull$$$0(6);
            }
            super.visitRequiresStatement(statement);
            this.checkForMissortedModifiers((PsiModifierListOwner)statement);
        }

        private void checkForMissortedModifiers(PsiModifierListOwner listOwner) {
            PsiModifierList modifierList = listOwner.getModifierList();
            if (modifierList == null) {
                return;
            }
            PsiElement modifier = this.getFirstMisorderedModifier(modifierList);
            if (modifier == null) {
                return;
            }
            this.registerError((PsiElement)(this.isVisibleHighlight((PsiElement)modifierList) ? modifier : modifierList), modifierList);
        }

        private PsiElement getFirstMisorderedModifier(PsiModifierList modifierList) {
            if (modifierList == null) {
                return null;
            }
            ArrayDeque<PsiElement> modifiers = new ArrayDeque<PsiElement>();
            PsiAnnotation typeAnnotation = null;
            for (PsiElement child : modifierList.getChildren()) {
                if (child instanceof PsiJavaToken) {
                    if (typeAnnotation != null) {
                        return typeAnnotation;
                    }
                    String text = child.getText();
                    if (!modifiers.isEmpty() && this.modifierComparator.compare(text, ((PsiElement)modifiers.getLast()).getText()) < 0) {
                        while (!modifiers.isEmpty()) {
                            PsiElement first = (PsiElement)modifiers.pollFirst();
                            if (this.modifierComparator.compare(text, first.getText()) >= 0) continue;
                            return first;
                        }
                    }
                    modifiers.add(child);
                }
                if (!(child instanceof PsiAnnotation)) continue;
                PsiAnnotation annotation = (PsiAnnotation)child;
                if (MissortedModifiersInspection.this.m_requireAnnotationsFirst) {
                    if (AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation) && !ModifierListUtil.isMethodWithVoidReturnType(modifierList.getParent())) {
                        PsiAnnotation.TargetType[] targets;
                        if (MissortedModifiersInspection.this.typeUseWithType && ModifierListUtil.isTypeAnnotationAlwaysUseWithType((PsiElement)annotation) || !modifiers.isEmpty()) {
                            typeAnnotation = annotation;
                        }
                        if ((targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)annotation.getOwner())).length <= 0 || AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{targets[0]}) != PsiAnnotation.TargetType.UNKNOWN) continue;
                        typeAnnotation = annotation;
                        continue;
                    }
                    if (!MissortedModifiersInspection.this.m_requireAnnotationsFirst || modifiers.isEmpty()) continue;
                    return (PsiElement)modifiers.getFirst();
                }
                if (modifiers.isEmpty()) continue;
                typeAnnotation = annotation;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection$MissortedModifiersVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassInitializer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRequiresStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SortModifiersFix
    extends PsiUpdateModCommandQuickFix {
        private SortModifiersFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("missorted.modifiers.sort.quickfix", new Object[0]);
            if (string == null) {
                SortModifiersFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                SortModifiersFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SortModifiersFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SortModifiersFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiModifierList) && !((element = element.getParent()) instanceof PsiModifierList)) {
                return;
            }
            PsiModifierList modifierList = (PsiModifierList)element;
            PsiModifierList newModifierList = ModifierListUtil.createSortedModifierList(modifierList, null, !MissortedModifiersInspection.this.typeUseWithType);
            if (newModifierList != null) {
                new CommentTracker().replaceAndRestoreComments((PsiElement)modifierList, (PsiElement)newModifierList);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/MissortedModifiersInspection$SortModifiersFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/MissortedModifiersInspection$SortModifiersFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

