/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RedundantEscapeInRegexReplacementInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        char c = ((Character)infos[0]).charValue();
        String string = InspectionGadgetsBundle.message("redundant.escape.in.regex.replacement.problem.descriptor", Character.valueOf(c));
        if (string == null) {
            RedundantEscapeInRegexReplacementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        boolean buildFix = (Boolean)infos[1];
        if (buildFix) {
            return LocalQuickFix.from((ModCommandAction)new RedundantEscapeInRegexReplacementFix());
        }
        return null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantEscapeInRegexReplacementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/RedundantEscapeInRegexReplacementInspection", "buildErrorString"));
    }

    private static class RedundantEscapeInRegexReplacementFix
    extends PsiUpdateModCommandAction<PsiLiteralExpression> {
        RedundantEscapeInRegexReplacementFix() {
            super(PsiLiteralExpression.class);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiLiteralExpression literal, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                RedundantEscapeInRegexReplacementFix.$$$reportNull$$$0(0);
            }
            if (literal == null) {
                RedundantEscapeInRegexReplacementFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                RedundantEscapeInRegexReplacementFix.$$$reportNull$$$0(2);
            }
            TextRange range = context.selection().shiftLeft(literal.getTextRange().getStartOffset());
            String text = literal.getText();
            int length = text.length();
            int start = range.getStartOffset();
            int end = range.getEndOffset();
            if (start >= length || end >= length || !StringUtil.unescapeStringCharacters((String)text.substring(start, end)).equals("\\")) {
                return;
            }
            String newText = text.substring(0, start) + text.substring(end);
            PsiReplacementUtil.replaceExpression((PsiExpression)literal, newText);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("redundant.escape.in.regex.replacement.quickfix", new Object[0]);
            if (string == null) {
                RedundantEscapeInRegexReplacementFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/RedundantEscapeInRegexReplacementInspection$RedundantEscapeInRegexReplacementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/RedundantEscapeInRegexReplacementInspection$RedundantEscapeInRegexReplacementFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class RedundantEscapeInRegexReplacementVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher REGEX_REPLACEMENT_METHODS = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.String", "replaceAll", "replaceFirst"), CallMatcher.exactInstanceCall("java.util.regex.Matcher", "appendReplacement"), CallMatcher.exactInstanceCall("java.util.regex.Matcher", "replaceAll", "replaceFirst").parameterTypes("java.lang.String"));

        private RedundantEscapeInRegexReplacementVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                RedundantEscapeInRegexReplacementVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!REGEX_REPLACEMENT_METHODS.matches((PsiExpression)expression)) {
                return;
            }
            PsiExpression[] arguments = expression.getArgumentList().getExpressions();
            PsiExpression lastArgument = arguments[arguments.length - 1];
            Object value = ExpressionUtils.computeConstantExpression(lastArgument);
            if (!(value instanceof String)) {
                return;
            }
            String string = (String)value;
            boolean escaped = false;
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    escaped = !escaped;
                    continue;
                }
                if (!escaped) continue;
                escaped = false;
                if (c == '$') continue;
                TextRange range = ExpressionUtils.findStringLiteralRange(lastArgument, i - 1, i);
                if (range != null) {
                    this.registerErrorAtOffset((PsiElement)lastArgument, range.getStartOffset(), range.getLength(), Character.valueOf(c), Boolean.TRUE);
                    continue;
                }
                this.registerError((PsiElement)lastArgument, Character.valueOf(c), Boolean.FALSE);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/RedundantEscapeInRegexReplacementInspection$RedundantEscapeInRegexReplacementVisitor", "visitMethodCallExpression"));
        }
    }
}

