/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SimplifiableAnnotationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.whitespace.problem.descriptor", new Object[0]);
            if (string == null) {
                SimplifiableAnnotationInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        Object object = infos[0];
        if (object instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)object;
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.braces.problem.descriptor", arrayValue.getText());
            if (string == null) {
                SimplifiableAnnotationInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("simplifiable.annotation.problem.descriptor", new Object[0]);
        if (string == null) {
            SimplifiableAnnotationInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SimplifiableAnnotationFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableAnnotationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection", "buildErrorString"));
    }

    private static class SimplifiableAnnotationFix
    extends PsiUpdateModCommandQuickFix {
        SimplifiableAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableAnnotationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiAnnotation annotation;
            if (project == null) {
                SimplifiableAnnotationFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                SimplifiableAnnotationFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                SimplifiableAnnotationFix.$$$reportNull$$$0(3);
            }
            if ((annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class)) == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker tracker = new CommentTracker();
            String annotationText = SimplifiableAnnotationFix.buildAnnotationText(annotation, tracker);
            PsiAnnotation newAnnotation = factory.createAnnotationFromText(annotationText, element);
            tracker.replaceAndRestoreComments((PsiElement)annotation, (PsiElement)newAnnotation);
        }

        private static String buildAnnotationText(PsiAnnotation annotation, CommentTracker tracker) {
            StringBuilder out = new StringBuilder("@");
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            assert (nameReferenceElement != null);
            out.append(tracker.text((PsiElement)nameReferenceElement));
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            if (attributes.length == 0) {
                return out.toString();
            }
            out.append('(');
            if (attributes.length == 1) {
                PsiNameValuePair attribute = attributes[0];
                @NonNls String name = attribute.getName();
                if (name != null && !"value".equals(name)) {
                    out.append(name).append('=');
                }
                SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out, tracker);
            } else {
                for (int i = 0; i < attributes.length; ++i) {
                    PsiNameValuePair attribute = attributes[i];
                    if (i > 0) {
                        out.append(',');
                    }
                    out.append(attribute.getName()).append('=');
                    SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out, tracker);
                }
            }
            out.append(')');
            return out.toString();
        }

        private static void buildAttributeValueText(PsiAnnotationMemberValue value, StringBuilder out, CommentTracker tracker) {
            if (value instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)value;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length == 1) {
                    out.append(tracker.text((PsiElement)initializers[0]));
                    return;
                }
            } else if (value instanceof PsiAnnotation) {
                out.append(SimplifiableAnnotationFix.buildAnnotationText((PsiAnnotation)value, tracker));
                return;
            }
            out.append(tracker.text((PsiElement)value));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SimplifiableAnnotationVisitor
    extends BaseInspectionVisitor {
        private SimplifiableAnnotationVisitor() {
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            PsiNameValuePair[] attributes;
            PsiElement child;
            if (annotation == null) {
                SimplifiableAnnotationVisitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null) {
                return;
            }
            PsiElement[] annotationChildren = annotation.getChildren();
            if (annotationChildren.length >= 2 && annotationChildren[1] instanceof PsiWhiteSpace && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                this.registerError(annotationChildren[1], new Object[0]);
                if (!this.isOnTheFly()) {
                    return;
                }
            }
            if (annotationChildren.length >= 4 && (child = annotationChildren[annotationChildren.length - 2]) instanceof PsiWhiteSpace && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                this.registerError(child, new Object[0]);
                if (!this.isOnTheFly()) {
                    return;
                }
            }
            if ((attributes = parameterList.getAttributes()).length == 0) {
                if (parameterList.getFirstChild() != null && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerError((PsiElement)parameterList, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{parameterList});
                }
            } else if (attributes.length == 1) {
                String name;
                PsiNameValuePair attribute = attributes[0];
                PsiIdentifier identifier = attribute.getNameIdentifier();
                PsiAnnotationMemberValue attributeValue = attribute.getValue();
                if (identifier != null && attributeValue != null && "value".equals(name = attribute.getName()) && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerErrorAtOffset((PsiElement)attribute, 0, attributeValue.getStartOffsetInParent(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{attribute});
                    if (!this.isOnTheFly()) {
                        return;
                    }
                }
                if (!(attributeValue instanceof PsiArrayInitializerMemberValue)) {
                    return;
                }
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)attributeValue;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length != 1) {
                    return;
                }
                if (!SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{arrayValue});
                    if (!this.isOnTheFly()) {
                        return;
                    }
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{arrayValue});
                }
            } else {
                for (PsiNameValuePair attribute : attributes) {
                    PsiArrayInitializerMemberValue arrayValue;
                    PsiAnnotationMemberValue[] initializers;
                    PsiAnnotationMemberValue value = attribute.getValue();
                    if (!(value instanceof PsiArrayInitializerMemberValue) || (initializers = (arrayValue = (PsiArrayInitializerMemberValue)value).getInitializers()).length != 1 || SimplifiableAnnotationVisitor.containsError(annotation)) continue;
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{arrayValue});
                    if (!this.isOnTheFly()) {
                        return;
                    }
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{arrayValue});
                }
            }
        }

        private static boolean containsError(PsiAnnotation annotation) {
            PsiNameValuePair[] attributes;
            PsiClass aClass = annotation.resolveAnnotationType();
            if (aClass == null) {
                return true;
            }
            HashSet<String> names = new HashSet<String>();
            PsiAnnotationParameterList annotationParameterList = annotation.getParameterList();
            if (PsiUtilCore.hasErrorElementChild((PsiElement)annotationParameterList)) {
                return true;
            }
            for (PsiNameValuePair psiNameValuePair : attributes = annotationParameterList.getAttributes()) {
                PsiReference reference = psiNameValuePair.getReference();
                if (reference == null) {
                    return true;
                }
                PsiMethod method = (PsiMethod)reference.resolve();
                if (method == null) {
                    return true;
                }
                PsiAnnotationMemberValue value = psiNameValuePair.getValue();
                if (value == null || PsiUtilCore.hasErrorElementChild((PsiElement)value)) {
                    return true;
                }
                if (value instanceof PsiAnnotation && SimplifiableAnnotationVisitor.containsError((PsiAnnotation)value)) {
                    return true;
                }
                if (!SimplifiableAnnotationVisitor.hasCorrectType(value, method.getReturnType())) {
                    return true;
                }
                String name = psiNameValuePair.getName();
                if (names.add(name != null ? name : "value")) continue;
                return true;
            }
            for (PsiNameValuePair psiNameValuePair : aClass.getMethods()) {
                PsiAnnotationMethod annotationMethod;
                if (!(psiNameValuePair instanceof PsiAnnotationMethod) || (annotationMethod = (PsiAnnotationMethod)psiNameValuePair).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                return true;
            }
            return false;
        }

        private static boolean hasCorrectType(@Nullable PsiAnnotationMemberValue value, PsiType expectedType) {
            if (value == null) {
                return false;
            }
            if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            if (value instanceof PsiAnnotation) {
                PsiClass aClass;
                PsiType componentType;
                PsiClass aClass2;
                PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value).getNameReferenceElement();
                if (nameRef == null) {
                    return true;
                }
                if (expectedType instanceof PsiClassType && (aClass2 = ((PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                    return true;
                }
                return expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass);
            }
            if (value instanceof PsiArrayInitializerMemberValue) {
                return expectedType instanceof PsiArrayType;
            }
            if (value instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)value;
                return expression.getType() != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expression) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expression);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationVisitor", "visitAnnotation"));
        }
    }
}

