/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.style.ControlFlowStatementVisitorBase;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SingleStatementInBlockInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("single.statement.in.block.descriptor", infos);
        if (string == null) {
            SingleStatementInBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SingleStatementInBlockVisitor();
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SingleStatementInBlockFix((String)infos[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SingleStatementInBlockInspection", "buildErrorString"));
    }

    private static class SingleStatementInBlockVisitor
    extends ControlFlowStatementVisitorBase {
        private SingleStatementInBlockVisitor() {
        }

        @Override
        @Contract(value="null->false")
        protected boolean isApplicable(PsiStatement body) {
            if (body instanceof PsiBlockStatement) {
                PsiBlockStatement statement = (PsiBlockStatement)body;
                PsiCodeBlock codeBlock = statement.getCodeBlock();
                if (PsiUtilCore.hasErrorElementChild((PsiElement)codeBlock)) {
                    return false;
                }
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length == 1 && !(statements[0] instanceof PsiDeclarationStatement) && !SingleStatementInBlockVisitor.isDanglingElseProblem(statements[0], body)) {
                    if (PsiUtilCore.hasErrorElementChild((PsiElement)statements[0])) {
                        return false;
                    }
                    if (!FileTypeUtils.isInServerPageFile((PsiElement)body)) {
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        @Nullable
        protected Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement body) {
            PsiBlockStatement block;
            PsiStatement statement;
            if (body instanceof PsiBlockStatement && (statement = (block = (PsiBlockStatement)body).getCodeBlock().getStatements()[0]).textContains('\n')) {
                return new Pair((Object)statement, (Object)statement);
            }
            return null;
        }

        private static boolean isDanglingElseProblem(@Nullable PsiStatement statement, @NotNull PsiStatement outerStatement) {
            if (outerStatement == null) {
                SingleStatementInBlockVisitor.$$$reportNull$$$0(0);
            }
            return SingleStatementInBlockVisitor.hasShortIf(statement) && SingleStatementInBlockVisitor.hasPotentialDanglingElse(outerStatement);
        }

        private static boolean hasShortIf(@Nullable PsiStatement statement) {
            if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                PsiStatement elseBranch = ifStatement.getElseBranch();
                return elseBranch == null || SingleStatementInBlockVisitor.hasShortIf(elseBranch);
            }
            if (statement instanceof PsiLabeledStatement) {
                PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement;
                return SingleStatementInBlockVisitor.hasShortIf(labeledStatement.getStatement());
            }
            if (statement instanceof PsiWhileStatement || statement instanceof PsiForStatement || statement instanceof PsiForeachStatement) {
                return SingleStatementInBlockVisitor.hasShortIf(((PsiLoopStatement)statement).getBody());
            }
            return false;
        }

        private static boolean hasPotentialDanglingElse(@NotNull PsiStatement statement) {
            PsiElement parent;
            if (statement == null) {
                SingleStatementInBlockVisitor.$$$reportNull$$$0(1);
            }
            if ((parent = statement.getParent()) instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                if (ifStatement.getThenBranch() == statement && ifStatement.getElseBranch() != null) {
                    return true;
                }
                return SingleStatementInBlockVisitor.hasPotentialDanglingElse((PsiStatement)ifStatement);
            }
            if (parent instanceof PsiLabeledStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiForeachStatement) {
                return SingleStatementInBlockVisitor.hasPotentialDanglingElse((PsiStatement)parent);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDanglingElseProblem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasPotentialDanglingElse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SingleStatementInBlockFix
    extends PsiUpdateModCommandQuickFix {
        @NonNls
        private final String myKeywordText;

        SingleStatementInBlockFix(String keywordText) {
            this.myKeywordText = keywordText;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.quickfix", this.myKeywordText);
            if (string == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("single.statement.in.block.family.quickfix", new Object[0]);
            if (string == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public @Unmodifiable @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(Project project, ProblemDescriptor descriptor) {
            BlockData info = this.getBlockInfo(descriptor.getStartElement());
            if (info == null) {
                List<CustomizableIntentionAction.RangeToHighlight> list = List.of();
                if (list == null) {
                    SingleStatementInBlockFix.$$$reportNull$$$0(2);
                }
                return list;
            }
            PsiCodeBlock block = info.block().getCodeBlock();
            List list = ContainerUtil.notNullize(Arrays.asList(CustomizableIntentionAction.RangeToHighlight.from((PsiElement)block.getLBrace(), (TextAttributesKey)EditorColors.DELETED_TEXT_ATTRIBUTES), CustomizableIntentionAction.RangeToHighlight.from((PsiElement)block.getRBrace(), (TextAttributesKey)EditorColors.DELETED_TEXT_ATTRIBUTES)));
            if (list == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(3);
            }
            return list;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            BlockData info;
            if (project == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(6);
            }
            if ((info = this.getBlockInfo(startElement)) == null) {
                return;
            }
            PsiStatement[] statements = info.block().getCodeBlock().getStatements();
            if (statements.length != 1) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            String text = commentTracker.text((PsiElement)statements[0]);
            PsiElement replacementExp = commentTracker.replace((PsiElement)info.block(), text);
            CodeStyleManager.getInstance((Project)project).reformat(replacementExp);
            commentTracker.insertCommentsBefore((PsiElement)info.statement());
        }

        @Nullable
        private BlockData getBlockInfo(@NotNull PsiElement startElement) {
            PsiStatement body;
            PsiStatement statement;
            if (startElement == null) {
                SingleStatementInBlockFix.$$$reportNull$$$0(7);
            }
            if ((statement = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiStatement.class})) instanceof PsiBlockStatement) {
                statement = (PsiStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)statement.getParent(), (Class[])new Class[]{PsiStatement.class});
            }
            if (statement instanceof PsiLoopStatement) {
                PsiLoopStatement loopStatement = (PsiLoopStatement)statement;
                body = loopStatement.getBody();
            } else if (statement instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)statement;
                body = this.myKeywordText.equals("else") ? ifStatement.getElseBranch() : ifStatement.getThenBranch();
            } else {
                return null;
            }
            if (!(body instanceof PsiBlockStatement)) {
                return null;
            }
            PsiBlockStatement block = (PsiBlockStatement)body;
            if (SingleStatementInBlockVisitor.isDanglingElseProblem(ControlFlowUtils.stripBraces((PsiStatement)block), (PsiStatement)block)) {
                return null;
            }
            return new BlockData(statement, block);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangesToHighlight";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/SingleStatementInBlockInspection$SingleStatementInBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getBlockInfo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }

        private record BlockData(PsiStatement statement, PsiBlockStatement block) {
        }
    }
}

