/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeParameterExtendsObjectInspection
extends BaseInspection {
    public boolean ignoreAnnotatedObject = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAnnotatedObject", (String)InspectionGadgetsBundle.message("type.parameter.extends.object.ignore.annotated", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            TypeParameterExtendsObjectInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public String getID() {
        return "TypeParameterExplicitlyExtendsObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer type = (Integer)infos[0];
        if (type == 1) {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor1", new Object[0]);
            if (string == null) {
                TypeParameterExtendsObjectInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("type.parameter.extends.object.problem.descriptor2", new Object[0]);
        if (string == null) {
            TypeParameterExtendsObjectInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/TypeParameterExtendsObjectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ExtendsObjectFix
    extends PsiUpdateModCommandQuickFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
            if (string == null) {
                ExtendsObjectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement identifier, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ExtendsObjectFix.$$$reportNull$$$0(1);
            }
            if (identifier == null) {
                ExtendsObjectFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ExtendsObjectFix.$$$reportNull$$$0(3);
            }
            if ((parent = identifier.getParent()) instanceof PsiTypeParameter) {
                PsiJavaCodeReferenceElement[] referenceElements;
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                PsiReferenceList extendsList = typeParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                    referenceElement.delete();
                }
            } else {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement child = typeElement.getLastChild();
                while (child != null) {
                    PsiJavaToken javaToken;
                    IElementType tokenType;
                    if (child instanceof PsiJavaToken && (tokenType = (javaToken = (PsiJavaToken)child).getTokenType()) == JavaTokenType.QUEST) {
                        return;
                    }
                    child.delete();
                    child = typeElement.getLastChild();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitTypeParameter(@NotNull PsiTypeParameter parameter) {
            if (parameter == null) {
                ExtendsObjectVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeParameter(parameter);
            PsiClassType[] extendsListTypes = parameter.getExtendsListTypes();
            if (extendsListTypes.length != 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            if (!extendsType.equalsToText("java.lang.Object")) {
                return;
            }
            if (TypeParameterExtendsObjectInspection.this.ignoreAnnotatedObject && extendsType.hasAnnotations()) {
                return;
            }
            PsiIdentifier nameIdentifier = parameter.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            this.registerError((PsiElement)nameIdentifier, 1);
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            if (typeElement == null) {
                ExtendsObjectVisitor.$$$reportNull$$$0(1);
            }
            super.visitTypeElement(typeElement);
            PsiElement lastChild = typeElement.getLastChild();
            if (!(lastChild instanceof PsiTypeElement)) {
                return;
            }
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            if (!wildcardType.isExtends()) {
                return;
            }
            PsiTypeElement extendsBound = (PsiTypeElement)typeElement.getLastChild();
            if (TypeParameterExtendsObjectInspection.this.ignoreAnnotatedObject && extendsBound.hasAnnotations() || !TypeUtils.isJavaLangObject(extendsBound.getType())) {
                return;
            }
            if (TypeParameterExtendsObjectInspection.this.ignoreAnnotatedObject && ExtendsObjectVisitor.hasTypeContainerAnnotations(typeElement)) {
                return;
            }
            PsiElement firstChild = typeElement.getFirstChild();
            if (firstChild == null) {
                return;
            }
            this.registerError(firstChild, 2);
        }

        private static boolean hasTypeContainerAnnotations(@Nullable PsiTypeElement typeElement) {
            NullabilityAnnotationInfo nullability;
            if (typeElement == null) {
                return false;
            }
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)typeElement.getProject());
            return manager != null && (nullability = manager.findDefaultTypeUseNullability((PsiElement)typeElement)) != null && nullability.getNullability() != Nullability.UNKNOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/TypeParameterExtendsObjectInspection$ExtendsObjectVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

