/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessarilyQualifiedInnerClassAccessInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreReferencesNeedingImport = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.problem.descriptor", aClass.getName());
        if (string == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreReferencesNeedingImport", (String)InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedInnerClassAccessFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedInnerClassAccessVisitor();
    }

    private static boolean isReferenceToTarget(String referenceText, @NotNull PsiClass target, PsiElement context) {
        PsiJavaCodeReferenceElement reference;
        JavaResolveResult[] results;
        if (target == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(2);
        }
        if ((results = (reference = JavaPsiFacade.getElementFactory((Project)target.getProject()).createReferenceFromText(referenceText, context)).multiResolve(false)).length == 0) {
            return true;
        }
        if (results.length > 1) {
            return false;
        }
        JavaResolveResult result = results[0];
        return result.isAccessible() && target.isEquivalentTo(result.getElement());
    }

    private static boolean canBeImported(@NotNull PsiClass aClass) {
        if (aClass == null) {
            UnnecessarilyQualifiedInnerClassAccessInspection.$$$reportNull$$$0(3);
        }
        while (!aClass.hasModifierProperty("private")) {
            PsiElement parent = aClass.getParent();
            if (parent == null || parent instanceof PsiDeclarationStatement) {
                return false;
            }
            if (parent instanceof PsiJavaFile) {
                return true;
            }
            if (!(parent instanceof PsiClass)) {
                return false;
            }
            aClass = (PsiClass)parent;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToTarget";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeImported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class UnnecessarilyQualifiedInnerClassAccessFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessarilyQualifiedInnerClassAccessFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.inner.class.access.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedInnerClassAccessFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnnecessarilyQualifiedInnerClassAccessFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessarilyQualifiedInnerClassAccessFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarilyQualifiedInnerClassAccessFix.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)parent;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            ImportUtils.addImportIfNeeded(aClass, element);
            String shortName = aClass.getName();
            if (UnnecessarilyQualifiedInnerClassAccessInspection.isReferenceToTarget(shortName, aClass, parent)) {
                new CommentTracker().deleteAndRestoreComments(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection$UnnecessarilyQualifiedInnerClassAccessFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection$UnnecessarilyQualifiedInnerClassAccessFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessarilyQualifiedInnerClassAccessVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedInnerClassAccessVisitor() {
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiClass containingClass;
            boolean needsImport;
            PsiClass aClass;
            if (reference == null) {
                UnnecessarilyQualifiedInnerClassAccessVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
            if (PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class}) != null) {
                return;
            }
            PsiReferenceParameterList parameterList = referenceElement.getParameterList();
            if (parameterList != null && parameterList.getTypeParameterElements().length > 0) {
                return;
            }
            PsiElement qualifierTarget = referenceElement.resolve();
            if (!(qualifierTarget instanceof PsiClass)) {
                return;
            }
            PsiClass referenceClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)reference, PsiClass.class);
            if (referenceClass == null) {
                return;
            }
            PsiElement target = reference.resolve();
            if (!(target instanceof PsiClass) || !PsiUtil.isAccessible((PsiMember)(aClass = (PsiClass)target), (PsiElement)referenceClass, null)) {
                return;
            }
            ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            boolean bl = needsImport = !(referenceClass.equals((Object)qualifierTarget) && ClassUtils.isInsideClassBody((PsiElement)reference, referenceClass) || !PsiTreeUtil.isAncestor((PsiElement)referenceClass, (PsiElement)qualifierTarget, (boolean)true) && PsiTreeUtil.isAncestor((PsiElement)qualifierTarget, (PsiElement)referenceClass, (boolean)true));
            if (needsImport) {
                if (UnnecessarilyQualifiedInnerClassAccessInspection.this.ignoreReferencesNeedingImport) {
                    if (!this.isOnTheFly()) {
                        return;
                    }
                    highlightType = ProblemHighlightType.INFORMATION;
                }
                if (!UnnecessarilyQualifiedInnerClassAccessInspection.canBeImported(aClass)) {
                    return;
                }
            }
            if ((containingClass = aClass.getContainingClass()) == null || !containingClass.equals((Object)qualifierTarget)) {
                return;
            }
            String shortName = aClass.getName();
            if (!UnnecessarilyQualifiedInnerClassAccessInspection.isReferenceToTarget(shortName, aClass, (PsiElement)reference)) {
                return;
            }
            this.registerError(qualifier, highlightType, new Object[]{aClass});
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UnnecessarilyQualifiedInnerClassAccessVisitor.$$$reportNull$$$0(1);
            }
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedInnerClassAccessInspection$UnnecessarilyQualifiedInnerClassAccessVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

