/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessarilyQualifiedStaticUsageInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean m_ignoreStaticFieldAccesses = false;
    public boolean m_ignoreStaticMethodCalls = false;
    public boolean m_ignoreStaticAccessFromStaticContext = false;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor", element.getText());
            if (string == null) {
                UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.problem.descriptor1", element.getText());
        if (string == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_ignoreStaticFieldAccesses", (String)InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.field.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreStaticMethodCalls", (String)InspectionGadgetsBundle.message("unnecessarily.qualified.static.usage.ignore.method.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreStaticAccessFromStaticContext", (String)InspectionGadgetsBundle.message("only.report.qualified.static.usages.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticUsageFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticUsageVisitor();
    }

    public static boolean isUnnecessarilyQualifiedAccess(@NotNull PsiJavaCodeReferenceElement referenceElement, boolean ignoreStaticAccessFromStaticContext, boolean ignoreStaticFieldAccesses, boolean ignoreStaticMethodCalls) {
        PsiMember containingMember;
        if (referenceElement == null) {
            UnnecessarilyQualifiedStaticUsageInspection.$$$reportNull$$$0(3);
        }
        if (referenceElement instanceof PsiMethodReferenceExpression) {
            return false;
        }
        PsiElement parent = referenceElement.getParent();
        if (parent instanceof PsiImportStatementBase) {
            return false;
        }
        PsiElement qualifierElement = referenceElement.getQualifier();
        if (!(qualifierElement instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiJavaCodeReferenceElement qualifier = (PsiJavaCodeReferenceElement)qualifierElement;
        if (GenericsUtil.isGenericReference((PsiJavaCodeReferenceElement)referenceElement, (PsiJavaCodeReferenceElement)qualifier)) {
            return false;
        }
        String referenceName = referenceElement.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        if (referenceName.equals("yield") && parent instanceof PsiMethodCallExpression) {
            return false;
        }
        PsiElement target = referenceElement.resolve();
        if (!(target instanceof PsiField && !ignoreStaticFieldAccesses || target instanceof PsiMethod && !ignoreStaticMethodCalls)) {
            return false;
        }
        if (ignoreStaticAccessFromStaticContext && (containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiMember.class)) != null && !containingMember.hasModifierProperty("static")) {
            return false;
        }
        PsiElement resolvedQualifier = qualifier.resolve();
        if (!(resolvedQualifier instanceof PsiClass)) {
            return false;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiClass.class);
        if (containingClass == null) {
            return false;
        }
        PsiMember member = (PsiMember)target;
        if (!ImportUtils.isReferenceCorrectWithoutQualifier(referenceElement, member)) {
            return false;
        }
        PsiClass memberClass = member.getContainingClass();
        if (member instanceof PsiMethod && memberClass != null && memberClass.isInterface() && !PsiTreeUtil.isAncestor((PsiElement)memberClass, (PsiElement)referenceElement, (boolean)true)) {
            return false;
        }
        if (target instanceof PsiField && containingClass == memberClass) {
            TextRange referenceElementTextRange = referenceElement.getTextRange();
            if (referenceElementTextRange == null) {
                return false;
            }
            TextRange variableTextRange = member.getTextRange();
            if (variableTextRange == null) {
                return false;
            }
            if (referenceElementTextRange.getStartOffset() < variableTextRange.getEndOffset()) {
                return false;
            }
        }
        return !ImportUtils.isStaticallyImported(member, (PsiElement)referenceElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnnecessarilyQualifiedAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class UnnecessarilyQualifiedStaticUsageFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessarilyQualifiedStaticUsageFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.qualifier.for.this.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedStaticUsageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessarilyQualifiedStaticUsageFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                UnnecessarilyQualifiedStaticUsageFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarilyQualifiedStaticUsageFix.$$$reportNull$$$0(3);
            }
            startElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessarilyQualifiedStaticUsageVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticUsageVisitor() {
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                UnnecessarilyQualifiedStaticUsageVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceElement(reference);
            PsiElement qualifier = reference.getQualifier();
            if (qualifier == null) {
                return;
            }
            if (!UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess(reference, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticAccessFromStaticContext, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticFieldAccesses, UnnecessarilyQualifiedStaticUsageInspection.this.m_ignoreStaticMethodCalls)) {
                return;
            }
            this.registerError(qualifier, reference);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UnnecessarilyQualifiedStaticUsageVisitor.$$$reportNull$$$0(1);
            }
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticUsageInspection$UnnecessarilyQualifiedStaticUsageVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

