/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class UnnecessarilyQualifiedStaticallyImportedElementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiMember member = (PsiMember)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.problem.descriptor", member.getName());
        if (string == null) {
            UnnecessarilyQualifiedStaticallyImportedElementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarilyQualifiedStaticallyImportedElementFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarilyQualifiedStaticallyImportedElementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection", "buildErrorString"));
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessarilyQualifiedStaticallyImportedElementFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessarily.qualified.statically.imported.element.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarilyQualifiedStaticallyImportedElementFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessarilyQualifiedStaticallyImportedElementFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessarilyQualifiedStaticallyImportedElementFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarilyQualifiedStaticallyImportedElementFix.$$$reportNull$$$0(3);
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection$UnnecessarilyQualifiedStaticallyImportedElementFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection$UnnecessarilyQualifiedStaticallyImportedElementFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessarilyQualifiedStaticallyImportedElementVisitor
    extends BaseInspectionVisitor {
        private UnnecessarilyQualifiedStaticallyImportedElementVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                UnnecessarilyQualifiedStaticallyImportedElementVisitor.$$$reportNull$$$0(0);
            }
            this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                UnnecessarilyQualifiedStaticallyImportedElementVisitor.$$$reportNull$$$0(1);
            }
            super.visitReferenceElement(reference);
            if ("yield".equals(reference.getReferenceName()) && reference.getParent() instanceof PsiMethodCallExpression) {
                return;
            }
            if (ImportUtils.isAlreadyStaticallyImported(reference)) {
                this.registerError(Objects.requireNonNull(reference.getQualifier()), reference.resolve());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessarilyQualifiedStaticallyImportedElementInspection$UnnecessarilyQualifiedStaticallyImportedElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

