/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryBlockStatementInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreSwitchBranches = false;

    @NotNull
    public String getID() {
        return "UnnecessaryCodeBlock";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.block.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryBlockStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreSwitchBranches", (String)InspectionGadgetsBundle.message("ignore.branches.of.switch.statements", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryBlockStatementInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBlockStatementVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryBlockFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryBlockStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryBlockStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBlockStatementVisitor() {
        }

        public void visitBlockStatement(@NotNull PsiBlockStatement blockStatement) {
            PsiElement prevStatement;
            if (blockStatement == null) {
                UnnecessaryBlockStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitBlockStatement(blockStatement);
            if (UnnecessaryBlockStatementInspection.this.ignoreSwitchBranches && (prevStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)blockStatement)) instanceof PsiSwitchLabelStatement) {
                return;
            }
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock parentBlock = (PsiCodeBlock)parent;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiJavaToken brace = codeBlock.getLBrace();
            if (brace == null) {
                return;
            }
            if (parentBlock.getStatementCount() > 1 && BlockUtils.containsConflictingDeclarations((PsiCodeBlock)codeBlock, (PsiCodeBlock)parentBlock)) {
                return;
            }
            this.registerError((PsiElement)brace, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blockStatement", "com/siyeh/ig/style/UnnecessaryBlockStatementInspection$UnnecessaryBlockStatementVisitor", "visitBlockStatement"));
        }
    }

    private static class UnnecessaryBlockFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.code.block.unwrap.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryBlockFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement leftBrace, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnnecessaryBlockFix.$$$reportNull$$$0(1);
            }
            if (leftBrace == null) {
                UnnecessaryBlockFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryBlockFix.$$$reportNull$$$0(3);
            }
            if (!((parent = leftBrace.getParent()) instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)parent;
            PsiElement firstBodyElement = block.getFirstBodyElement();
            PsiElement lastBodyElement = block.getLastBodyElement();
            PsiBlockStatement blockStatement = (PsiBlockStatement)block.getParent();
            if (firstBodyElement != null && lastBodyElement != null) {
                PsiElement element = blockStatement.getParent();
                element.addRangeBefore(firstBodyElement, lastBodyElement, (PsiElement)blockStatement);
            }
            blockStatement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryBlockStatementInspection$UnnecessaryBlockFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftBrace";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryBlockStatementInspection$UnnecessaryBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

