/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryConstantArrayCreationExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryConstantArrayCreationExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        if (infos.length != 0 && infos[0] instanceof String) {
            return new UnnecessaryConstantArrayCreationExpressionFix((String)infos[0]);
        }
        return null;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstantArrayCreationExpressionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection", "buildErrorString"));
    }

    private static final class UnnecessaryConstantArrayCreationExpressionFix
    extends PsiUpdateModCommandQuickFix {
        private final String myType;

        private UnnecessaryConstantArrayCreationExpressionFix(String type) {
            this.myType = type;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constant.array.creation.expression.family.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.remove", (Object[])new Object[]{"new " + this.myType});
            if (string == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryConstantArrayCreationExpressionFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)element;
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return;
            }
            PsiNewExpression target = newExpression;
            while (target.getParent() instanceof PsiParenthesizedExpression) {
                target = (PsiExpression)target.getParent();
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)target, (PsiElement)arrayInitializer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection$UnnecessaryConstantArrayCreationExpressionFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection$UnnecessaryConstantArrayCreationExpressionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessaryConstantArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstantArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
            if (expression == null) {
                UnnecessaryConstantArrayCreationExpressionVisitor.$$$reportNull$$$0(0);
            }
            super.visitArrayInitializerExpression(expression);
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                return;
            }
            PsiElement grandParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            if (!(grandParent instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)grandParent;
            PsiType expressionType = expression.getType();
            if (!variable.getType().equals(expressionType)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement != null && typeElement.isInferredType()) {
                return;
            }
            if (UnnecessaryConstantArrayCreationExpressionVisitor.hasGenericTypeParameters(variable)) {
                return;
            }
            this.registerErrorAtOffset(parent, 0, expression.getStartOffsetInParent(), expressionType.getPresentableText());
        }

        private static boolean hasGenericTypeParameters(PsiVariable variable) {
            PsiType[] parameterTypes;
            PsiType type = variable.getType();
            PsiType componentType = type.getDeepComponentType();
            if (!(componentType instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)componentType;
            for (PsiType parameterType : parameterTypes = classType.getParameters()) {
                if (parameterType == null) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnnecessaryConstantArrayCreationExpressionInspection$UnnecessaryConstantArrayCreationExpressionVisitor", "visitArrayInitializerExpression"));
        }
    }
}

