/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.util.VisibilityUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryConstructorInspection
extends BaseInspection {
    public boolean ignoreAnnotations = false;

    @NotNull
    public String getID() {
        return "RedundantNoArgConstructor";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreAnnotations", (String)InspectionGadgetsBundle.message("unnecessary.constructor.annotation.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryConstructorInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.constructor.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryConstructorInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryConstructorVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryConstructorFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryConstructorInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryConstructorVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryConstructorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiModifierList modifierList;
            PsiAnnotation[] annotations;
            String modifier;
            PsiMethod[] constructors;
            if (aClass == null) {
                UnnecessaryConstructorVisitor.$$$reportNull$$$0(0);
            }
            if ((constructors = aClass.getConstructors()).length != 1) {
                return;
            }
            PsiMethod constructor = constructors[0];
            PsiIdentifier identifier = constructor.getNameIdentifier();
            if (!constructor.isPhysical() || identifier == null) {
                return;
            }
            if (!aClass.isEnum() && !constructor.hasModifierProperty(modifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()))) {
                return;
            }
            PsiParameterList parameterList = constructor.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            if (UnnecessaryConstructorInspection.this.ignoreAnnotations && (annotations = (modifierList = constructor.getModifierList()).getAnnotations()).length > 0) {
                return;
            }
            PsiReferenceList throwsList = constructor.getThrowsList();
            PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
            if (elements.length != 0) {
                return;
            }
            PsiCodeBlock body = constructor.getBody();
            if (ControlFlowUtils.isEmptyCodeBlock(body) || UnnecessaryConstructorVisitor.isSuperConstructorInvocationWithoutArguments(ControlFlowUtils.getOnlyStatementInBlock(body))) {
                this.registerError((PsiElement)identifier, new Object[0]);
            }
        }

        private static boolean isSuperConstructorInvocationWithoutArguments(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            return "super".equals(methodExpression.getReferenceName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorVisitor", "visitClass"));
        }
    }

    private static class UnnecessaryConstructorFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryConstructorFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.constructor.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryConstructorFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement nameIdentifier, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryConstructorFix.$$$reportNull$$$0(1);
            }
            if (nameIdentifier == null) {
                UnnecessaryConstructorFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryConstructorFix.$$$reportNull$$$0(3);
            }
            PsiElement constructor = nameIdentifier.getParent();
            assert (constructor != null);
            constructor.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryConstructorInspection$UnnecessaryConstructorFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

