/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class UnnecessaryModifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = (String)infos[0];
        if (string == null) {
            UnnecessaryModifierInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix((String)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryModifierVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryModifierInspection", "buildErrorString"));
    }

    private static class UnnecessaryModifierVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryModifierVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            boolean redundantStrictfp;
            PsiElement parent;
            if (aClass == null) {
                UnnecessaryModifierVisitor.$$$reportNull$$$0(0);
            }
            boolean interfaceMember = (parent = aClass.getParent()) instanceof PsiClass && ((PsiClass)parent).isInterface();
            boolean bl = redundantStrictfp = PsiUtil.isAvailable((JavaFeature)JavaFeature.ALWAYS_STRICTFP, (PsiElement)aClass) && aClass.hasModifierProperty("strictfp");
            if (aClass.isRecord() || aClass.isInterface() || aClass.isEnum() || interfaceMember || redundantStrictfp) {
                PsiModifierList modifierList = aClass.getModifierList();
                if (modifierList == null) {
                    return;
                }
                List modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                for (PsiKeyword modifier : modifiers) {
                    IElementType tokenType = modifier.getTokenType();
                    if (JavaTokenType.FINAL_KEYWORD == tokenType) {
                        if (!aClass.isRecord()) continue;
                        this.registerError(modifier, "unnecessary.record.modifier.problem.descriptor");
                        continue;
                    }
                    if (JavaTokenType.ABSTRACT_KEYWORD == tokenType) {
                        if (!aClass.isInterface()) continue;
                        this.registerError(modifier, "unnecessary.interface.modifier.problem.descriptor");
                        continue;
                    }
                    if (JavaTokenType.STATIC_KEYWORD == tokenType) {
                        if (!(parent instanceof PsiClass)) continue;
                        if (aClass.isRecord()) {
                            this.registerError(modifier, "unnecessary.inner.record.modifier.problem.descriptor");
                            continue;
                        }
                        if (aClass.isInterface()) {
                            this.registerError(modifier, "unnecessary.inner.interface.modifier.problem.descriptor");
                            continue;
                        }
                        if (aClass.isEnum()) {
                            this.registerError(modifier, "unnecessary.inner.enum.modifier.problem.descriptor");
                            continue;
                        }
                        if (!interfaceMember) continue;
                        this.registerError(modifier, "unnecessary.interface.inner.class.modifier.problem.descriptor");
                        continue;
                    }
                    if (JavaTokenType.PUBLIC_KEYWORD == tokenType) {
                        if (!interfaceMember) continue;
                        this.registerError(modifier, "unnecessary.interface.member.modifier.problem.descriptor");
                        continue;
                    }
                    if (JavaTokenType.STRICTFP_KEYWORD != tokenType || !redundantStrictfp) continue;
                    this.registerError(modifier, "unnecessary.strictfp.modifier.problem.descriptor");
                }
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass containingClass;
            boolean redundantStrictfp;
            if (method == null) {
                UnnecessaryModifierVisitor.$$$reportNull$$$0(1);
            }
            boolean bl = redundantStrictfp = PsiUtil.isAvailable((JavaFeature)JavaFeature.ALWAYS_STRICTFP, (PsiElement)method) && method.hasModifierProperty("strictfp");
            if (redundantStrictfp) {
                PsiModifierList modifierList = method.getModifierList();
                List modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                for (PsiKeyword modifier : modifiers) {
                    if (JavaTokenType.STRICTFP_KEYWORD != modifier.getTokenType()) continue;
                    this.registerError(modifier, "unnecessary.strictfp.modifier.problem.descriptor");
                }
            }
            if ((containingClass = method.getContainingClass()) == null) {
                return;
            }
            if (containingClass.isEnum()) {
                if (!method.isConstructor() || !method.hasModifierProperty("private")) {
                    return;
                }
                modifierList = method.getModifierList();
                modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                for (PsiKeyword modifier : modifiers) {
                    if (JavaTokenType.PRIVATE_KEYWORD != modifier.getTokenType()) continue;
                    this.registerError(modifier, "unnecessary.enum.constructor.modifier.problem.descriptor");
                }
            } else if (containingClass.isInterface()) {
                modifierList = method.getModifierList();
                modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                for (PsiKeyword modifier : modifiers) {
                    IElementType tokenType = modifier.getTokenType();
                    if (JavaTokenType.PUBLIC_KEYWORD == tokenType) {
                        this.registerError(modifier, "unnecessary.interface.member.modifier.problem.descriptor");
                        continue;
                    }
                    if (JavaTokenType.ABSTRACT_KEYWORD != tokenType) continue;
                    this.registerError(modifier, "unnecessary.interface.method.modifier.problem.descriptor");
                }
            }
            this.processMainMethod(method);
        }

        private void processMainMethod(@NotNull PsiMethod method) {
            if (method == null) {
                UnnecessaryModifierVisitor.$$$reportNull$$$0(2);
            }
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.IMPLICIT_CLASSES, (PsiElement)method) && "main".equals(method.getName()) && PsiMethodUtil.isMainMethod((PsiMethod)method)) {
                boolean isImplicitClass = method.getParent() instanceof PsiImplicitClass;
                PsiModifierList modifierList = method.getModifierList();
                List modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)method);
                for (PsiKeyword modifier : modifiers) {
                    PsiReference first;
                    if (modifier.getTokenType() == JavaTokenType.STATIC_KEYWORD && isImplicitClass) {
                        this.registerError((PsiElement)modifier, InspectionGadgetsBundle.message("unnecessary.main.modifier.problem.descriptor", level.getShortText()), modifier.getText());
                        continue;
                    }
                    if (modifier.getTokenType() != JavaTokenType.PUBLIC_KEYWORD && modifier.getTokenType() != JavaTokenType.PROTECTED_KEYWORD) continue;
                    if (isImplicitClass) {
                        this.registerError((PsiElement)modifier, InspectionGadgetsBundle.message("unnecessary.main.modifier.problem.descriptor", level.getShortText()), modifier.getText());
                        continue;
                    }
                    if (this.isOnTheFly()) {
                        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)method.getProject());
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass == null || containingClass.getName() == null) {
                            return;
                        }
                        SearchScope searchScope = containingClass.getUseScope();
                        if (searchScope instanceof GlobalSearchScope) {
                            GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
                            PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(containingClass.getName(), globalSearchScope, null);
                            if (cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                                this.registerPossibleProblem((PsiElement)modifier);
                                continue;
                            }
                        }
                    }
                    if ((first = (PsiReference)ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope()).findFirst()) != null) continue;
                    this.registerError((PsiElement)modifier, InspectionGadgetsBundle.message("unnecessary.main.modifier.problem.descriptor", level.getShortText()), modifier.getText());
                }
            }
        }

        public void visitField(@NotNull PsiField field) {
            block6: {
                block5: {
                    PsiClass containingClass;
                    if (field == null) {
                        UnnecessaryModifierVisitor.$$$reportNull$$$0(3);
                    }
                    if ((containingClass = field.getContainingClass()) == null) {
                        return;
                    }
                    if (!containingClass.isInterface()) break block5;
                    PsiModifierList modifierList = field.getModifierList();
                    List modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                    for (PsiKeyword modifier : modifiers) {
                        IElementType tokenType = modifier.getTokenType();
                        if (JavaTokenType.PUBLIC_KEYWORD == tokenType) {
                            this.registerError(modifier, "unnecessary.interface.member.modifier.problem.descriptor");
                            continue;
                        }
                        if (JavaTokenType.STATIC_KEYWORD != tokenType && JavaTokenType.FINAL_KEYWORD != tokenType) continue;
                        this.registerError(modifier, "unnecessary.interface.field.modifier.problem.descriptor");
                    }
                    break block6;
                }
                if (!field.hasModifierProperty("static") || !field.hasModifierProperty("transient")) break block6;
                PsiModifierList modifierList = field.getModifierList();
                List modifiers = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)modifierList, PsiKeyword.class);
                for (PsiKeyword modifier : modifiers) {
                    if (JavaTokenType.TRANSIENT_KEYWORD != modifier.getTokenType()) continue;
                    this.registerError(modifier, "unnecessary.transient.modifier.problem.descriptor");
                }
            }
        }

        private void registerError(@NotNull PsiKeyword modifier, @NotNull @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle") @NotNull @PropertyKey(resourceBundle="messages.InspectionGadgetsBundle") String key) {
            if (modifier == null) {
                UnnecessaryModifierVisitor.$$$reportNull$$$0(4);
            }
            if (key == null) {
                UnnecessaryModifierVisitor.$$$reportNull$$$0(5);
            }
            this.registerError((PsiElement)modifier, InspectionGadgetsBundle.message(key, new Object[0]), modifier.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifier";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessaryModifierInspection$UnnecessaryModifierVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMainMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

