/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryParenthesesInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreClarifyingParentheses = false;
    public boolean ignoreParenthesesOnConditionals = false;
    public boolean ignoreParenthesesOnLambdaParameter = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.parentheses.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreClarifyingParentheses", (String)InspectionGadgetsBundle.message("unnecessary.parentheses.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreParenthesesOnConditionals", (String)InspectionGadgetsBundle.message("unnecessary.parentheses.conditional.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreParenthesesOnLambdaParameter", (String)InspectionGadgetsBundle.message("ignore.parentheses.around.single.no.formal.type.lambda.parameter", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryParenthesesInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryParenthesesVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryParenthesesFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryParenthesesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryParenthesesVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryParenthesesVisitor() {
        }

        public void visitParameterList(@NotNull PsiParameterList list) {
            PsiParameter parameter;
            if (list == null) {
                UnnecessaryParenthesesVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameterList(list);
            if (!UnnecessaryParenthesesInspection.this.ignoreParenthesesOnLambdaParameter && list.getParent() instanceof PsiLambdaExpression && list.getParametersCount() == 1 && (parameter = Objects.requireNonNull(list.getParameter(0))).getTypeElement() == null && list.getFirstChild() != parameter && list.getLastChild() != parameter) {
                this.registerError((PsiElement)list, new Object[0]);
            }
        }

        public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression) {
            PsiConditionalExpression conditionalExpression;
            PsiExpression condition;
            PsiElement parent;
            if (expression == null) {
                UnnecessaryParenthesesVisitor.$$$reportNull$$$0(1);
            }
            if ((parent = expression.getParent()) instanceof PsiParenthesizedExpression) {
                return;
            }
            if (UnnecessaryParenthesesInspection.this.ignoreParenthesesOnConditionals && parent instanceof PsiConditionalExpression && expression == (condition = (conditionalExpression = (PsiConditionalExpression)parent).getCondition())) {
                return;
            }
            if (!(ParenthesesUtils.areParenthesesNeeded(expression, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses) || ErrorUtil.containsError((PsiElement)expression) || ErrorUtil.containsError((PsiElement)expression.getExpression()))) {
                this.registerError((PsiElement)expression, new Object[0]);
                return;
            }
            super.visitParenthesizedExpression(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameterList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UnnecessaryParenthesesFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessaryParenthesesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.parentheses.remove.quickfix", new Object[0]);
            if (string == null) {
                UnnecessaryParenthesesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessaryParenthesesFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryParenthesesFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryParenthesesFix.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiParameterList) {
                PsiParameterList parameterList = (PsiParameterList)element;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
                String text = Objects.requireNonNull(parameterList.getParameter(0)).getName() + "->{}";
                PsiLambdaExpression expression = (PsiLambdaExpression)factory.createExpressionFromText(text, element);
                element.replace((PsiElement)expression.getParameterList());
            } else {
                ParenthesesUtils.removeParentheses((PsiCaseLabelElement)element, UnnecessaryParenthesesInspection.this.ignoreClarifyingParentheses);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessaryParenthesesInspection$UnnecessaryParenthesesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

