/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaskedAssertionInspection
extends BaseInspection {
    @Override
    @NotNull
    @InspectionMessage
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("masked.assertion.problem.description", infos[0]);
        if (string == null) {
            MaskedAssertionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MaskedAssertionInspectionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/testFrameworks/MaskedAssertionInspection", "buildErrorString"));
    }

    private static class MaskedAssertionInspectionVisitor
    extends BaseInspectionVisitor {
        private MaskedAssertionInspectionVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                MaskedAssertionInspectionVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            PsiElement lastPsiElement = MaskedAssertionInspectionVisitor.getLastPsiElementInsideTryBlock(statement);
            if (lastPsiElement instanceof PsiAssertStatement) {
                this.registerError(lastPsiElement, "assert");
            } else if (lastPsiElement instanceof PsiExpressionStatement) {
                PsiMethodCallExpression currQualifierCall;
                PsiMethodCallExpression psiMethodCallExpr;
                PsiExpression psiExpr = ((PsiExpressionStatement)lastPsiElement).getExpression();
                if (psiExpr instanceof PsiMethodCallExpression) {
                    psiMethodCallExpr = (PsiMethodCallExpression)psiExpr;
                } else {
                    return;
                }
                while ((currQualifierCall = MethodCallUtils.getQualifierMethodCall(psiMethodCallExpr)) != null) {
                    psiMethodCallExpr = currQualifierCall;
                }
                String methodRefName = psiMethodCallExpr.getMethodExpression().getReferenceName();
                if (methodRefName == null) {
                    return;
                }
                if (methodRefName.equals("fail") || methodRefName.startsWith("assert")) {
                    this.registerError((PsiElement)psiExpr, methodRefName + "()");
                }
            }
        }

        @Nullable
        private static PsiElement getLastPsiElementInsideTryBlock(@NotNull PsiTryStatement tryStatement) {
            PsiCodeBlock tryBlock;
            if (tryStatement == null) {
                MaskedAssertionInspectionVisitor.$$$reportNull$$$0(1);
            }
            if ((tryBlock = tryStatement.getTryBlock()) == null) {
                return null;
            }
            PsiCatchSection[] catchSections = tryStatement.getCatchSections();
            if (catchSections.length == 0) {
                return null;
            }
            if (MaskedAssertionInspectionVisitor.containsEmptyCatchBlockWithAssertionError(catchSections)) {
                PsiElement lastPsiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)tryBlock.getLastBodyElement());
                if (lastPsiElement instanceof PsiAssertStatement) {
                    return lastPsiElement;
                }
                return MaskedAssertionInspectionVisitor.containsOnlyEmptyCatchBlocksWithAssertionErrorInheritors(catchSections) ? lastPsiElement : null;
            }
            return null;
        }

        private static boolean containsEmptyCatchBlockWithAssertionError(PsiCatchSection @NotNull [] catchSections) {
            if (catchSections == null) {
                MaskedAssertionInspectionVisitor.$$$reportNull$$$0(2);
            }
            for (String exceptionQn : Arrays.asList("java.lang.AssertionError", "java.lang.Error", "java.lang.Throwable")) {
                for (PsiCatchSection section : catchSections) {
                    List catchExceptionPsiTypes;
                    PsiType catchType = section.getCatchType();
                    if (catchType == null || !ContainerUtil.exists((Iterable)(catchExceptionPsiTypes = catchType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)catchType).getDisjunctions() : Collections.singletonList(catchType)), cet -> cet.equalsToText(exceptionQn))) continue;
                    return ControlFlowUtils.isEmptyCodeBlock(section.getCatchBlock());
                }
            }
            return false;
        }

        private static boolean containsOnlyEmptyCatchBlocksWithAssertionErrorInheritors(PsiCatchSection @NotNull [] catchSections) {
            if (catchSections == null) {
                MaskedAssertionInspectionVisitor.$$$reportNull$$$0(3);
            }
            PsiClassType assertionErrorType = PsiType.getTypeByName((String)"java.lang.AssertionError", (Project)catchSections[0].getProject(), (GlobalSearchScope)catchSections[0].getResolveScope());
            for (PsiCatchSection section : catchSections) {
                boolean isAssertionErrorInheritor;
                PsiType catchType = section.getCatchType();
                boolean bl = isAssertionErrorInheritor = catchType != null && !catchType.equalsToText("java.lang.AssertionError") && assertionErrorType.isAssignableFrom(catchType);
                if (!isAssertionErrorInheritor || ControlFlowUtils.isEmptyCodeBlock(section.getCatchBlock())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tryStatement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "catchSections";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/testFrameworks/MaskedAssertionInspection$MaskedAssertionInspectionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLastPsiElementInsideTryBlock";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsEmptyCatchBlockWithAssertionError";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsOnlyEmptyCatchBlocksWithAssertionErrorInheritors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

