/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import org.jetbrains.annotations.NotNull;

public final class AtomicFieldUpdaterNotStaticFinalInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        PsiType type = field.getType();
        String typeText = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("atomic.field.updater.not.static.final.problem.descriptor", typeText);
        if (string == null) {
            AtomicFieldUpdaterNotStaticFinalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return MakeFieldStaticFinalFix.buildFix((PsiField)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AtomicFieldUpdaterNotStaticFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/AtomicFieldUpdaterNotStaticFinalInspection", "buildErrorString"));
    }

    private static class AtomicFieldUpdaterNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private AtomicFieldUpdaterNotStaticFinalVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                AtomicFieldUpdaterNotStaticFinalVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            PsiType type = field.getType();
            if (!(InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.concurrent.atomic.AtomicIntegerFieldUpdater") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.concurrent.atomic.AtomicLongFieldUpdater") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.concurrent.atomic.AtomicReferenceFieldUpdater"))) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/threading/AtomicFieldUpdaterNotStaticFinalInspection$AtomicFieldUpdaterNotStaticFinalVisitor", "visitField"));
        }
    }
}

