/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public final class BusyWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("busy.wait.problem.descriptor", new Object[0]);
        if (string == null) {
            BusyWaitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BusyWaitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/BusyWaitInspection", "buildErrorString"));
    }

    private static class BusyWaitVisitor
    extends BaseInspectionVisitor {
        private BusyWaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiExpression loopCondition;
            PsiConditionalLoopStatement loopStatement;
            PsiStatement body;
            if (expression == null) {
                BusyWaitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, "java.lang.Thread", (PsiType)PsiTypes.voidType(), "sleep", new PsiType[]{PsiTypes.longType()}) && !MethodCallUtils.isCallToMethod(expression, "java.lang.Thread", (PsiType)PsiTypes.voidType(), "sleep", new PsiType[]{PsiTypes.longType(), PsiTypes.intType()})) {
                return;
            }
            PsiMethodCallExpression context = expression;
            do {
                if ((loopStatement = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiConditionalLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) == null) {
                    return;
                }
                context = loopStatement;
            } while (!PsiTreeUtil.isAncestor((PsiElement)(body = loopStatement.getBody()), (PsiElement)expression, (boolean)true) || BusyWaitVisitor.isLocallyBoundLoop(loopCondition = loopStatement.getCondition()));
            this.registerMethodCallError(expression, new Object[0]);
        }

        public static boolean isLocallyBoundLoop(PsiExpression loopCondition) {
            if ((loopCondition = PsiUtil.skipParenthesizedExprDown((PsiExpression)loopCondition)) == null) {
                return false;
            }
            if (ExpressionUtils.computeConstantExpression(loopCondition) == null && ExpressionUtils.isLocallyDefinedExpression(loopCondition)) {
                return true;
            }
            if (loopCondition instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)loopCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) {
                for (PsiExpression operand : ((PsiPolyadicExpression)loopCondition).getOperands()) {
                    if (!BusyWaitVisitor.isCounterCondition(operand)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isCounterCondition(PsiExpression expr) {
            PsiElement target;
            PsiReferenceExpression operand;
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expr), PsiBinaryExpression.class);
            if (binOp == null) {
                return false;
            }
            if (!ComparisonUtils.isComparisonOperation(binOp.getOperationTokenType())) {
                return false;
            }
            PsiExpression compared = null;
            if (PsiUtil.isConstantExpression((PsiExpression)binOp.getLOperand())) {
                compared = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            } else if (PsiUtil.isConstantExpression((PsiExpression)binOp.getROperand())) {
                compared = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            }
            if (compared == null) {
                return false;
            }
            return compared instanceof PsiUnaryExpression && (operand = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiUnaryExpression)compared).getOperand()), PsiReferenceExpression.class)) != null && PsiUtil.isAccessedForWriting((PsiExpression)operand) && operand.getQualifierExpression() == null && ((target = operand.resolve()) instanceof PsiLocalVariable || target instanceof PsiParameter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/BusyWaitInspection$BusyWaitVisitor", "visitMethodCallExpression"));
        }
    }
}

