/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodMayBeSynchronizedInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.synchronized.problem.descriptor", new Object[0]);
        if (string == null) {
            MethodMayBeSynchronizedInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new MethodMayBeSynchronizedQuickFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MethodMayBeSynchronizedVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection", "buildErrorString"));
    }

    private static class MethodMayBeSynchronizedQuickFix
    extends PsiUpdateModCommandQuickFix {
        private MethodMayBeSynchronizedQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("method.may.be.synchronized.quickfix", new Object[0]);
            if (string == null) {
                MethodMayBeSynchronizedQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiMethod method;
            PsiCodeBlock methodBody;
            PsiStatement statement;
            if (project == null) {
                MethodMayBeSynchronizedQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                MethodMayBeSynchronizedQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MethodMayBeSynchronizedQuickFix.$$$reportNull$$$0(3);
            }
            if (!((statement = ControlFlowUtils.getOnlyStatementInBlock(methodBody = (method = (PsiMethod)startElement.getParent()).getBody())) instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement;
            PsiCodeBlock body = synchronizedStatement.getBody();
            if (body == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(body);
            tracker.grabComments((PsiElement)methodBody);
            PsiCodeBlock newBlock = (PsiCodeBlock)methodBody.replace((PsiElement)body);
            PsiElement first = newBlock.getFirstBodyElement();
            if (first instanceof PsiWhiteSpace) {
                first = first.getNextSibling();
            }
            if (first != null) {
                tracker.insertCommentsBefore(first);
            }
            PsiModifierList modifierList = method.getModifierList();
            modifierList.setModifierProperty("synchronized", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection$MethodMayBeSynchronizedQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection$MethodMayBeSynchronizedQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MethodMayBeSynchronizedVisitor
    extends BaseInspectionVisitor {
        private MethodMayBeSynchronizedVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                MethodMayBeSynchronizedVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            PsiElement parent = statement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)grandParent;
            if (!ControlFlowUtils.hasStatementCount(method.getBody(), 1)) {
                return;
            }
            PsiExpression lockExpression = statement.getLockExpression();
            if (method.hasModifierProperty("static")) {
                if (!(lockExpression instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classExpression = (PsiClassObjectAccessExpression)lockExpression;
                PsiTypeElement typeElement = classExpression.getOperand();
                PsiType type = typeElement.getType();
                if (!(type instanceof PsiClassType)) {
                    return;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass aClass = classType.resolve();
                PsiClass containingClass = method.getContainingClass();
                if (aClass != containingClass) {
                    return;
                }
            } else {
                if (!(lockExpression instanceof PsiThisExpression)) {
                    return;
                }
                PsiThisExpression thisExpression = (PsiThisExpression)lockExpression;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier != null) {
                    PsiElement target = qualifier.resolve();
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass == null || !containingClass.equals((Object)target)) {
                        return;
                    }
                }
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/MethodMayBeSynchronizedInspection$MethodMayBeSynchronizedVisitor", "visitSynchronizedStatement"));
        }
    }
}

