/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NonAtomicOperationOnVolatileFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.atomic.operation.on.volatile.field.problem.descriptor", new Object[0]);
        if (string == null) {
            NonAtomicOperationOnVolatileFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonAtomicOperationOnVolatileFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection", "buildErrorString"));
    }

    private static class NonAtomicOperationOnVolatileFieldVisitor
    extends BaseInspectionVisitor {
        private NonAtomicOperationOnVolatileFieldVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                NonAtomicOperationOnVolatileFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getRExpression());
            if (rhs == null) {
                return;
            }
            final PsiExpression lhs = expression.getLExpression();
            PsiReferenceExpression volatileFieldRef = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileFieldRef(lhs);
            if (volatileFieldRef == null) {
                return;
            }
            final PsiElement referenceNameElement = volatileFieldRef.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.PLUSEQ) || tokenType.equals(JavaTokenType.MINUSEQ) || tokenType.equals(JavaTokenType.ASTERISKEQ) || tokenType.equals(JavaTokenType.DIVEQ) || tokenType.equals(JavaTokenType.ANDEQ) || tokenType.equals(JavaTokenType.OREQ) || tokenType.equals(JavaTokenType.XOREQ) || tokenType.equals(JavaTokenType.PERCEQ) || tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ)) {
                this.registerError(referenceNameElement, new Object[0]);
                return;
            }
            rhs.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, (PsiExpression)reference)) {
                        this.stopWalking();
                        this.registerError(referenceNameElement, new Object[0]);
                        return;
                    }
                    super.visitReferenceExpression(reference);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor$1", "visitReferenceExpression"));
                }
            });
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                NonAtomicOperationOnVolatileFieldVisitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression);
            if (!PsiUtil.isIncrementDecrementOperation((PsiElement)expression)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiReferenceExpression volatileFieldRef = NonAtomicOperationOnVolatileFieldVisitor.findNonSynchronizedVolatileFieldRef(operand);
            if (volatileFieldRef == null) {
                return;
            }
            PsiElement referenceNameElement = volatileFieldRef.getReferenceNameElement();
            if (referenceNameElement != null) {
                this.registerError(referenceNameElement, new Object[0]);
            }
        }

        @Nullable
        private static PsiReferenceExpression findNonSynchronizedVolatileFieldRef(PsiExpression expression) {
            if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)expression;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("volatile")) {
                return null;
            }
            if (SynchronizationUtil.isInSynchronizedContext((PsiElement)reference)) {
                return null;
            }
            return reference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/threading/NonAtomicOperationOnVolatileFieldInspection$NonAtomicOperationOnVolatileFieldVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

