/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SleepWhileHoldingLockInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("sleep.while.holding.lock.problem.descriptor", new Object[0]);
        if (string == null) {
            SleepWhileHoldingLockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SleepWhileHoldingLockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SleepWhileHoldingLockInspection", "buildErrorString"));
    }

    private static class SleepWhileHoldingLockVisitor
    extends BaseInspectionVisitor {
        private SleepWhileHoldingLockVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiSynchronizedStatement containingSyncStatement;
            if (expression == null) {
                SleepWhileHoldingLockVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"sleep".equals(methodName)) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            boolean isSynced = false;
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                isSynced = true;
            }
            if ((containingSyncStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiSynchronizedStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
                isSynced = true;
            }
            if (!isSynced) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null || !InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SleepWhileHoldingLockInspection$SleepWhileHoldingLockVisitor", "visitMethodCallExpression"));
        }
    }
}

