/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class SynchronizationOnLocalVariableOrMethodParameterInspection
extends BaseInspection {
    public boolean reportLocalVariables = true;
    public boolean reportMethodParameters = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Boolean localVariable = (Boolean)infos[0];
        if (localVariable.booleanValue()) {
            String string = InspectionGadgetsBundle.message("synchronization.on.local.variable.problem.descriptor", new Object[0]);
            if (string == null) {
                SynchronizationOnLocalVariableOrMethodParameterInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("synchronization.on.method.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            SynchronizationOnLocalVariableOrMethodParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizationOnLocalVariableVisitor();
    }

    private static boolean isEscaping(PsiVariable variable) {
        PsiElement scope;
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            scope = parameter.getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            scope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        } else {
            throw new AssertionError();
        }
        if (scope == null) {
            return true;
        }
        EscapeVisitor visitor2 = new EscapeVisitor(variable, scope);
        scope.accept((PsiElementVisitor)visitor2);
        return visitor2.isEscaping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection", "buildErrorString"));
    }

    private class SynchronizationOnLocalVariableVisitor
    extends BaseInspectionVisitor {
        private SynchronizationOnLocalVariableVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                SynchronizationOnLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitSynchronizedStatement(statement);
            if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables && !SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                return;
            }
            PsiExpression lockExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)statement.getLockExpression());
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            if (referenceExpression.isQualified()) {
                return;
            }
            boolean localVariable = false;
            PsiElement target = referenceExpression.resolve();
            if (target instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)target;
                if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables || SynchronizationOnLocalVariableVisitor.isSynchronizedCollection((PsiVariable)variable, referenceExpression) || SynchronizationOnLocalVariableVisitor.canBeEscaped(variable, referenceExpression)) {
                    return;
                }
                localVariable = true;
            } else if (target instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)target;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportMethodParameters) {
                        return;
                    }
                } else {
                    if (!SynchronizationOnLocalVariableOrMethodParameterInspection.this.reportLocalVariables) {
                        return;
                    }
                    localVariable = true;
                }
            } else {
                return;
            }
            PsiElement statementScope = SynchronizationOnLocalVariableVisitor.getScope((PsiElement)statement);
            PsiElement targetScope = SynchronizationOnLocalVariableVisitor.getScope(target);
            if (statementScope != targetScope || SynchronizationOnLocalVariableOrMethodParameterInspection.isEscaping((PsiVariable)target)) {
                return;
            }
            this.registerError((PsiElement)referenceExpression, localVariable);
        }

        private static boolean canBeEscaped(PsiLocalVariable variable, PsiReferenceExpression referenceExpression) {
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)variable, (PsiElement)referenceExpression);
            if (parent == null) {
                return false;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !SynchronizationOnLocalVariableVisitor.isField(initializer) && !SynchronizationOnLocalVariableVisitor.assignedFromMethodCall(initializer)) {
                return false;
            }
            return !VariableAccessUtils.variableIsAssigned((PsiVariable)variable, t -> SynchronizationOnLocalVariableVisitor.isField((PsiExpression)t) || SynchronizationOnLocalVariableVisitor.assignedFromMethodCall((PsiExpression)t), parent);
        }

        private static boolean isField(PsiExpression expression) {
            if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                return SynchronizationOnLocalVariableVisitor.isField(assignmentExpression.getRExpression());
            }
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                return referenceExpression.resolve() instanceof PsiField;
            }
            return false;
        }

        private static boolean assignedFromMethodCall(PsiExpression expression) {
            if (expression instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
                return SynchronizationOnLocalVariableVisitor.assignedFromMethodCall(assignmentExpression.getRExpression());
            }
            if (expression instanceof PsiNewExpression) {
                return false;
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)methodCallExpression);
                for (MethodContract methodContract : contracts) {
                    if (methodContract.getReturnValue() != ContractReturnValue.returnNew()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private static PsiElement getScope(PsiElement element) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
        }

        private static boolean isSynchronizedCollection(@NotNull PsiVariable variable, PsiReferenceExpression referenceExpression) {
            PsiExpression definition;
            if (variable == null) {
                SynchronizationOnLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if (!((definition = DeclarationSearchUtils.findDefinition(referenceExpression, variable)) instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)definition;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            @NonNls String methodName = method.getName();
            if (!methodName.startsWith("synchronized")) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return containingClass != null && "java.util.Collections".equals(containingClass.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$SynchronizationOnLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSynchronizedCollection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EscapeVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiVariable myVariable;
        private final PsiElement myContext;
        private boolean escaping;

        EscapeVisitor(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            if (variable == null) {
                EscapeVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EscapeVisitor.$$$reportNull$$$0(1);
            }
            this.escaping = false;
            this.myVariable = variable;
            this.myContext = context;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                EscapeVisitor.$$$reportNull$$$0(2);
            }
            if (this.escaping) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (!this.myVariable.equals((Object)target)) {
                return;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (context != null && PsiTreeUtil.isAncestor((PsiElement)this.myContext, (PsiElement)context, (boolean)true)) {
                this.escaping = true;
            }
        }

        public boolean isEscaping() {
            return this.escaping;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SynchronizationOnLocalVariableOrMethodParameterInspection$EscapeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

