/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import org.jetbrains.annotations.NotNull;

public final class ThreadLocalNotStaticFinalInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.local.not.static.final.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadLocalNotStaticFinalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return MakeFieldStaticFinalFix.buildFix((PsiField)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadLocalNotStaticFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadLocalNotStaticFinalInspection", "buildErrorString"));
    }

    private static class ThreadLocalNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private ThreadLocalNotStaticFinalVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                ThreadLocalNotStaticFinalVisitor.$$$reportNull$$$0(0);
            }
            super.visitField(field);
            PsiType type = field.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.ThreadLocal")) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/threading/ThreadLocalNotStaticFinalInspection$ThreadLocalNotStaticFinalVisitor", "visitField"));
        }
    }
}

