/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WhileLoopSpinsOnFieldInspection
extends BaseInspection {
    private static final CallMatcher THREAD_ON_SPIN_WAIT = CallMatcher.staticCall("java.lang.Thread", "onSpinWait");
    public boolean ignoreNonEmtpyLoops = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.problem.descriptor", new Object[0]);
        if (string == null) {
            WhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new SpinLoopFix((PsiField)infos[0], (Boolean)infos[1]);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonEmtpyLoops", (String)InspectionGadgetsBundle.message("while.loop.spins.on.field.ignore.non.empty.loops.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            WhileLoopSpinsOnFieldInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    @Nullable
    private static PsiField getFieldIfSimpleFieldComparison(PsiExpression condition) {
        PsiPrefixExpression prefixExpression;
        IElementType type;
        if ((condition = PsiUtil.deparenthesizeExpression((PsiExpression)condition)) == null) {
            return null;
        }
        PsiField field = WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldAccess(condition);
        if (field != null) {
            return field;
        }
        if (condition instanceof PsiPrefixExpression && !(type = (prefixExpression = (PsiPrefixExpression)condition).getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) && !type.equals(JavaTokenType.MINUSMINUS)) {
            PsiExpression operand = prefixExpression.getOperand();
            return WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldComparison(operand);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression lOperand = binaryExpression.getLOperand();
            PsiExpression rOperand = binaryExpression.getROperand();
            if (ExpressionUtils.isLiteral(rOperand)) {
                return WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldComparison(lOperand);
            }
            if (ExpressionUtils.isLiteral(lOperand)) {
                return WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldComparison(rOperand);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiField getFieldIfSimpleFieldAccess(PsiExpression expression) {
        if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) == null) {
            return null;
        }
        if (!(expression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression;
        PsiExpression qualifierExpression = reference.getQualifierExpression();
        if (qualifierExpression != null) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        if (field.hasModifierProperty("volatile") && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)field)) {
            return null;
        }
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SpinLoopFix
    extends ModCommandQuickFix {
        private final String myFieldName;
        private final boolean myAddOnSpinWait;
        private final boolean myAddVolatile;

        SpinLoopFix(PsiField field, boolean addOnSpinWait) {
            this.myFieldName = field.getName();
            this.myAddOnSpinWait = addOnSpinWait;
            this.myAddVolatile = !field.hasModifierProperty("volatile");
        }

        @Nls
        @NotNull
        public String getName() {
            if (this.myAddOnSpinWait && this.myAddVolatile) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile.spinwait", this.myFieldName);
                if (string == null) {
                    SpinLoopFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (this.myAddOnSpinWait) {
                String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.spinwait", new Object[0]);
                if (string == null) {
                    SpinLoopFix.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.volatile", this.myFieldName);
            if (string == null) {
                SpinLoopFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("while.loop.spins.on.field.fix.family.name", new Object[0]);
            if (string == null) {
                SpinLoopFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                SpinLoopFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                SpinLoopFix.$$$reportNull$$$0(5);
            }
            PsiElement element = descriptor.getStartElement();
            ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptor), updater -> {
                PsiModifierList modifierList = null;
                if (this.myAddVolatile) {
                    modifierList = (PsiModifierList)updater.getWritable((PsiElement)SpinLoopFix.getFieldModifierList(element));
                }
                if (this.myAddOnSpinWait) {
                    SpinLoopFix.addOnSpinWait(updater.getWritable(element));
                }
                if (modifierList != null) {
                    modifierList.setModifierProperty("volatile", true);
                }
            });
            if (modCommand == null) {
                SpinLoopFix.$$$reportNull$$$0(6);
            }
            return modCommand;
        }

        private static void addOnSpinWait(PsiElement element) {
            PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLoopStatement.class);
            if (loop == null) {
                return;
            }
            PsiStatement body = loop.getBody();
            if (body == null) {
                return;
            }
            PsiStatement spinCall = JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText("java.lang.Thread.onSpinWait();", element);
            if (body instanceof PsiBlockStatement) {
                PsiCodeBlock block = ((PsiBlockStatement)body).getCodeBlock();
                block.addAfter((PsiElement)spinCall, null);
            } else {
                BlockUtils.addBefore((PsiStatement)body, (PsiStatement[])new PsiStatement[]{spinCall});
            }
            CodeStyleManager.getInstance((Project)element.getProject()).reformat((PsiElement)loop);
        }

        @Nullable
        private static PsiModifierList getFieldModifierList(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiWhileStatement)) {
                return null;
            }
            PsiWhileStatement whileStatement = (PsiWhileStatement)parent;
            PsiExpression condition = whileStatement.getCondition();
            PsiField field = WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldComparison(condition);
            if (field == null) {
                return null;
            }
            return field.getModifierList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$SpinLoopFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            boolean shouldAddSpinWait;
            PsiExpressionStatement onlyExpr;
            if (statement == null) {
                WhileLoopSpinsOnFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitWhileStatement(statement);
            PsiStatement body = statement.getBody();
            boolean empty = ControlFlowUtils.statementIsEmpty(body);
            if (!(!WhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops || empty || (onlyExpr = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(body), PsiExpressionStatement.class)) != null && THREAD_ON_SPIN_WAIT.matches(onlyExpr.getExpression()))) {
                return;
            }
            PsiExpression condition = statement.getCondition();
            PsiField field = WhileLoopSpinsOnFieldInspection.getFieldIfSimpleFieldComparison(condition);
            if (field == null) {
                return;
            }
            if (body != null && (VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)body) || this.containsCall((PsiElement)body, expression -> ThreadingUtils.isWaitCall(expression) || ThreadingUtils.isAwaitCall(expression)))) {
                return;
            }
            boolean java9 = PsiUtil.isLanguageLevel9OrHigher((PsiElement)field);
            boolean bl = shouldAddSpinWait = java9 && empty && !this.containsCall((PsiElement)body, THREAD_ON_SPIN_WAIT);
            if (field.hasModifierProperty("volatile") && !shouldAddSpinWait) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, field, shouldAddSpinWait);
        }

        private boolean containsCall(@Nullable PsiElement element, final Predicate<? super PsiMethodCallExpression> predicate) {
            if (element == null) {
                return false;
            }
            final boolean[] result = new boolean[1];
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethodCallExpression(expression);
                    if (predicate.test(expression)) {
                        result[0] = true;
                        this.stopWalking();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor$1", "visitMethodCallExpression"));
                }
            });
            return result[0];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/threading/WhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor", "visitWhileStatement"));
        }
    }
}

