/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AmbiguousMethodCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass outerClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("ambiguous.method.call.problem.descriptor", superClass.getName(), outerClass.getName());
        if (string == null) {
            AmbiguousMethodCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousMethodCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection", "buildErrorString"));
    }

    private static class AmbiguousMethodCallFix
    extends PsiUpdateModCommandQuickFix {
        private AmbiguousMethodCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("ambiguous.method.call.quickfix", new Object[0]);
            if (string == null) {
                AmbiguousMethodCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AmbiguousMethodCallFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AmbiguousMethodCallFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AmbiguousMethodCallFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = element.getParent();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            String newExpressionText = "super." + methodCallExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AmbiguousMethodCallVisitor
    extends BaseInspectionVisitor {
        private AmbiguousMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                AmbiguousMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)expression);
            if (containingClass == null) {
                return;
            }
            PsiMethod targetMethod = expression.resolveMethod();
            if (targetMethod == null) {
                return;
            }
            PsiClass methodClass = targetMethod.getContainingClass();
            if (methodClass == null || !containingClass.isInheritor(methodClass, true)) {
                return;
            }
            boolean staticAccess = containingClass.hasModifierProperty("static");
            containingClass = PsiUtil.getContainingClass((PsiElement)containingClass);
            while (containingClass != null) {
                Object[] methods = containingClass.findMethodsBySignature(targetMethod, false);
                if (!(methods.length <= 0 || methodClass.equals((Object)containingClass) || (staticAccess |= containingClass.hasModifierProperty("static")) && !ContainerUtil.exists((Object[])methods, m -> m.hasModifierProperty("static")))) {
                    this.registerMethodCallError(expression, methodClass, containingClass);
                    return;
                }
                containingClass = PsiUtil.getContainingClass((PsiElement)containingClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/visibility/AmbiguousMethodCallInspection$AmbiguousMethodCallVisitor", "visitMethodCallExpression"));
        }
    }
}

