/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassEscapesItsScopeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean checkModuleApi = true;
    public boolean checkPublicApi = true;
    public boolean checkPackageLocal;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ClassEscapesDefinedScope";
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"checkModuleApi", (String)InspectionGadgetsBundle.message("class.escapes.defined.scope.display.module.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"checkPublicApi", (String)InspectionGadgetsBundle.message("class.escapes.defined.scope.display.public.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"checkPackageLocal", (String)InspectionGadgetsBundle.message("class.escapes.defined.scope.display.package.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            ClassEscapesItsScopeInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        HashSet<String> exportedPackageNames;
        Module module;
        VirtualFile vFile;
        PsiJavaModule psiModule;
        PsiJavaFile javaFile;
        PsiFile file;
        if (holder == null) {
            ClassEscapesItsScopeInspection.$$$reportNull$$$0(1);
        }
        ArrayList<VisibilityChecker> checkers = new ArrayList<VisibilityChecker>(2);
        if (this.checkModuleApi && (file = holder.getFile()) instanceof PsiJavaFile && PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)(javaFile = (PsiJavaFile)file)) && (psiModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)file)) != null && (vFile = file.getVirtualFile()) != null && (module = ProjectFileIndex.getInstance((Project)holder.getProject()).getModuleForFile(vFile)) != null && (exportedPackageNames = new HashSet<String>(ContainerUtil.mapNotNull((Iterable)psiModule.getExports(), PsiPackageAccessibilityStatement::getPackageName))).contains(javaFile.getPackageName())) {
            checkers.add(new Java9NonAccessibleTypeExposedVisitor(holder, module, psiModule.getName(), exportedPackageNames));
        }
        if (this.checkPublicApi || this.checkPackageLocal) {
            checkers.add(new ClassEscapesItsScopeVisitor(holder));
        }
        Object object = !checkers.isEmpty() ? new VisibilityVisitor(checkers.toArray(VisibilityChecker.EMPTY_ARRAY)) : PsiElementVisitor.EMPTY_VISITOR;
        if (object == null) {
            ClassEscapesItsScopeInspection.$$$reportNull$$$0(2);
        }
        return object;
    }

    public static PsiMember getExportingMember(PsiJavaCodeReferenceElement reference) {
        PsiElement parent = reference.getParent();
        if (!(parent instanceof PsiTypeElement) && !(parent instanceof PsiReferenceList)) {
            return null;
        }
        PsiElement grandParent = PsiTreeUtil.skipParentsOfType((PsiElement)reference, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceList.class, PsiParameter.class, PsiParameterList.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, PsiTypeParameterList.class});
        if (grandParent instanceof PsiField || grandParent instanceof PsiMethod) {
            return (PsiMember)grandParent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class Java9NonAccessibleTypeExposedVisitor
    extends VisibilityChecker {
        private final ModuleFileIndex myModuleFileIndex;
        private final Set<String> myExportedPackageNames;
        private final String myModuleName;

        Java9NonAccessibleTypeExposedVisitor(@NotNull ProblemsHolder holder, @NotNull Module module, @NotNull String moduleName, @NotNull Set<String> exportedPackageNames) {
            if (holder == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(0);
            }
            if (module == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(1);
            }
            if (moduleName == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(2);
            }
            if (exportedPackageNames == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(3);
            }
            super(holder);
            this.myModuleName = moduleName;
            this.myModuleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            this.myExportedPackageNames = exportedPackageNames;
        }

        @Override
        public boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.isModulePublicApi(member) && !this.isModulePublicApi((PsiMember)psiClass) && this.isInModuleSource(psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.java9.modules.descriptor", this.myModuleName), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private static boolean isInFinalClass(@NotNull PsiMember member) {
            PsiClass containingClass;
            if (member == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(4);
            }
            if ((containingClass = member.getContainingClass()) == null) {
                return false;
            }
            return containingClass.hasModifierProperty("final");
        }

        @Contract(value="null -> false")
        private boolean isModulePublicApi(@Nullable PsiMember member) {
            if (member == null || member instanceof PsiTypeParameter) {
                return false;
            }
            if (member.hasModifierProperty("public") || !Java9NonAccessibleTypeExposedVisitor.isInFinalClass(member) && member.hasModifierProperty("protected")) {
                PsiElement parent = member.getParent();
                if (parent instanceof PsiClass) {
                    return this.isModulePublicApi((PsiMember)((PsiClass)parent));
                }
                if (parent instanceof PsiJavaFile) {
                    String packageName = ((PsiJavaFile)parent).getPackageName();
                    return this.myExportedPackageNames.contains(packageName);
                }
            }
            return false;
        }

        private boolean isInModuleSource(@NotNull PsiClass psiClass) {
            VirtualFile vFile;
            PsiFile psiFile;
            if (psiClass == null) {
                Java9NonAccessibleTypeExposedVisitor.$$$reportNull$$$0(5);
            }
            if ((psiFile = psiClass.getContainingFile()) != null && (vFile = psiFile.getVirtualFile()) != null) {
                return this.myModuleFileIndex.isInSourceContent(vFile);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedPackageNames";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$Java9NonAccessibleTypeExposedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInFinalClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInModuleSource";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClassEscapesItsScopeVisitor
    extends VisibilityChecker {
        ClassEscapesItsScopeVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.needToCheck(member) && ClassEscapesItsScopeVisitor.isLessRestrictiveScope(member, psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.problem.descriptor", new Object[0]), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private boolean needToCheck(PsiMember member) {
            return ClassEscapesItsScopeInspection.this.checkPublicApi && (member.hasModifierProperty("public") || member.hasModifierProperty("protected")) || ClassEscapesItsScopeInspection.this.checkPackageLocal && member.hasModifierProperty("packageLocal");
        }

        private static boolean isLessRestrictiveScope(@NotNull PsiMember member, @NotNull PsiClass aClass) {
            if (member == null) {
                ClassEscapesItsScopeVisitor.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                ClassEscapesItsScopeVisitor.$$$reportNull$$$0(1);
            }
            int methodScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)member);
            int classScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)aClass);
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null || containingClass.getQualifiedName() == null) {
                return false;
            }
            int containingClassScopeOrder = ClassEscapesItsScopeVisitor.getScopeOrder((PsiModifierListOwner)containingClass);
            return methodScopeOrder > classScopeOrder && containingClassScopeOrder > classScopeOrder;
        }

        private static int getScopeOrder(@NotNull PsiModifierListOwner element) {
            if (element == null) {
                ClassEscapesItsScopeVisitor.$$$reportNull$$$0(2);
            }
            if (element.hasModifierProperty("public")) {
                return 4;
            }
            if (element.hasModifierProperty("private")) {
                return 1;
            }
            if (element.hasModifierProperty("protected")) {
                return 3;
            }
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$ClassEscapesItsScopeVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLessRestrictiveScope";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getScopeOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VisibilityVisitor
    extends JavaElementVisitor {
        private final VisibilityChecker[] myCheckers;

        VisibilityVisitor(VisibilityChecker[] checkers) {
            this.myCheckers = checkers;
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiClass psiClass;
            PsiMember member;
            block7: {
                block6: {
                    if (reference == null) {
                        VisibilityVisitor.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceElement(reference);
                    member = ClassEscapesItsScopeInspection.getExportingMember(reference);
                    if (member == null || VisibilityVisitor.isPrivate(member)) {
                        return;
                    }
                    PsiElement resolved = reference.resolve();
                    if (!(resolved instanceof PsiClass)) break block6;
                    psiClass = (PsiClass)resolved;
                    if (!(resolved instanceof PsiTypeParameter)) break block7;
                }
                return;
            }
            for (VisibilityChecker checker : this.myCheckers) {
                if (!checker.checkVisibilityIssue(member, psiClass, reference)) continue;
                return;
            }
        }

        private static boolean isPrivate(@NotNull PsiMember member) {
            if (member == null) {
                VisibilityVisitor.$$$reportNull$$$0(1);
            }
            if (member.hasModifierProperty("private")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            return containingClass != null && VisibilityVisitor.isPrivate((PsiMember)containingClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/visibility/ClassEscapesItsScopeInspection$VisibilityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPrivate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class VisibilityChecker {
        static final VisibilityChecker[] EMPTY_ARRAY = new VisibilityChecker[0];
        final ProblemsHolder myHolder;

        protected VisibilityChecker(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        abstract boolean checkVisibilityIssue(PsiMember var1, PsiClass var2, PsiJavaCodeReferenceElement var3);
    }
}

