/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.psi.PsiAdapter;

public final class GenerateToStringUtils {
    private static final Logger LOG = Logger.getInstance(GenerateToStringUtils.class);

    private GenerateToStringUtils() {
    }

    public static PsiField @NotNull [] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        return GenerateToStringUtils.filterAvailableFields(clazz, false, pattern);
    }

    public static PsiField @NotNull [] filterAvailableFields(PsiClass clazz, boolean includeSuperClass, FilterPattern pattern) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering fields using the pattern: " + String.valueOf(pattern));
        }
        ArrayList availableFields = new ArrayList();
        GenerateToStringUtils.collectAvailableFields(clazz, (PsiElement)clazz, includeSuperClass, pattern, availableFields, new HashSet());
        PsiField[] psiFieldArray = availableFields.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            GenerateToStringUtils.$$$reportNull$$$0(0);
        }
        return psiFieldArray;
    }

    private static void collectAvailableFields(PsiClass clazz, PsiElement place, boolean includeSuperClass, FilterPattern pattern, List<? super PsiField> availableFields, HashSet<? super PsiClass> visited) {
        PsiField[] fields;
        PsiClass superClass;
        int sortElements = GenerateToStringContext.getConfig().getSortElements();
        if (includeSuperClass && sortElements == 3 && (superClass = clazz.getSuperClass()) != null && visited.add((PsiClass)superClass)) {
            GenerateToStringUtils.collectAvailableFields(superClass, place, true, pattern, availableFields, visited);
        }
        for (PsiField field : fields = includeSuperClass && sortElements != 3 ? clazz.getAllFields() : clazz.getFields()) {
            if (!JavaResolveUtil.isAccessible((PsiMember)field, (PsiClass)field.getContainingClass(), (PsiModifierList)field.getModifierList(), (PsiElement)place, null, null) || pattern.fieldMatches(field)) continue;
            availableFields.add((PsiField)field);
        }
    }

    public static PsiMethod @NotNull [] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        if (pattern == null) {
            GenerateToStringUtils.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering methods using the pattern: " + String.valueOf(pattern));
        }
        ArrayList availableMethods = new ArrayList();
        GenerateToStringUtils.collectAvailableMethods(clazz, clazz, pattern, availableMethods, new HashSet());
        PsiMethod[] psiMethodArray = availableMethods.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            GenerateToStringUtils.$$$reportNull$$$0(2);
        }
        return psiMethodArray;
    }

    private static void collectAvailableMethods(PsiClass clazz, PsiClass base, @NotNull FilterPattern pattern, List<? super PsiMethod> availableMethods, HashSet<? super PsiClass> visited) {
        PsiMethod[] methods;
        PsiClass superClass;
        int sortElements;
        if (pattern == null) {
            GenerateToStringUtils.$$$reportNull$$$0(3);
        }
        if ((sortElements = GenerateToStringContext.getConfig().getSortElements()) == 3 && (superClass = clazz.getSuperClass()) != null && visited.add((PsiClass)superClass)) {
            GenerateToStringUtils.collectAvailableMethods(superClass, base, pattern, availableMethods, visited);
        }
        for (PsiMethod method : methods = sortElements != 3 ? clazz.getAllMethods() : clazz.getMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method) || (returnType = method.getReturnType()) == null || PsiTypes.voidType().equals((Object)returnType) || !method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || base.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method), false) != null || "toString".equals(methodName = method.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add((PsiMethod)method);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/generate/GenerateToStringUtils";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableFields";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/generate/GenerateToStringUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "filterAvailableMethods";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "filterAvailableMethods";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAvailableMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }
}

