/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public final class FieldNotUsedInToStringInspection
extends AbstractToStringInspection {
    @NotNull
    public String getShortName() {
        return "FieldNotUsedInToString";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldNotUsedInToStringInspection.$$$reportNull$$$0(0);
        }
        return new FieldNotUsedInToStringVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/java/generate/inspection/FieldNotUsedInToStringInspection", "buildVisitor"));
    }

    private static final class FieldNotUsedInToStringVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        private FieldNotUsedInToStringVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                FieldNotUsedInToStringVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            @NonNls String methodName = method.getName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            PsiType returnType = method.getReturnType();
            PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope());
            if (!javaLangString.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiField[] fields = GenerateToStringUtils.filterAvailableFields(aClass, GenerateToStringContext.getConfig().getFilterPattern());
            PsiMethod[] methods = GenerateToStringContext.getConfig().isEnableMethods() ? GenerateToStringUtils.filterAvailableMethods(aClass, GenerateToStringContext.getConfig().getFilterPattern()) : PsiMethod.EMPTY_ARRAY;
            FieldUsedVisitor visitor2 = new FieldUsedVisitor(fields, methods);
            method.accept((PsiElementVisitor)visitor2);
            for (PsiField field : visitor2.getUnusedFields()) {
                if (!field.isPhysical()) continue;
                String fieldName = field.getName();
                this.myHolder.registerProblem((PsiElement)field.getNameIdentifier(), JavaAnalysisBundle.message((String)"inspection.field.not.used.in.to.string.description2", (Object[])new Object[]{fieldName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes());
            }
            for (PsiMethod unusedMethod : visitor2.getUnusedMethods()) {
                if (!unusedMethod.isPhysical()) continue;
                PsiIdentifier identifier = unusedMethod.getNameIdentifier();
                PsiMethod target = identifier == null ? unusedMethod : identifier;
                this.myHolder.registerProblem((PsiElement)target, JavaAnalysisBundle.message((String)"inspection.field.not.used.in.to.string.description", (Object[])new Object[]{unusedMethod.getName()}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/java/generate/inspection/FieldNotUsedInToStringInspection$FieldNotUsedInToStringVisitor", "visitMethod"));
        }
    }

    private static final class FieldUsedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiField> myUnusedFields = new HashSet<PsiField>();
        private final Set<PsiMethod> myUnusedMethods = new HashSet<PsiMethod>();

        FieldUsedVisitor(PsiField[] fields, PsiMethod[] methods) {
            Collections.addAll(this.myUnusedFields, fields);
            Collections.addAll(this.myUnusedMethods, methods);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                FieldUsedVisitor.$$$reportNull$$$0(0);
            }
            if (this.myUnusedFields.isEmpty() && this.myUnusedMethods.isEmpty()) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement target = expression.resolve();
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                this.myUnusedFields.remove(field);
            } else if (target instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)target;
                if (FieldUsedVisitor.usesReflection(method)) {
                    this.myUnusedFields.clear();
                    this.myUnusedMethods.clear();
                } else {
                    this.myUnusedMethods.remove(method);
                    PsiField field = PropertyUtilBase.findPropertyFieldByMember((PsiMember)method);
                    this.myUnusedFields.remove(field);
                }
            }
        }

        private static boolean usesReflection(PsiMethod method) {
            @NonNls String name = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            @NonNls String qualifiedName = containingClass.getQualifiedName();
            if ("getDeclaredFields".equals(name)) {
                return "java.lang.Class".equals(qualifiedName);
            }
            if ("toString".equals(name)) {
                return "org.apache.commons.lang.builder.ReflectionToStringBuilder".equals(qualifiedName) || "java.util.Objects".equals(qualifiedName);
            }
            return false;
        }

        Set<PsiField> getUnusedFields() {
            return this.myUnusedFields;
        }

        Set<PsiMethod> getUnusedMethods() {
            return this.myUnusedMethods;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/java/generate/inspection/FieldNotUsedInToStringInspection$FieldUsedVisitor", "visitReferenceExpression"));
        }
    }
}

