/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlLineCommentBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0001\u00a8\u0006\u0013"}, d2={"configureAttributesForCortege", "", "host", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "decideSpacingForCortege", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "configureAttributesForPostfixOptions", "blocks", "", "configureLineComments", "autodetectDelimiter", "", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "flow", "", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlCommonHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlCommonHandlers.kt\ncom/intellij/sql/formatter/model/SqlCommonHandlersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SqlFormattingModelFun.kt\ncom/intellij/sql/formatter/model/SqlFormattingModelFun\n*L\n1#1,158:1\n1915#2,2:159\n1915#2,2:161\n1915#2,2:163\n1915#2,2:165\n1915#2,2:167\n1915#2,2:173\n1#3:169\n561#4,3:170\n*S KotlinDebug\n*F\n+ 1 SqlCommonHandlers.kt\ncom/intellij/sql/formatter/model/SqlCommonHandlersKt\n*L\n36#1:159,2\n37#1:161,2\n38#1:163,2\n45#1:165,2\n46#1:167,2\n82#1:173,2\n82#1:170,3\n*E\n"})
public final class SqlCommonHandlersKt {
    public static final void configureAttributesForCortege(@NotNull SqlFlowBlock host) {
        Object object;
        boolean c1st;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<SqlBlock> blocks = host.getNestedBlocks();
        SqlCodeStyleSettings s = host.getContext().getSql();
        Wrap w = SqlFlowBlock.makeWrap$default(host, WrapType.NORMAL, false, 2, null);
        Alignment a1 = null;
        Alignment a2 = null;
        Indent i2 = null;
        boolean bl = c1st = host.userDelimiterSetting() == 1;
        if (c1st) {
            SqlBlock it;
            a1 = SqlFormattingModelFun.makeLeftAlignment();
            a2 = SqlFormattingModelFun.makeLeftAlignmentBS();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.PREFIX);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SqlBlock)element$iv;
                boolean bl2 = false;
                it.setMyAlign(a1);
            }
            $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.DELIMITER);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SqlBlock)element$iv;
                boolean bl3 = false;
                it.setMyWrap(w);
                it.setMyAlign(a1);
            }
            $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT);
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (SqlBlock)element$iv;
                boolean bl4 = false;
                it.setMyAlign(a2);
            }
            i2 = SqlFormattingFunKt.getNONE_INDENT();
        } else {
            SqlBlock it;
            a1 = s.CORTEGE_CLOSING == 1 ? SqlFormattingModelFun.makeLeftAlignment() : null;
            a2 = SqlFormattingModelFun.makeLeftAlignment();
            Indent indent = Indent.getSpaceIndent((int)(s.CORTEGE_SPACE_WITHIN_PARENTHESES ? 2 : 1), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)indent, (String)"getSpaceIndent(...)");
            i2 = indent;
            JBIterable jBIterable = SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT).skip(1);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"skip(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (SqlBlock)element$iv;
                boolean bl5 = false;
                it.setMyWrap(w);
            }
            $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT);
            $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                it = (SqlBlock)element$iv;
                boolean bl6 = false;
                it.setMyIndent(i2);
                it.setMyAlign(a2);
            }
        }
        switch (s.CORTEGE_CLOSING) {
            case 1: {
                Object it;
                SqlBlock sqlBlock = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)blocks, BlockRole.SUFFIX);
                if (sqlBlock != null) {
                    it = object = sqlBlock;
                    boolean bl7 = false;
                    ((SqlBlock)it).setMyWrap(w);
                    ((SqlBlock)it).setMyIndent(Indent.getSpaceIndent((int)0, (boolean)true));
                    ((SqlBlock)it).setMyAlign(a1);
                }
                break;
            }
            case 2: {
                Object it;
                SqlBlock sqlBlock = SqlFormattingModelFun.find((Iterable<? extends SqlBlock>)blocks, BlockRole.SUFFIX);
                if (sqlBlock != null) {
                    it = object = sqlBlock;
                    boolean bl8 = false;
                    ((SqlBlock)it).setMyWrap(w);
                    ((SqlBlock)it).setMyIndent(i2);
                    ((SqlBlock)it).setMyAlign(a2);
                }
                break;
            }
        }
    }

    @Nullable
    public static final Spacing decideSpacingForCortege(@NotNull SqlFlowBlock host, @NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        SqlFormattingContext context = host.getContext();
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        boolean sip = context.getSql().CORTEGE_SPACE_WITHIN_PARENTHESES;
        boolean c1st = host.userDelimiterSetting() == 1;
        boolean collapse = host.getShape() == BlockShape.DECIDED_TO_ONE_ROW;
        if (r1 == BlockRole.PREFIX) {
            spacing = context.makeSpace(sip);
        } else if (r2 == BlockRole.ELEMENT) {
            spacing = r1 == BlockRole.DELIMITER ? context.makeSpace(context.getSql().CORTEGE_SPACE_AFTER_COMMA, !c1st && !collapse) : SqlFormattingContext.makeSpace$default(context, false, !c1st, 1, null);
        } else if (r1 == BlockRole.DELIMITER) {
            spacing = context.makeSpace(context.getSql().CORTEGE_SPACE_AFTER_COMMA);
        } else if (r2 == BlockRole.DELIMITER) {
            spacing = context.makeSpace(context.getSql().CORTEGE_SPACE_BEFORE_COMMA, c1st && !collapse);
        } else if (r2 == BlockRole.SUFFIX) {
            switch (context.getSql().CORTEGE_CLOSING) {
                case 1: 
                case 2: {
                    spacing = SqlFormattingContext.makeSmartSpacing$default(context, host.getShape(), new TextRange(host.getRange().getStartOffset(), block2.getRange().getStartOffset()), sip, false, 8, null);
                    break;
                }
                case 9: {
                    spacing = context.makeSpace(sip);
                    break;
                }
                default: {
                    spacing = context.makeSpace(sip, !collapse);
                    break;
                }
            }
        } else {
            spacing = null;
        }
        return spacing;
    }

    /*
     * WARNING - void declaration
     */
    public static final void configureAttributesForPostfixOptions(@NotNull SqlFlowBlock host, @NotNull List<? extends SqlBlock> blocks) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        SqlCodeStyleSettings s = host.getContext().getSql();
        Wrap postWrap1 = null;
        Wrap postWrap2 = null;
        Alignment postAlign = null;
        Iterable $this$filter$iv = blocks;
        boolean $i$f$filter = false;
        Iterable $this$jbi$iv$iv = $this$filter$iv;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"from(...)");
        JBIterable jBIterable2 = jBIterable.filter(SqlPostfixClauseBlock.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        $this$filter$iv = (Iterable)jBIterable2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlPostfixClauseBlock it = (SqlPostfixClauseBlock)element$iv;
            boolean bl = false;
            if (postWrap1 == null) {
                postWrap1 = SqlFlowBlock.makeWrap$default(host, s.POST_OPT_WRAP_1 ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                postAlign = s.POST_OPT_ALIGN ? SqlFormattingModelFun.makeLeftAlignment() : null;
                it.setMyWrap(postWrap1);
                it.setMyIndent(s.POST_OPT_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                it.setMyAlign(postAlign);
                continue;
            }
            if (postWrap2 == null) {
                postWrap2 = SqlFlowBlock.makeWrap$intellij_database_sql_core_impl$default(host, postWrap1, s.POST_OPT_WRAP_2 ? WrapType.ALWAYS : WrapType.NORMAL, false, 4, null);
            }
            it.setMyWrap(postWrap2);
            it.setMyIndent(s.POST_OPT_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
            it.setMyAlign(postAlign);
        }
    }

    public static final void configureLineComments(@NotNull SqlFlowBlock host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        JBIterable jBIterable = TreeTraversal.LEAVES_DFS.traversal((Object)host, arg_0 -> SqlCommonHandlersKt.configureLineComments$lambda$1(SqlCommonHandlersKt::configureLineComments$lambda$0, arg_0)).filter(SqlLineCommentBlock.class).filter(arg_0 -> SqlCommonHandlersKt.configureLineComments$lambda$3(SqlCommonHandlersKt::configureLineComments$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable traversable = jBIterable;
        Alignment a = null;
        for (SqlLineCommentBlock b : traversable) {
            if (b.getMyAlign() != null) continue;
            if (a == null) {
                a = SqlFormattingModelFun.makeLeftAlignmentBS();
            }
            b.setMyAlign(a);
        }
    }

    @SqlCodeStyleConst.CommaMagicValues
    public static final int autodetectDelimiter(@NotNull SqlFormattingContext context, @NotNull Iterable<? extends SqlBlock> flow) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(flow, (String)"flow");
        int c1stCount = 0;
        int cLastCount = 0;
        boolean wasAtLeastOneDelimiter = false;
        TextRange lastElement = null;
        TextRange lastDelimiter = null;
        BlockRole lastRole = BlockRole.NOTHING;
        for (SqlBlock sqlBlock : flow) {
            switch (WhenMappings.$EnumSwitchMapping$0[sqlBlock.getRole().ordinal()]) {
                case 1: {
                    if (lastRole == BlockRole.DELIMITER && lastDelimiter != null && context.textContains(lastDelimiter.getEndOffset(), sqlBlock.getRange().getStartOffset(), '\n')) {
                        ++cLastCount;
                    }
                    lastElement = sqlBlock.getRange();
                    lastRole = BlockRole.ELEMENT;
                    break;
                }
                case 2: {
                    if (lastRole == BlockRole.ELEMENT && lastElement != null && context.textContains(lastElement.getEndOffset(), sqlBlock.getRange().getStartOffset(), '\n')) {
                        ++c1stCount;
                    }
                    lastDelimiter = sqlBlock.getRange();
                    lastRole = BlockRole.DELIMITER;
                    wasAtLeastOneDelimiter = true;
                }
            }
        }
        return cLastCount > c1stCount ? 2 : (c1stCount > cLastCount ? 1 : (wasAtLeastOneDelimiter ? -1 : 0));
    }

    private static final Iterable configureLineComments$lambda$0(SqlBlock it) {
        it.grow();
        return it.getNestedBlocks();
    }

    private static final Iterable configureLineComments$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean configureLineComments$lambda$2(SqlLineCommentBlock it) {
        return !it.isWholeString();
    }

    private static final boolean configureLineComments$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockRole.values().length];
            try {
                nArray[BlockRole.ELEMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.DELIMITER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

