/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.inspections.dataflow.SqlDfaNullability;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.SqlTableDescriptor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlTableType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u000f\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u0018\u001a\u00020\u0015H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlNaturalJoinInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/EvalInstruction;", "expression", "Lcom/intellij/sql/psi/SqlJoinExpression;", "<init>", "(Lcom/intellij/sql/psi/SqlJoinExpression;)V", "getExpression", "()Lcom/intellij/sql/psi/SqlJoinExpression;", "eval", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "arguments", "", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;[Lcom/intellij/codeInspection/dataFlow/value/DfaValue;)Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "getCorrespondingColumn", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/sql/psi/SqlTableType;", "name", "", "type", "Lcom/intellij/database/types/DasType;", "toString", "intellij.database.sql.core.impl"})
public final class SqlNaturalJoinInstruction
extends EvalInstruction {
    @NotNull
    private final SqlJoinExpression expression;

    public SqlNaturalJoinInstruction(@NotNull SqlJoinExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)expression), 2);
        this.expression = expression;
    }

    @NotNull
    public final SqlJoinExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        DfaValue dfaValue = arguments[0];
        DfaVariableValue dfaVariableValue = dfaValue instanceof DfaVariableValue ? (DfaVariableValue)dfaValue : null;
        if (dfaVariableValue == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        DfaVariableValue left = dfaVariableValue;
        DfaValue dfaValue2 = arguments[1];
        DfaVariableValue dfaVariableValue2 = dfaValue2 instanceof DfaVariableValue ? (DfaVariableValue)dfaValue2 : null;
        if (dfaVariableValue2 == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        DfaVariableValue right = dfaVariableValue2;
        DfType dfType = state.getDfType((DfaValue)left);
        SqlDfTableType sqlDfTableType = dfType instanceof SqlDfTableType ? (SqlDfTableType)dfType : null;
        if (sqlDfTableType == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType leftType = sqlDfTableType;
        DfType dfType2 = state.getDfType((DfaValue)right);
        SqlDfTableType sqlDfTableType2 = dfType2 instanceof SqlDfTableType ? (SqlDfTableType)dfType2 : null;
        if (sqlDfTableType2 == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
            return (DfaValue)dfaTypeValue;
        }
        SqlDfTableType rightType = sqlDfTableType2;
        VariableDescriptor variableDescriptor = left.getDescriptor();
        Intrinsics.checkNotNull((Object)variableDescriptor, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.SqlTableDescriptor");
        SqlTableType leftSqlType = ((SqlTableDescriptor)variableDescriptor).getDasType();
        VariableDescriptor variableDescriptor2 = right.getDescriptor();
        Intrinsics.checkNotNull((Object)variableDescriptor2, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.SqlTableDescriptor");
        SqlTableType rightSqlType = ((SqlTableDescriptor)variableDescriptor2).getDasType();
        SqlTableType dasType = this.expression.getDasType();
        ArrayList<PsiElement> resultColumns = new ArrayList<PsiElement>(dasType.getColumnCount());
        List leftJoinedColumns = new ArrayList();
        List rightJoinedColumns = new ArrayList();
        int n = dasType.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String columnName = dasType.getColumnName(i2);
            DasType columnType = dasType.getColumnDasType(i2);
            Intrinsics.checkNotNull((Object)columnName);
            Intrinsics.checkNotNull((Object)columnType);
            PsiElement leftColumn = this.getCorrespondingColumn(leftSqlType, columnName, columnType);
            PsiElement rightColumn = this.getCorrespondingColumn(rightSqlType, columnName, columnType);
            if (leftColumn != null && rightColumn != null) {
                leftJoinedColumns.add(leftColumn);
                rightJoinedColumns.add(rightColumn);
            }
            resultColumns.add(dasType.getColumnElement(i2));
        }
        leftType = leftType.setNullability(leftJoinedColumns, SqlDfaNullability.NOT_NULL);
        rightType = rightType.setNullability(rightJoinedColumns, SqlDfaNullability.NOT_NULL);
        state.setDfType((DfaValue)left, (DfType)leftType);
        state.setDfType((DfaValue)right, (DfType)rightType);
        DfType dfType3 = leftType.join(rightType);
        Intrinsics.checkNotNull((Object)dfType3, (String)"null cannot be cast to non-null type com.intellij.sql.inspections.dataflow.types.SqlDfTableType");
        SqlDfTableType resultType = ((SqlDfTableType)dfType3).subtract((List<? extends PsiElement>)resultColumns);
        return SqlDfaUtilKt.createTableValue((PsiElement)this.expression, null, factory, state, resultType);
    }

    private final PsiElement getCorrespondingColumn(SqlTableType $this$getCorrespondingColumn, String name, DasType type) {
        int n = $this$getCorrespondingColumn.getColumnCount();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!Intrinsics.areEqual((Object)$this$getCorrespondingColumn.getColumnName(i2), (Object)name) || !Intrinsics.areEqual((Object)$this$getCorrespondingColumn.getColumnDasType(i2), (Object)type)) continue;
            return $this$getCorrespondingColumn.getColumnElement(i2);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return "NATURAL_JOIN";
    }
}

