/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypeParameterList;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlDasTypeAwareDeepRecursiveElement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u000eB\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/psi/impl/SqlTypeElementBase;", "Lcom/intellij/sql/psi/impl/SqlCompositeElementImpl;", "Lcom/intellij/sql/psi/SqlTypeElement;", "Lcom/intellij/sql/psi/impl/SqlDasTypeAwareDeepRecursiveElement;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "accept", "", "visitor", "Lcom/intellij/sql/psi/SqlVisitor;", "parseDataType", "Lcom/intellij/database/model/DataType;", "DataTypeParser", "intellij.database.sql.core.impl"})
public abstract class SqlTypeElementBase
extends SqlCompositeElementImpl
implements SqlTypeElement,
SqlDasTypeAwareDeepRecursiveElement {
    protected SqlTypeElementBase(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @Override
    public void accept(@NotNull SqlVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSqlTypeElement((SqlTypeElement)this);
    }

    @NotNull
    protected DataType parseDataType() {
        return new DataTypeParser(this).parse();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser;", "", "myElement", "Lcom/intellij/sql/psi/impl/SqlTypeElementBase;", "<init>", "(Lcom/intellij/sql/psi/impl/SqlTypeElementBase;)V", "mySchema", "", "myTypeName", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "parse", "Lcom/intellij/database/model/DataType;", "parseGenericType", "text", "isGenericType", "", "()Z", "parseTypeAndSchema", "", "cur", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "isNumeric", "type", "Lcom/intellij/psi/tree/IElementType;", "enumVagueArgs", "getEnumVagueArgs", "()Ljava/lang/String;", "enumArgs", "", "getEnumArgs", "()Ljava/util/List;", "Companion", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlTypeElementBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlTypeElementBase.kt\ncom/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser\n+ 2 SqlUtilFun.kt\ncom/intellij/sql/SqlUtilFun\n*L\n1#1,200:1\n278#2:201\n278#2:202\n278#2:203\n278#2:204\n*S KotlinDebug\n*F\n+ 1 SqlTypeElementBase.kt\ncom/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser\n*L\n135#1:201\n162#1:202\n175#1:203\n183#1:204\n*E\n"})
    private static final class DataTypeParser {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final SqlTypeElementBase myElement;
        @Nullable
        private String mySchema;
        @NotNull
        private final StringBuilder myTypeName;

        public DataTypeParser(@NotNull SqlTypeElementBase myElement) {
            Intrinsics.checkNotNullParameter((Object)myElement, (String)"myElement");
            this.myElement = myElement;
            this.myTypeName = new StringBuilder();
        }

        @NotNull
        public final DataType parse() {
            DataType dataType;
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)this.myElement);
            int state = 0;
            String suffix = null;
            int i1 = -1;
            int i2 = 0;
            LengthUnit unit = null;
            boolean setof = false;
            StringBuilder vague = new StringBuilder();
            for (PsiElement cur = this.myElement.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)cur);
                boolean isIdentToken = type instanceof SqlKeywordTokenType || SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(type) || Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT) || Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT_DELIMITED) || type instanceof SqlIdentifierKeywordTokenType;
                String text = cur instanceof SqlTypeElement ? ((SqlTypeElement)cur).getDasType().getSpecification() : cur.getText();
                if (state == 0 && this.isGenericType()) {
                    Intrinsics.checkNotNull((Object)text);
                    DataType dataType2 = DataTypeFactory.of((String)this.parseGenericType(text));
                    Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"of(...)");
                    return dataType2;
                }
                if (state == 0 && (Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_ENUM) || Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_TYPE_REFERENCE) && (StringsKt.equals((String)"enum8", (String)text, (boolean)true) || StringsKt.equals((String)"enum16", (String)text, (boolean)true)))) {
                    DataType dataType3 = DataTypeFactory.ofValues(null, null, (String)"enum", this.getEnumArgs(), (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType3, (String)"ofValues(...)");
                    return dataType3;
                }
                if (state == 0 && Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_SET)) {
                    DataType dataType4 = DataTypeFactory.ofArgs(null, (String)"set", (String)this.getEnumVagueArgs(), (boolean)false);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType4, (String)"ofArgs(...)");
                    return dataType4;
                }
                if (state == 0 && type instanceof SqlKeywordTokenType && StringsKt.equals((String)text, (String)"setof", (boolean)true)) {
                    setof = true;
                    continue;
                }
                if (state == 0 && cur instanceof SqlReferenceExpression) {
                    state = 2;
                    this.parseTypeAndSchema((SqlReferenceExpression)cur);
                    continue;
                }
                if (state < 2 && isIdentToken) {
                    state = 1;
                    DataTypeParser.Companion.spAppend(this.myTypeName, cur instanceof SqlStringTokenElement ? ((SqlStringTokenElement)cur).getTokenText() : text);
                    continue;
                }
                if (state < 3 && (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_LEFT_BRACKET) || Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_RIGHT_BRACKET))) {
                    state = 1;
                    this.myTypeName.append(text);
                    continue;
                }
                if ((state == 1 || state == 2) && Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_LEFT_PAREN)) {
                    state = 3;
                    continue;
                }
                if (state == 3 && this.isNumeric(type)) {
                    ++state;
                    i1 = StringUtil.parseInt((String)text, (int)i1);
                    continue;
                }
                if (state == 3 && Intrinsics.areEqual((Object)type, (Object)SqlCommonKeywords.SQL_MAX)) {
                    ++state;
                    i1 = Integer.MAX_VALUE;
                    continue;
                }
                if (state == 3 && dbms.isClickHouse() && !Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_RIGHT_PAREN)) {
                    if (!(((CharSequence)vague).length() == 0)) {
                        vague.append(", ");
                    }
                    vague.append(text);
                    continue;
                }
                if (state == 4 && this.isNumeric(type)) {
                    ++state;
                    i2 = StringUtil.parseInt((String)text, (int)i2);
                    continue;
                }
                if (state == 4 && type instanceof SqlKeywordTokenType) {
                    ++state;
                    unit = LengthUnit.of((String)text);
                    continue;
                }
                if (state > 2 && Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_RIGHT_PAREN)) {
                    state = 10;
                    continue;
                }
                if (state >= 11 || !Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_TYPE_SUFFIX)) continue;
                state = 11;
                suffix = text;
            }
            String name = DasUtil.NO_NAME;
            if (!(((CharSequence)this.myTypeName).length() == 0)) {
                name = this.myTypeName.toString();
            }
            if (!(((CharSequence)vague).length() == 0)) {
                DataType dataType5 = DataTypeFactory.ofArgs((String)this.mySchema, (String)name, (String)vague.toString(), (boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)dataType5, (String)"ofArgs(...)");
                return dataType5;
            }
            DataType dataType6 = DataTypeFactory.of((String)this.mySchema, (String)name, (int)i1, (int)i2, unit, suffix, (unit != null ? 1 : 0) != 0, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)dataType6, (String)"of(...)");
            DataType dataType7 = dataType6;
            if (setof) {
                DataType dataType8 = DataTypeFactory.of(null, (String)"setof", (int)-1, (int)0, null, (String)dataType7.getSpecification(), (boolean)false, (boolean)false);
                dataType = dataType8;
                Intrinsics.checkNotNullExpressionValue((Object)dataType8, (String)"of(...)");
            } else {
                dataType = dataType7;
            }
            return dataType;
        }

        @NotNull
        public final String parseGenericType(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            PsiElement $this$child$iv = (PsiElement)this.myElement;
            boolean $i$f$child = false;
            SqlTypeParameterList sqlTypeParameterList = (SqlTypeParameterList)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlTypeParameterList.class);
            if (sqlTypeParameterList == null) {
                return text;
            }
            SqlTypeParameterList parameterList = sqlTypeParameterList;
            StringBuilder sb = new StringBuilder(text).append("<");
            boolean first = true;
            boolean hasIdent = false;
            PsiElement[] psiElementArray = parameterList.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            for (PsiElement psiElement : psiElementArray) {
                Intrinsics.checkNotNull((Object)psiElement);
                PsiElement child = psiElement;
                IElementType type = PsiTreeUtilKt.getElementType((PsiElement)child);
                if (Intrinsics.areEqual((Object)type, (Object)SqlCommonTokens.SQL_COLON)) {
                    sb.append(child.getText());
                }
                if (Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_IDENT) || type instanceof SqlIdentifierKeywordTokenType) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    hasIdent = true;
                    sb.append(child.getText());
                    continue;
                }
                if (!(child instanceof SqlTypeElement)) continue;
                if (!hasIdent) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(((SqlTypeElement)child).getDasType().getSpecification());
            }
            String string = sb.append(">").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public final boolean isGenericType() {
            PsiElement $this$child$iv = (PsiElement)this.myElement;
            boolean $i$f$child = false;
            return PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlTypeParameterList.class) != null;
        }

        public final void parseTypeAndSchema(@NotNull SqlReferenceExpression cur) {
            Intrinsics.checkNotNullParameter((Object)cur, (String)"cur");
            String string = Companion.getNameAsIs(cur);
            if (string == null) {
                string = "";
            }
            this.myTypeName.append(string);
            SqlExpression sqlExpression = cur.getQualifierExpression();
            this.mySchema = Companion.getNameAsIs(sqlExpression instanceof SqlReferenceExpression ? (SqlReferenceExpression)sqlExpression : null);
        }

        public final boolean isNumeric(@Nullable IElementType type) {
            return Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL) || Intrinsics.areEqual((Object)type, (Object)SqlTokens.SQL_INTEGER_TOKEN);
        }

        @Nullable
        public final String getEnumVagueArgs() {
            PsiElement $this$child$iv = (PsiElement)this.myElement;
            boolean $i$f$child = false;
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlExpressionList.class);
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)child).filter(SqlExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable items = jBIterable;
            return StringUtil.nullize((String)CollectionsKt.joinToString$default((Iterable)((Iterable)items), (CharSequence)", ", null, null, (int)0, null, DataTypeParser::_get_enumVagueArgs_$lambda$0, (int)30, null));
        }

        @NotNull
        public final List<String> getEnumArgs() {
            PsiElement $this$child$iv = (PsiElement)this.myElement;
            boolean $i$f$child = false;
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)$this$child$iv, SqlExpressionList.class);
            JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)child).filter(SqlExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable items = jBIterable;
            List list = items.map(arg_0 -> DataTypeParser._get_enumArgs_$lambda$1(DataTypeParser::_get_enumArgs_$lambda$0, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            return list;
        }

        private static final CharSequence _get_enumVagueArgs_$lambda$0(SqlExpression it) {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return string;
        }

        private static final String _get_enumArgs_$lambda$0(SqlExpression it) {
            return it.getText();
        }

        private static final String _get_enumArgs_$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001e\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/psi/impl/SqlTypeElementBase$DataTypeParser$Companion;", "", "<init>", "()V", "getNameAsIs", "", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "spAppend", "", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "intellij.database.sql.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final String getNameAsIs(@Nullable SqlReferenceExpression ref) {
                SqlReferenceExpression sqlReferenceExpression = ref;
                return sqlReferenceExpression != null && (sqlReferenceExpression = sqlReferenceExpression.getIdentifier()) != null ? sqlReferenceExpression.getText() : null;
            }

            private final void spAppend(StringBuilder b, String text) {
                StringBuilder stringBuilder = !(((CharSequence)b).length() == 0) ? b.append(' ').append(text) : b.append(text);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

