/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs.serializers;

import com.intellij.database.Dbms;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.serialization.PropertiesTracker;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementType;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.serializers.SqlDefinitionStubSerializer;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDefinitionExStubSerializer<S extends SqlDefinitionStub<T>, T extends SqlDefinition>
extends SqlDefinitionStubSerializer<S, T> {
    @Contract(value="_ -> new")
    @NotNull
    public static SqlDefinitionStubSerializer<?, ?> getDefinitionStubSerializer(@NotNull SqlElementType elementType) {
        if (elementType == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(0);
        }
        return new SqlDefinitionExStubSerializer(elementType);
    }

    public SqlDefinitionExStubSerializer(@NotNull SqlElementType elementType) {
        if (elementType == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(1);
        }
        super(elementType);
    }

    @Override
    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(3);
        }
        super.indexStub(stub, sink);
    }

    @Override
    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(4);
        }
        if (dataStream == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(5);
        }
        super.serialize(stub, dataStream);
        SqlDefinitionExStubSerializer.saveProperties(dataStream, ((SqlDefinitionStub)((Object)stub)).getElement(), ((SqlDefinitionStub)((Object)stub)).getProperties());
    }

    @Override
    @NotNull
    public S deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(6);
        }
        return (S)((Object)new SqlDefinitionStub(parentStub, this.elementType, dataStream.readName(), SqlDefinitionExStubSerializer.loadProperties(parentStub, dataStream)));
    }

    public static void saveProperties(@NotNull StubOutputStream dataStream, @NotNull BasicElement element, @NotNull Map<String, String> properties) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(7);
        }
        if (element == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(9);
        }
        SqlDefinitionExStubSerializer.saveMetaObject(dataStream, element.getMetaObject());
        ArrayList objProps = new ArrayList();
        element.exportProperties((n, v) -> objProps.add(new NameValue(n, v)));
        dataStream.writeVarInt(properties.size() + objProps.size());
        for (NameValue nameValue : objProps) {
            dataStream.writeName(nameValue.getName());
            dataStream.writeUTFFast(nameValue.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            dataStream.writeName((String)entry.getKey());
            dataStream.writeUTFFast((String)entry.getValue());
        }
    }

    protected static void saveMetaObject(@NotNull StubOutputStream dataStream, BasicMetaObject<?> meta) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(10);
        }
        for (BasicMetaObject tmp = meta; tmp != null; tmp = tmp.getParent()) {
            dataStream.writeName(tmp.kind.code());
        }
    }

    @NotNull
    public static SqlDefinitionStub.ModelInfo loadProperties(@Nullable StubElement<?> parent, @NotNull StubInputStream dataStream) throws IOException {
        if (dataStream == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(11);
        }
        BasicMetaModel metaModel = DbImplUtilCore.getMetaModel((Dbms)SqlDefinitionExStubSerializer.getDbms(parent));
        BasicMetaObject<?> meta = SqlDefinitionExStubSerializer.loadMetaObject(metaModel, dataStream);
        BasicModElement element = (BasicModElement)meta.newDataObject();
        int cnt = dataStream.readVarInt();
        if (cnt == 0) {
            return new SqlDefinitionStub.ModelInfo((BasicElement)element, Collections.emptyMap());
        }
        HashMap<String, String> objectProps = new HashMap<String, String>();
        for (int i2 = 0; i2 < cnt; ++i2) {
            String prop = dataStream.readNameString();
            if (prop == null) {
                throw new IOException("Prop name is null");
            }
            String value = dataStream.readUTFFast();
            objectProps.put(prop, value);
        }
        PropertiesTracker tracker = new PropertiesTracker(objectProps);
        element.importProperties((NameValueGetter)tracker);
        for (String prop : tracker.getConsumed()) {
            objectProps.remove(prop);
        }
        return new SqlDefinitionStub.ModelInfo((BasicElement)element, Map.copyOf(objectProps));
    }

    @NotNull
    protected static Dbms getDbms(@Nullable StubElement<?> parent) throws IOException {
        SqlLanguageDialect dialect;
        while (parent != null && !(parent instanceof PsiFileStub)) {
            parent = parent.getParentStub();
        }
        PsiFileStub fileStub = (PsiFileStub)ObjectUtils.tryCast(parent, PsiFileStub.class);
        SqlLanguageDialect sqlLanguageDialect = dialect = fileStub == null ? null : (SqlLanguageDialect)ObjectUtils.tryCast((Object)fileStub.getFileElementType().getLanguage(), SqlLanguageDialect.class);
        if (dialect == null) {
            throw new IOException("No sql language");
        }
        Dbms dbms = dialect.getDbms();
        if (dbms == null) {
            SqlDefinitionExStubSerializer.$$$reportNull$$$0(12);
        }
        return dbms;
    }

    private static BasicMetaObject<?> loadMetaObject(BasicMetaModel<?> metaModel, StubInputStream dataStream) throws IOException {
        ArrayList<ObjectKind> path = new ArrayList<ObjectKind>(6);
        while (true) {
            String code;
            ObjectKind kind;
            if ((kind = ObjectKind.getKind((String)(code = dataStream.readNameString()))) == null) {
                throw new IOException("No kind " + code);
            }
            if (kind == ObjectKind.ROOT) break;
            path.add(kind);
        }
        BasicMetaObject meta = metaModel.root;
        for (int i2 = path.size() - 1; i2 >= 0; --i2) {
            ObjectKind kind = (ObjectKind)path.get(i2);
            BasicMetaObject next = BasicMetaUtils.findChild((BasicMetaObject)meta, (ObjectKind)kind);
            if (next == null) {
                throw new IOException("No " + kind.code() + " in " + meta.toString());
            }
            meta = next;
        }
        return meta;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/serializers/SqlDefinitionExStubSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/serializers/SqlDefinitionExStubSerializer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefinitionStubSerializer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveMetaObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadProperties";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

