/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DbmsExtension;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbTestUtils {
    public static final PluginDescriptor ourDescriptor = new DefaultPluginDescriptor(PluginId.getId((String)"database.tests"), DbTestUtils.class.getClassLoader());
    public static final ComponentManager ourFakeComponentManager = new ComponentManager(){

        public <T> T getComponent(@NotNull Class<T> interfaceClass) {
            if (interfaceClass == null) {
                1.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        public boolean hasComponent(@NotNull Class<?> interfaceClass) {
            if (interfaceClass == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        public boolean isInjectionForExtensionSupported() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public MessageBus getMessageBus() {
            throw new UnsupportedOperationException();
        }

        public boolean isDisposed() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Condition<?> getDisposed() {
            throw new UnsupportedOperationException();
        }

        public <T> T getService(@NotNull Class<T> serviceClass) {
            if (serviceClass == null) {
                1.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public ExtensionsArea getExtensionArea() {
            throw new UnsupportedOperationException();
        }

        public <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull PluginId pluginId) {
            if (aClass == null) {
                1.$$$reportNull$$$0(3);
            }
            if (pluginId == null) {
                1.$$$reportNull$$$0(4);
            }
            return (T)ReflectionUtil.newInstance(aClass);
        }

        public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
            if (aClass == null) {
                1.$$$reportNull$$$0(5);
            }
            if (key == null) {
                1.$$$reportNull$$$0(6);
            }
            if (pluginId == null) {
                1.$$$reportNull$$$0(7);
            }
            throw new UnsupportedOperationException();
        }

        @NotNull
        public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
            if (error == null) {
                1.$$$reportNull$$$0(8);
            }
            if (pluginId == null) {
                1.$$$reportNull$$$0(9);
            }
            return new RuntimeException(error);
        }

        @NotNull
        public RuntimeException createError(@NotNull String message, @NotNull PluginId pluginId) {
            if (message == null) {
                1.$$$reportNull$$$0(10);
            }
            if (pluginId == null) {
                1.$$$reportNull$$$0(11);
            }
            return new RuntimeException(message);
        }

        @NotNull
        public RuntimeException createError(@NotNull String message, @Nullable Throwable error, @NotNull PluginId pluginId, @Nullable Map<String, String> attachments) {
            if (message == null) {
                1.$$$reportNull$$$0(12);
            }
            if (pluginId == null) {
                1.$$$reportNull$$$0(13);
            }
            return new RuntimeException(message, error);
        }

        @NotNull
        public <T> Class<T> loadClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
            if (className == null) {
                1.$$$reportNull$$$0(14);
            }
            if (pluginDescriptor == null) {
                1.$$$reportNull$$$0(15);
            }
            Class<?> clazz = pluginDescriptor.getClassLoader().loadClass(className);
            if (clazz == null) {
                1.$$$reportNull$$$0(16);
            }
            return clazz;
        }

        @NotNull
        public <T> T instantiateClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) {
            T t;
            if (className == null) {
                1.$$$reportNull$$$0(17);
            }
            if (pluginDescriptor == null) {
                1.$$$reportNull$$$0(18);
            }
            try {
                t = this.instantiateClass(this.loadClass(className, pluginDescriptor), pluginDescriptor.getPluginId());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (t == null) {
                1.$$$reportNull$$$0(19);
            }
            return t;
        }

        @NotNull
        public ActivityCategory getActivityCategory(boolean isExtension) {
            throw new UnsupportedOperationException();
        }

        public void dispose() {
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                1.$$$reportNull$$$0(20);
            }
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
            if (key == null) {
                1.$$$reportNull$$$0(21);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 16, 19 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serviceClass";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginId";
                    break;
                }
                case 6: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 14: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 15: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbTestUtils$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbTestUtils$1";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadClass";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiateClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "hasComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getService";
                    break;
                }
                case 3: 
                case 4: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateClass";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateClassWithConstructorInjection";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createError";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "loadClass";
                    break;
                }
                case 16: 
                case 19: {
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "getUserData";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "putUserData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 16, 19 -> new IllegalStateException(string);
            };
        }
    };
    private static final LazyInitializer.LazyValue<ModuleClassLoaderHelper> helper = LazyInitializer.create(ModuleClassLoaderHelper::createClassLoaderHelper);

    @TestOnly
    @NotNull
    public static <T> JBIterable<T> loadBeans(String epName, Class<? extends T> clazz) {
        JBIterable jBIterable;
        String shortName = StringUtil.getShortName((String)epName);
        String descriptorPath = "META-INF/AllDatabaseDialects.xml";
        ClassLoader loader = DbTestUtils.getClassLoader();
        URL xml = loader.getResource(descriptorPath);
        if (xml == null) {
            descriptorPath = "META-INF/AllDatabaseDialectsCore.xml";
            xml = loader.getResource(descriptorPath);
        }
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + descriptorPath));
        }
        try {
            class MyOrderable
            implements LoadingOrder.Orderable {
                final T bean;
                final String orderId;
                final LoadingOrder order;
                final /* synthetic */ Class val$clazz;

                MyOrderable(XmlContent xmlContent) {
                    this.val$clazz = xmlContent;
                    this.bean = XmlSerializer.deserialize((Element)e.content, (Class)this.val$clazz);
                    if (this.bean instanceof PluginAware) {
                        ((PluginAware)this.bean).setPluginDescriptor(e.getPluginDescriptor());
                    }
                    this.orderId = e.content.getAttributeValue("id");
                    this.order = LoadingOrder.readOrder((String)e.content.getAttributeValue("order"));
                }

                @Nullable
                public String getOrderId() {
                    return this.orderId;
                }

                @NotNull
                public LoadingOrder getOrder() {
                    LoadingOrder loadingOrder = this.order;
                    if (loadingOrder == null) {
                        MyOrderable.$$$reportNull$$$0(0);
                    }
                    return loadingOrder;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbTestUtils$1MyOrderable", "getOrder"));
                }
            }
            JBIterable extensions = DbTestUtils.expandPlugin(loader, xml).flatten(e2 -> DbTestUtils.expandExtensions(e2));
            List list = (List)extensions.filter(e -> e.content.getName().endsWith(shortName)).filter(e -> epName.equals(StringUtil.getQualifiedName((String)e.content.getParentElement().getAttributeValue("defaultExtensionNs"), (String)e.content.getName()))).map(x$0 -> new MyOrderable(x$0, clazz)).addAllTo(new ArrayList());
            LoadingOrder.Companion.sortByLoadingOrder(list);
            JBIterable result = JBIterable.from((Iterable)list).map(o -> o.bean).collect();
            if (result.isEmpty()) {
                throw new AssertionError((Object)(epName + " is empty in " + descriptorPath));
            }
            jBIterable = result;
        }
        catch (Exception e3) {
            throw new AssertionError("Failed to load '" + epName + "' list", e3);
        }
        if (jBIterable == null) {
            DbTestUtils.$$$reportNull$$$0(0);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<XmlContent> expandPlugin(ClassLoader loader, URL xml) {
        Element loaded;
        try (InputStream stream = xml.openStream();){
            loaded = JDOMUtil.load((InputStream)stream);
        }
        catch (Exception e) {
            throw new AssertionError("Failed to load " + String.valueOf(xml), e);
        }
        return DbTestUtils.expandXml(new XmlContent(loader, loaded));
    }

    @NotNull
    private static JBIterable<XmlContent> expandExtensions(XmlContent e) {
        JBIterable jBIterable = JBIterable.from((Iterable)e.content.getChildren("extensions")).flatten(ex -> ex.getChildren()).map(c -> new XmlContent(e.loader, (Element)c));
        if (jBIterable == null) {
            DbTestUtils.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<XmlContent> expandXml(XmlContent e) {
        JBIterable jBIterable = JBIterable.of((Object)e).append(DbTestUtils.expandContent(e)).append(DbTestUtils.expandXInclude(e));
        if (jBIterable == null) {
            DbTestUtils.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<XmlContent> expandContent(XmlContent e) {
        JBIterable jBIterable = JBIterable.from((Iterable)e.content.getChildren("content")).flatten(c -> c.getChildren("module")).flatten(m -> DbTestUtils.expandContentModule(e.loader, m.getAttributeValue("name")));
        if (jBIterable == null) {
            DbTestUtils.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<XmlContent> expandXInclude(XmlContent e) {
        JBIterable jBIterable = JBIterable.from((Iterable)e.content.getChildren("include", JDOMUtil.XINCLUDE_NAMESPACE)).flatten(x -> DbTestUtils.expandXInclude(e.loader, x.getAttributeValue("href")));
        if (jBIterable == null) {
            DbTestUtils.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<XmlContent> expandXInclude(ClassLoader loader, String href) {
        String path = href.startsWith("/") ? href.substring(1) : href;
        URL xml = loader.getResource(path);
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + href));
        }
        return DbTestUtils.expandPlugin(loader, xml);
    }

    @NotNull
    private static JBIterable<XmlContent> expandContentModule(ClassLoader loader, String name) {
        String moduleXml = name.replace("/", ".") + ".xml";
        ClassLoader moduleLoader = DbTestUtils.getClassLoader(loader, name);
        URL xml = moduleLoader.getResource(moduleXml);
        if (xml == null) {
            throw new AssertionError((Object)("descriptor not found: " + name));
        }
        return DbTestUtils.expandPlugin(moduleLoader, xml);
    }

    @NotNull
    private static ClassLoader getClassLoader(@NotNull ClassLoader classLoader, @NotNull String moduleId) {
        if (classLoader == null) {
            DbTestUtils.$$$reportNull$$$0(5);
        }
        if (moduleId == null) {
            DbTestUtils.$$$reportNull$$$0(6);
        }
        if (classLoader instanceof PluginAwareClassLoader) {
            PluginAwareClassLoader pa = (PluginAwareClassLoader)classLoader;
            ClassLoader classLoader2 = Objects.requireNonNull(DbTestUtils.getClassLoader(pa, moduleId));
            if (classLoader2 == null) {
                DbTestUtils.$$$reportNull$$$0(7);
            }
            return classLoader2;
        }
        ClassLoader classLoader3 = classLoader;
        if (classLoader3 == null) {
            DbTestUtils.$$$reportNull$$$0(8);
        }
        return classLoader3;
    }

    @Nullable
    private static ClassLoader getClassLoader(PluginAwareClassLoader pa, @NotNull String moduleId) {
        if (moduleId == null) {
            DbTestUtils.$$$reportNull$$$0(9);
        }
        return ((ModuleClassLoaderHelper)helper.get()).getClassLoader(pa, moduleId);
    }

    @NotNull
    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = DbmsExtension.class.getClassLoader();
        if (classLoader == null) {
            DbTestUtils.$$$reportNull$$$0(10);
        }
        return classLoader;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DbTestUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBeans";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "expandExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "expandXml";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "expandContent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "expandXInclude";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DbTestUtils";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassLoader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 9 -> new IllegalArgumentException(string);
        };
    }

    private record XmlContent(@NotNull ClassLoader loader, @NotNull Element content) {
        @NotNull
        private final ClassLoader loader;
        @NotNull
        private final Element content;

        private XmlContent(@NotNull ClassLoader loader, @NotNull Element content) {
            if (loader == null) {
                XmlContent.$$$reportNull$$$0(0);
            }
            if (content == null) {
                XmlContent.$$$reportNull$$$0(1);
            }
        }

        PluginDescriptor getPluginDescriptor() {
            ClassLoader classLoader = this.loader;
            if (classLoader instanceof PluginAwareClassLoader) {
                PluginAwareClassLoader pa = (PluginAwareClassLoader)classLoader;
                return pa.getPluginDescriptor();
            }
            return ourDescriptor;
        }

        @NotNull
        public ClassLoader loader() {
            ClassLoader classLoader = this.loader;
            if (classLoader == null) {
                XmlContent.$$$reportNull$$$0(2);
            }
            return classLoader;
        }

        @NotNull
        public Element content() {
            Element element = this.content;
            if (element == null) {
                XmlContent.$$$reportNull$$$0(3);
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/DbTestUtils$XmlContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/DbTestUtils$XmlContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loader";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ModuleClassLoaderHelper {
        @Nullable
        public ClassLoader getClassLoader(PluginAwareClassLoader var1, @NotNull String var2);

        @NotNull
        private static ModuleClassLoaderHelper createClassLoaderHelper() {
            ModuleClassLoaderHelper helper;
            try {
                Class<?> helperClass = Class.forName("com.intellij.database.util.ModuleClassLoaderHelperImpl", true, DbmsExtension.class.getClassLoader());
                helper = (ModuleClassLoaderHelper)ReflectionUtil.newInstance(helperClass);
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError("Failed to load helper", e);
            }
            ModuleClassLoaderHelper moduleClassLoaderHelper = helper;
            if (moduleClassLoaderHelper == null) {
                ModuleClassLoaderHelper.$$$reportNull$$$0(0);
            }
            return moduleClassLoaderHelper;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/util/DbTestUtils$ModuleClassLoaderHelper", "createClassLoaderHelper"));
        }
    }
}

