/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerSplitActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
public class XAddToWatchesFromEditorActionHandler
extends XDebuggerSplitActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        Promise<String> textPromise;
        if (session == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(1);
        }
        if ((textPromise = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session)).getState() == Promise.State.PENDING) {
            return true;
        }
        if (textPromise.getState() == Promise.State.REJECTED) {
            return false;
        }
        try {
            return textPromise.blockingGet(0) != null;
        }
        catch (ExecutionException | TimeoutException e) {
            return false;
        }
    }

    @NotNull
    protected static Promise<String> getTextToEvaluate(DataContext dataContext, XDebugSessionProxy session) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(2);
            }
            return promise;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text != null) {
            Promise promise = Promises.resolvedPromise((Object)StringUtil.nullize((String)text, (boolean)true));
            if (promise == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(3);
            }
            return promise;
        }
        XDebuggerEvaluator evaluator = session.getCurrentEvaluator();
        if (evaluator != null) {
            Promise promise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor).then(s -> StringUtil.nullize((String)s, (boolean)true));
            if (promise == null) {
                XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(4);
            }
            return promise;
        }
        Promise promise = Promises.resolvedPromise(null);
        if (promise == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(5);
        }
        return promise;
    }

    @Override
    protected void perform(@NotNull XDebugSessionProxy session, @NotNull DataContext dataContext) {
        if (session == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            XAddToWatchesFromEditorActionHandler.$$$reportNull$$$0(7);
        }
        XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session).onSuccess(text -> {
            if (text == null) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                XDebugSessionTab tab = (XDebugSessionTab)session.getSessionTab();
                if (tab != null) {
                    ((XWatchesViewImpl)tab.getWatchesView()).addWatchExpression(XExpressionImpl.fromText(text), -1, true, true);
                }
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XAddToWatchesFromEditorActionHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToEvaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

